/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "langhtml.h"

LangHtml::LangHtml() {fill();}
LangHtml::~LangHtml(){}

void LangHtml::fill() {

 keys.push_back("action");
 keys.push_back("align");
 keys.push_back("alink");
 keys.push_back("alt");
 keys.push_back("a");
 keys.push_back("&amp");
 keys.push_back("bgcolor");
 keys.push_back("body");
 keys.push_back("border");
 keys.push_back("br");
 keys.push_back("center");
 keys.push_back("&copy");
 keys.push_back("content");
 keys.push_back("!doctype");
 keys.push_back("enctype");
 keys.push_back("form");
 keys.push_back("head");
 keys.push_back("height");
 keys.push_back("href");
 keys.push_back("hr");
 keys.push_back("html");
 keys.push_back("img");
 keys.push_back("language");
 keys.push_back("link");
 keys.push_back("meta");
 keys.push_back("method");
 keys.push_back("name");
 keys.push_back("noshade");
 keys.push_back("?php");
 keys.push_back("pre");
 keys.push_back("script");
 keys.push_back("size");
 keys.push_back("src");
 keys.push_back("table");
 keys.push_back("text");
 keys.push_back("title");
 keys.push_back("td");
 keys.push_back("tr");
 keys.push_back("version");
 keys.push_back("vlink");
 keys.push_back("width");
 keys.push_back("?xml");
}

void LangHtml::keyCheck(string &buffer, string colour){

// if(buffer[0] == '#') {return;}

 int index;

 for(int i=0; i < (int)keys.size(); i++) {

  index = buffer.find(keys[i], 0);

  while(index < string::npos) {
//   if(index != -1) {
   if(index != -1 && isInsideTag(buffer,index)) {
    if(iskey(buffer, index-1, (index) + keys[i].size())) {
     buffer.insert(index, "<b><font COLOR=" + colour + ">");
     buffer.insert(index+keys[i].size()+23, "</font></b>");
    }
//    index = buffer.find(keys[i], (index + keys[i].size() + 23));
   }
    index = buffer.find(keys[i], (index + keys[i].size() + 23));
  }
 }
}

bool LangHtml::isInsideTag(string buffer, int index) {

 int open;
 int close;

 open  = buffer.find("&lt;",0);
 close = buffer.find("&gt;",open);

 if(open != -1) {

  while(close < index && open < string::npos) {
   open = buffer.find("&lt;",close);
   close = buffer.find("&gt;",open);
  }

  if(open < index && close > index) {
    return true;
  }

 } else return false;

 return false;
}
