/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include "hypersystem.h"

HyperSystem::HyperSystem() {}
HyperSystem::~HyperSystem() {}


void HyperSystem::tagMe(string &buffer) {

 int index;
 index = buffer.find("TagMe:",0);
 if(index == -1) {return;}

 buffer.erase(index,6);

 for(int i=index; i < buffer.size(); i++) {
  if (buffer.substr(i,4) == "&lt;") buffer.replace(i,4, "<");
  else if (buffer.substr(i,4) == "&gt;") buffer.replace(i,4, ">");
 }

}

void HyperSystem::nameMe(string &buffer) {

 int index;
 index = buffer.find("NameMe:",0);
 if(index == -1) {return;}

 string name;
 name = buffer.substr(index+7);
 buffer.erase(index, buffer.size() - index);

 buffer.insert(0, "<a name=\"" + name + "\">");
 buffer += "</a>";
}

void HyperSystem::linkMe(string &buffer) {

 int index;
 index = buffer.find("LinkMe:",0);
 if(index == -1) {return;}

 string link;
 link = buffer.substr(index+7);
 buffer.erase(index, buffer.size() - index);

 buffer.insert(0, "<a href=\"" + link + "\">");
 buffer += "</a>";
}

void HyperSystem::includeMe(string &buffer) {

 int incl, insr;

 incl = buffer.find("#include",0);
 if(incl != -1) {

  insr = buffer.find("\"",incl+1);
  if(insr != -1) {
   string link;
   link = buffer.substr(insr);
   link = link.substr(0,link.find("\"</font>"));
   link = "<a href=" + link + ".html\">";

   buffer.insert(insr, link);
   buffer.insert(buffer.size(),"</a>");
  }
 }
}
