/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <iostream>
#include <cstdlib>
#include "help.h"
using namespace std;

//-----------------------------------------------------------------------------
Help::Help()  {}
Help::~Help() {}
//-----------------------------------------------------------------------------
// displays the usage and exits------------------------------------------------
void Help::helpme() {

 string usage;
 usage = "\
Usage: $ webcpp <inputfile.cpp> <outputfile.html> [options...]\n\
\n\
Valid options:\n\
  -c=<scheme.scs>    Use a native colour scheme file.\n\
  -C=<scheme.css>    Use a stylesheet as a colour scheme.\n\
  -w=<scheme.scs>    The works, same as -m -l -h -c=<scheme.scs>.\n\
  -p=<filename>      Use a picture for the background.\n\
  -t=<extension>     Forces the syntax highligting type.\n\
\n\
  -l,--line-numbers  Print the line numbers in the left margin.\n\
  -s,--set-colours   Set the colours manually.\n\
  -m,--made-with     Show made with webcpp footer.\n\
  -h,--hyperlink     Create hyperlinks to #include files (C/C++).\n\
  -d,--dupe          Duplicate the file (like cp).\n\
  -b,--backup        Backup the existing html file.\n\
  - ,--pipe          Use STDIN or STDOUT in place of the filename.\n\
\n\
               ! Examples !\n\
 $ webcpp polygon.java polygon.html -l -c=neon.scs\n\
 $ cat *.h *.cpp | webcpp - - -t=cpp >everything.html\n";


 cerr << "\aWeb C Plus Plus ver. 0.6.7  "
      << "Copyright (C)2001, (C)2002 Jeffrey Bakker\n"
      << "Compiled on " << __DATE__ << " at " << __TIME__ << "\n\n"
      << usage;

/*
 in.open(text.data()); // open the file for reading
 if (!in) {cerr << "help file could not be found\n";}

 getline(in, linebuf); // read the file line by line
 while(in) {           // repeat while not end of file

  cerr << linebuf << endl;  // display line by line
  getline(in, linebuf);
 }
*/

 exit(1);
} //---------------------------------------------------------------------------


