/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "gangbanger.h"

GangBanger::GangBanger() {

 buffer  = "";
 picture = "";
 lncnt  = 1;
 filetype = 9;

 incomment = false;
 instring  = false;

 made    = false;
 margin  = false;
 redir_I = false;
 redir_O = false;
 cssfile = "";
 csson = false;
}

GangBanger::~GangBanger() {}

//-----------------------------------------------------------------------------
void GangBanger::tagCheck() {

 int S,F;
 int erase1, erase2;

 S = buffer.find("&lt;",0);
 F = buffer.find("&gt;",S);

// fIO.ofile << "checkpoint 1\n";

 while (S < string::npos) {
//   fIO.ofile << "checkpoint 2\n";
  if(S != -1 && F != -1) {
//    fIO.ofile << "checkpoint 3\n";


   // erase all the colours previously made inside the string
   erase1 = buffer.find("<font COLOR=#",S);
   erase2 = buffer.find("</font>",S);

   while(erase1 != -1 && erase2 < F) {

    erase1 = buffer.find("<font COLOR=#",S);
    if(erase1 != -1 && erase1 < F) {
     buffer.erase(erase1,20);
    }
    erase2 = buffer.find("</font>",S);
    if(erase2 != -1 && erase2 < F) {
     buffer.erase(erase2,7);
    }

    erase1 = buffer.find("<b>",S);
    if(erase1 != -1 && erase1 < F) {
     buffer.erase(erase1,3);
    }
    erase2 = buffer.find("</b>",S);
    if(erase2 != -1 && erase2 < F) {
     buffer.erase(erase2,4);
    }
   }
   colour_TAG(S,F);
   S = buffer.find("&lt;",F +22);
   F = buffer.find("&gt;",S +1);
  } else S = string::npos;
 }

}

void GangBanger::colour_TAG(int indexS, int indexF) {

 string fntag = "<font COLOR=" + ColourOf.PreProcessor() + ">";

 if(cssfile != "") {fntag = "<font CLASS=comment>";}

 buffer.insert(indexS, fntag);

 indexF += 24;
 buffer.insert(indexF, "</font>");
}
void GangBanger::cmntCheck() {}

// the syntax highlight checking ----------------------------------------------
void GangBanger::Colourizer() {

 if(redir_I) {getline(cin,buffer);}
 else  {getline(fIO.ifile,buffer);}
 buffer = buffer + "";

 if(margin) {
  mkMargin();
 }

 Angle_Brackets();
 tagCheck();   // check for tags
// numCheck();   // check and colour numbers, if any
 keysCheck();  // and keywords
 strCheck();   // and strings

 if(redir_O) {cout << buffer << endl;}
 else   {fIO.ofile << buffer << endl;}
 buffer = "";
 lncnt++;
}//----------------------------------------------------------------------------
