/* webCpp
 * Copyright (C) 2002 Jeffrey Bakker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef COLOUR_H
#define COLOUR_H

#include <string>
#include <vector>
#include "cffile.h"
using namespace std;

class Colour
{
 // data members -------------------------------------------------------------------------
 protected:

  vector<string> Colours;
  CFfile SCS;
 // --------------------------------------------------------------------------------------
 // constructors -------------------------------------------------------------------------
 public:

  Colour();
  Colour(string scsfile);

  void create();
  void def_sc();
  void schemeIt(string Scheme);
  bool verifyData(string);

  // the following methods set the colours individually ----------------------------------
  void setColour(string colour, int num);
  void setAllColours();
  // -------------------------------------------------------------------------------------
  // the following methods return the colour ---------------------------------------------
  string BackGround()   {return Colours[0];}
  string PreProcessor() {return Colours[1];}
  string NormalText()   {return Colours[2];}
  string KeyWords()     {return Colours[3];}
  string Numbers()      {return Colours[4];}
  string Characters()   {return Colours[5];}
  string Comments()     {return Colours[6];}
  // -------------------------------------------------------------------------------------
};

#endif  // COLOUR_H
