/*--------------------------------------------------------------------------
 |  MDECODE.C - Decodes a subject sorted file containing multiple
 |              uuencoded files.
 |
 |  This file is supposed to be used as a filter for decoding  a large
 |  ascii file containing various uuencoded files. The normal operation
 |  mode is:
 |  
 |  1) I suppose you have a big file, containing lots of encoded files.
 |     and these files are the product of a large tag + save to file
 |     operation from a newsreader.
 |  2) Set your MUA to "Order messages by Subject".
 |  3) Pipe ALL messages to this program
 |
 |  (C) 1995 by Marco Paganini (paganini@embratel.net.br).
 +------------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

void    main(int ac, char **av);
int		valid_uuline(char *str);
char	*parse_field(char *str, int fieldno, char *delim);
void	help(void);

#define DEFAULT_DECODER "uudecode"

/** The Global Stuff **/

static	int		Verbose;

void    main(ac, av)
int     ac;
char    **av;
{
    static	char    buf[100];
    static	char	filename[20];
	static	char	uucmd[100];
	static	char	uuprogram[40];

	char	*pstr;
	char	*enc_file;
	int		filecount = 0;
	int		file_open = 0;
	int		ignored_lines;
	int		ret;
	int		ix;

	FILE	*fp;

	Verbose = 1;
	strcpy(uuprogram, DEFAULT_DECODER);

	/** Check the command line **/

	for (ix = 1; ix < ac; ix++)
	{
		if (av[ix][0] == '-')
		{
			switch(av[ix][1])
			{
				/** Silent? **/

				case	's':
					Verbose = 0;
					break;

				/** Program to use instead of uuencode **/

				case 	'p':	
					strcpy(uuprogram, (av[ix] + 2));
					break;

				/** Help **/

				case	'h':
					help();
					exit(1);
			}
		}
	}


	if (Verbose)
		fprintf(stderr, "Using \"%s\" to decode uuencoded files\n", uuprogram);


	while(fgets(buf, sizeof(buf) - 1, stdin) != NULL)
	{
		if ((pstr = strchr(buf, '\n')) != NULL)
			*pstr = '\0';

		/*
		**	Only the valid uudecode lines are checked 
		*/

		if (valid_uuline(buf))
		{
			/** Begin: open a new temp file and start dumping **/

			if (strncmp(buf, "begin", 5) == 0)
			{
				/*
				**	If we have a file open, then we didn't find the
				**	last 'end'. Assume the last file is incomplete
				**	and delete it.
				*/

				if (file_open)	
				{
					fprintf(stderr, "Warning: File %s (%s) is incomplete (no end line). Please check.\n",
							enc_file,
							filename);

					unlink(filename);
					file_open = 0;
					fclose(fp);
				}

				/** Name of the encoded file **/
				enc_file = parse_field(buf, 3, " ");

				/** Next temporary filename **/
				sprintf(filename, "uu%d.uue", filecount++);

				if ((fp = fopen(filename, "w")) == NULL)
				{
					perror(filename);
					fclose(fp);
					exit(1);
				}

				file_open = 1;
			}			

			/*
			**	If we do not have an open file but we have a
			**	valid uudecode line, then we have invalid line.
			**  (probably a file without a 'begin')
			*/

			if (file_open)
				fprintf(fp, "%s\n", buf);
			else
				++ignored_lines;

			/** The 'end' line terminates the file immediately **/

			if (strncmp(buf, "end", 3) == 0)
			{
				fclose(fp);
				file_open = 0;

				/** Now we uudecode the file **/
				
				sprintf(uucmd, "%s %s", uuprogram, filename);

				if ((ret = system(uucmd)) != 0)
				{
					fprintf(stderr, "Warning: %s returned (%d) for %s (%s). Please check.\n",
						uuprogram,
						ret,
						enc_file,
						filename);
				}
				else
				{
					if (Verbose)
						fprintf(stderr, "%s: decoded\n", enc_file);
					unlink(filename);
				}
			
				file_open = 0;
			}
		}
	}

	/*
	**	If we get here with a file open, we have a incomplete file
	*/

	if (Verbose)
	{
		fprintf(stderr, "\n%d lines ignored (not part of any file)\n", ignored_lines);
		fprintf(stderr, "%d files processed\n", filecount);
	}

	if (file_open)
	{
		fprintf(stderr, "Warning: File %s (%s) is incomplete (no end line) Erased.\n",
				enc_file,
				filename);
		fclose(fp);
		unlink(filename);
		exit(2);
	}

	exit(0);
}

/*--------------------------------------------------------------------------
 |  valid_uuline - Check if the current line is a valid UUENCODE line 
 +------------------------------------------------------------------------*/

int		valid_uuline(char *str)
{
	/* Ignore empty lines */

	if (str[0] == '\n')
		return 0;

	/* Starting with 'begin' or 'end' or '`' or having a nice char count */

	if (strncmp(str, "begin", 5) == 0 ||
        strcmp(str, "end") == 0 ||
        str[0] == '`' ||
        ((int) str [0] - 0x20) == (strlen(str) / 4 * 3))
	{
		return 1;
	}
	else
		return 0;
}

/*--------------------------------------------------------------------------
 |	parse_field(s,n,delim) - Returns the ptr to 'n'th field of s using delim
 | 
 |  Returns NULL if no such field.
 +------------------------------------------------------------------------*/
 
#define PARSE_BUF_SIZE	120
 
char	*parse_field(char *str, int fieldno, char *delim)
{
	static	char	parse_buf[PARSE_BUF_SIZE];
	int		ix;
	char	*pstr;

	strcpy(parse_buf, str);

	pstr = strtok(parse_buf, delim);

	for (ix = 1; ix < fieldno && pstr != NULL; ix++)
		pstr = strtok(NULL, delim);

	return pstr;
}

/*-------------------------------------------------------------------------*/

void help(void)
{
	printf("MDECODE - A simple multi-file decoder\n");
	printf("1995 By Marco Paganini [paganini@embratel.net.br]\n");
	printf("\n");
	printf("Syntax is:\n");
	printf("    mdecode <infile [-s] [-pUUPROG] [-h]\n");
	printf("    -s      : Silent mode\n");
	printf("    -pUUPROG: Use UUPROG in place of uudecode\n");
	printf("    -h      : You know...\n");
	printf("\n");
	printf("If you like (or hate) this program, send email to:\n");
	printf("paganini@embratel.net.br\n");
}
	
