/* gitcmp.c -- a file compare utility. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#else /* !HAVE_STDLIB_H */
#include "ansi_stdlib.h"
#endif /* !HAVE_STDLIB_H */

#include <sys/types.h>
#include "file.h"
#include <fcntl.h>
#include <limits.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif /* HAVE_UNISTD_H */


#define CMP_BUFFER_SIZE         64*1024
#define min(a, b) ((a) <= (b) ? (a) : (b))


char *program;


int
filelength(handle)
    int handle;
{
    int tmp, length;

    tmp    = lseek(handle, 0, SEEK_CUR);
    length = lseek(handle, 0, SEEK_END);
    lseek(handle, tmp, SEEK_SET);
    return length;
}


int
main(argc, argv)
    int argc;
    char *argv[];
{
    char *buf1, *buf2;
    int handle1, handle2, i, j;
    size_t len, len1, len2, bytes_to_compare;

    program = argv[0];

    if (argc != 3)
    {
        fprintf(stderr, "%s: invalid command line.\n", program);
        return 1;
    }

    if ((handle1 = open(argv[1], O_RDONLY)) == -1)
    {
        fprintf(stderr, "%s: can't open file '%s'.\n", program, argv[1]);
        return 1;
    }

    if ((handle2 = open(argv[2], O_RDONLY)) == -1)
    {
        fprintf(stderr, "%s: can't open file '%s'.\n", program, argv[2]);
        return 1;
    }

    if ((len1 = filelength(handle1)) != (len2 = filelength(handle2)))
        fprintf(stderr, "%s: files have different sizes.\n", program);

    len = min(len1, len2);

    if ((buf1 = (char *)malloc(CMP_BUFFER_SIZE)) == NULL ||
        (buf2 = (char *)malloc(CMP_BUFFER_SIZE)) == NULL)
    {
        fprintf(stderr, "%s: virtual memory exhausted.\n", program);
        return 1;
    }

    for (i = 0; i < len; i += CMP_BUFFER_SIZE)
    {
        bytes_to_compare = min(len - i, CMP_BUFFER_SIZE);

        if (read(handle1, buf1, bytes_to_compare) != bytes_to_compare)
        {
            fprintf(stderr, "%s: can't read from file %s.\n",
                    program, argv[1]);
            return 1;
        }

        if (read(handle2, buf2, bytes_to_compare) != bytes_to_compare)
        {
            fprintf(stderr, "%s: can't read from file %s.\n",
                    program, argv[2]);
            return 1;
        }

        if (memcmp(buf1, buf2, bytes_to_compare))
            for (j = 0; j < bytes_to_compare; j++)
                if (buf1[j] != buf2[j])
                {
                    fprintf(stderr, "%s: filles differ at offset %d.\n",
                            program, i + j);
                    return 1;
                }
    }

    fprintf(stderr, "Compare OK\n");
    return 1;
}
