#include <stdlib.h>
#include <stdio.h>

#include <sys/stat.h>
#include <unistd.h>

#include <sys/types.h>
#include <dirent.h>


// This is cool for ext2.
#define MAXLEN 256
#define maxdepth 4096

struct dnode {
 dnode *sister;
 char name[MAXLEN];
};

const char *look;
const char *l_ascii="|+`-";
const char l_ibm[5]={179,195,192,196,0};

int total;

char map[maxdepth];

void generate_header(int level) {
 int i;
 for (i=0;i<level;i++) printf(" %c ",(map[i]?look[0]:32));
 printf (" %c%c ",(map[level]?look[1]:look[2]),look[3]);
}

dnode* reverselist(dnode *last) {
 dnode *first,*current;
 first=NULL;
 current=last;

 // Put it back in order:
 // Pre: last==current, first==NULL, current points to backwards linked list
 while (current != NULL) {
  last=current->sister;
  current->sister=first;
  first=current;
  current=last;
 }

 return first;
} 

void buildtree(int level) {
 dnode *first,*current,*last;
 first=current=last=NULL;
 char *cwd;
 struct stat st;
 
 if (level>=maxdepth) return;
 
 // This is LINUX SPECIFIC: (ie it may not work on other platforms)
 cwd=getcwd(NULL,maxdepth);
 if (cwd==NULL) return;
 
 // Get (backwards) Dirlist:
 DIR *dir;
 dirent *de;
 
 dir=opendir(cwd);
 if (dir==NULL) return;
 
 while ((de=readdir(dir))) {
  // use de->d_name for the filename
  if (lstat(de->d_name,&st) != 0) continue; // ie if not success go on.
  if (!S_ISDIR(st.st_mode)) continue; // if not dir go on.
  if (!(strcmp(".",de->d_name) && strcmp("..",de->d_name))) continue; // skip ./..
  current=new dnode;
  current->sister=last;
  strcpy(current->name,de->d_name);
  last=current;
 }
 
 closedir(dir);
 
 first=reverselist(last);
 
 // go through each printing names and subtrees
 
 while (first != NULL) {
  map[level]=(first->sister != NULL);
  generate_header(level);
  puts(first->name);
  total++;
  // consider recursion here....  
  if (chdir (first->name) == 0) {
   buildtree(level+1);
   if (chdir (cwd) != 0) return;
  }
  current=first->sister;
  delete first;
  first=current;
 }
 free (cwd);
}  

void tree() {
 char *cwd;
 cwd=getcwd(NULL,maxdepth);
 if (cwd==NULL) return;
 printf("Tree of %s:\n\n",cwd);
 free (cwd);
 total=0;
 buildtree(0);
 printf("\nTotal directories = %d\n",total);
}

void usage() {
 printf("usage: tree {-[agiv]} {dirname}\n\n");
 printf("Tree version 1.0 - Copyright 1997 by Brooke Kjos <beth13@mail.utexas.edu>\n");
 printf("This program is covered by the Gnu General Public License version 2.0\n");
 printf("or later (copyleft). Distribution and use permitted as long as\n");
 printf("source code accompanies all executables and no additional\n");
 printf("restrictions are applied\n");
 printf("\n\n Options:\n\t-a use ascii for drawings\n");
 printf("\t-[ig] use IBM(tm) graphics characters\n");
 printf("\t-v Show version number and exit successfully\n");
};

void main (int argc,char ** argv)  {
 look=l_ascii;
 int i=1;
 if (argc>1) {
  if (argv[1][0]=='-') {
   switch ((argv[1])[1]) {
    case 'i':
    case 'I':
    case 'g':
    case 'G':
    look = l_ibm;
    break;
    case 'a':
    case 'A':
    look = l_ascii;
    break;
    case 'v':
    case 'V':
    usage();
    exit(0);
    default: 
    printf ("Unknown option: %s\n\n",argv[1]);
    usage();
    exit(1);
   } // switch
   i=2;
  } // if2
 } // if1
 if (argc > i) {
  char *cwd;
  cwd=getcwd(NULL,maxdepth);
  if (cwd==NULL) {
   printf("Failed to getcwd:\n");
   perror("getcwd");
   exit(1);
  }
  for (;i<argc;i++) {
   if (chdir(argv[i]) == 0) {
    tree();
    if (chdir(cwd) != 0) {
     printf("Failed to chdir to cwd\n");
     exit(1);
    }
   }
   else printf("Failed to chdir to %s\n\n",argv[i]);
  } // for
  free (cwd);
 } else tree();
}
