#!/bin/sh
####################################################################
##
## Copyright (C) JJ Sarton 1999 All Rights Reserved Confidential
##
####################################################################

####################################################################
##
## MODULE:    epsUtils.sh
##
## FUNCTION:  main script for the epson utilities
##
##
##
## CREATED:   14.JUL.99 Jean-Jacques Sarton 
##                      jj.sarton@t-online.de
##
## CHANGES:   16.JUL.99 layout modification, delay for reading of
##                      printer increased
##            18 JUL 99 internationalisation built in
##            18 DEC 99 allow use of eps Utils if the printer
##                      dont answer to the ID query
##
## VERSION:   1.02
##
####################################################################
#set -x
# get directory of the tools

myDir=`dirname $0`
DELAY=500

# a few functions

# set message
setLangLL() {
   case "$1" in
      de*)
            msg="EPSON Werkzeuge"
            choice="Port whlen"
            ink="Tintenmenge"
            quit="Ende"
            nc="Dsenprffung"
            ch="Dsenreinigung"
            ninf="Keine Information von "
            ok="OK"
            ;;
      fr*)
            msg="Utilitaires EPSON"
            choice="choisir le port"
            quit="Fin"
            ch="Nettoyage"
            nc="Test"
            ink="Encre"
            ninf="Pas d'information pour "
            ok="OK"
            ;;
        *)
            msg="EPSON Utilities"
            choice="Choose Port"
            ink="Ink Quantity"
            quit="QUIT"
            ch="Clean head"
            nc="Nozzle check"
            ninf="No Information from "
            ok="OK"
            ;;
   esac
}

setLang() {
  case "$LANG" in
     de*|fr*|en*) setLangLL $1 $LANG;;
     *) case "$LC_MESSAGES" in
           de*|fr*|en*) setLangLL $1 $LC_MESSAGES;;
           *) case "$LC_ALL" in
                 de*|fr*|en*) setLangLL $1 $LC_ALL;;
                 *) setLangLL en;;
               esac;;
        esac;;
   esac
}

# ask for port
Lp() {

xtpanel -title "$msg" -geometry +200+200 -tty <<EOF
 var={ name=lp value="lp0" }

 vbox={ borderWidth=0 background=white 
   form={ borderWidth=0 background=white 
    message={ name=titel value="$msg" foreground="#00007f" 
              background="#cfcfcf" width=250 x=4 y=4 font=lucidasans-bold-14 }
      choice={ label="$choice"fromVert=titel width=250 background=white action="ASSIGN lp \$val"
       item={ label="lp0" font=8x13 }
       item={ label="lp1" font=8x13 }
       item={ label="lp2" font=8x13 }
      }
   }
   button={ label="-->" action="PRINT \$lp" action=QUIT width=256 }
 }
EOF
}

# print an error message
errorMsg() {
  xtpanel -title "$1" -geometry +200+200 -tty <<EOF
  form={ borderWidth=0 background=white 
    message={ name=titel value="$1" foreground="#00007f" 
              background="#cfcfcf" width=250 x=4 y=4 font=lucidasans-bold-14 }
    message={ label="Port"fromVert=titel width=250 
              value="$ninf\n$2" }
      
   }
   button={ label="$ok" action=QUIT width=256 }
EOF
}

# get printer type
printID()
{
    $myDir/epsCmd -cmd GetId -dev $port -timeout 100
}

# main FOR for the EPSON Utils

setLang

# Enquire port from user (lp0, lp1 or lp3
port=`Lp | sed 's/ //'`

# look for printer
printer=`printID`

# if no answer from printer print a message
if [ "$printer" = "" ]
then
   errorMsg "$msg" "$port"
   printer="$ninf $port"
   #exit
fi

# the main job
xtpanel -title "$msg" -geometry +200+200 <<EOF
  form={ name=mainForm
   message={ name=printer value="$printer" background="#ffffff" foreground="#00007f" 
             background="grey"  width=380 x=4 y=4 font=lucidasans-bold-14
           }
   form={name=bu fromVert=printer y=4  x=4 borderWidth=0

   button={ name=inkQuantity label="$ink" width=90 x=4   y=4
            action="SYSTEM $myDir/getInk  -port $port "
          }
   button={ name=noPat label="$nc"       width=90 x=98  y=4
            action="SYSTEM $myDir/epsCmd -cmd PrintPattern -dev $port -timeout 200 "
          }
   button={ name=cleanHead label="$ch"   width=90 x=192 y=4
            action="SYSTEM $myDir/epsCmd -cmd CleanHead -dev $port -timeout 4000 "
          }
   button={ name=quit label="$quit"      width=90 x=286 y=4
            action=QUIT
          }
        }
      }
EOF

###################################################################
##
## Copyright (C) JJ Sarton 11999 All Rights Reserved  Confidential
##
###################################################################
