#include "SCSI_map.H"

#include "scsi/scsi.h"

#include <iostream.h>

#include <sys/stat.h>
#include <sys/file.h>
#include <sys/ioctl.h>
#include <sys/sysmacros.h>
#include <linux/major.h>
#include <unistd.h>
#include <dirent.h>

static char *id __attribute__ ((unused))
            = "@(#) $Id: SCSI_map.cc,v 1.6 1999/10/15 09:12:25 heyder Exp $";

string scsi_remap_device(string dev)
{
  struct stat devstat;
  struct {
    int idlun[2];
  } idlun;
  int fd, id, lun, ret;
  struct dirent *file;
  DIR *dir;
  string gdev;
  
  if (dev == "") return "";

  // test for SCSI device

  ret = stat (dev.c_str(), &devstat);
  if (ret) return "";
  if (major(devstat.st_rdev) == SCSI_GENERIC_MAJOR) return dev;
  if (!SCSI_DISK_MAJOR(major(devstat.st_rdev))
      && (major(devstat.st_rdev) != SCSI_TAPE_MAJOR)
      && (major(devstat.st_rdev) != SCSI_CDROM_MAJOR))
    return "";

  // get SCSI-ID/LUN

  fd = open(dev.c_str(), O_RDONLY);
  if (fd < 0) return "";

  ret = ioctl(fd, SCSI_IOCTL_GET_IDLUN, &idlun);
  if (ret) {
    close (fd);
    return "";
  }

  id  = idlun.idlun[0];
  lun = idlun.idlun[1];

  close(fd);

  // search for generic SCSI device

  dir = opendir ("/dev");
  if (!dir) {
    return "";
  }
  while ((file = readdir(dir))) {
    gdev = string("/dev/") + string(file->d_name);
    ret = stat(gdev.c_str(), &devstat);
    if (ret) continue;
    if (major(devstat.st_rdev) != SCSI_GENERIC_MAJOR) continue;
    if ((fd = open(gdev.c_str(), O_RDWR)) < 0 ) continue;  
    ret = ioctl(fd, SCSI_IOCTL_GET_IDLUN, &idlun);
    close (fd);
    if ((id == idlun.idlun[0]) && (lun == idlun.idlun[1])) {
       closedir(dir);
      return gdev;
    }
  }
  return "";
}
