#include "Mount.H"
#include "Values.H"

#include <unistd.h>
#include <sys/wait.h>
#include <sys/mount.h>
#include <errno.h>

#include <iostream.h>
#include <fstream.h>

static char *id __attribute__ ((unused))
            = "@(#) $Id: Mount.cc,v 1.5 1999/10/15 09:12:25 heyder Exp $";

static string base_device(string device)
{
  string dir;
  string dev;
  string basedev;

  dir=device.substr(0, device.rfind("/")+1);
  dev=device.erase(0, device.rfind("/")+1);
  basedev=dev.substr(0,2);

  if ((basedev == "sd") || // SCSI Drives
      (basedev == "hd")) { // IDE Drives
    dev=dev.substr(0,3);   // Remove partition number
  } else {
    // Unknown -> no partitions
  }
  return dir+dev;
}

static bool matches_mount(string dev1, string dev2)
{
  return (base_device(dev1) == base_device(dev2));
}

static device_set mounted_on(string dev)
{
  char cbuffer[BUFFERSIZE];
  ifstream file(MOUNTTAB);
  string device;
  device_set mount_dirs;

  if (!file) return mount_dirs;
  while(!file.eof()) {
    file.getline(cbuffer, BUFFERSIZE);
    string buffer(cbuffer);
    device = remove_first_word(buffer);
    if (matches_mount(device,dev)) {
      mount_dirs.insert(remove_first_word(buffer));
    }
  }
  return mount_dirs;
}

static int can_unmount(string dir)
{
  ifstream file("/etc/fstab");
  char cbuffer[BUFFERSIZE];
  string word;
  int pos;

  if (getuid() == 0) return 1; // root can umount everything
  // Check if mount option "user" is in fstab for dir
  if (!file) return 0;
  while(!file.eof()) {
    file.getline(cbuffer, BUFFERSIZE);
    string buffer(cbuffer);
    word = remove_first_word(buffer); // 1st word device
    word = remove_first_word(buffer); // 2nd word mountpoint
    if (word == dir) {
      word = remove_first_word(buffer); // 3rd word fs-type
      word = remove_first_word(buffer); // 4th word options
      pos = word.find("user");
      if (pos>=0) return 1;
    }
  }
  return 0;
}

static int unmount(string dir)
{
  pid_t child;
  int status;

  if (!can_unmount(dir)) return -1;
  child = fork();
  if (!child) {
    execl(UMOUNT, UMOUNT, dir.c_str(), NULL);
    cerr << "Error: Can't exec " << UMOUNT << endl;
    exit (1);
  }
  wait(&status);
  if (!WIFEXITED(status)) return -2;
  return 0;
}

void umount_list(device_set &list, int  verbose, int force_umount)
{
  device_set::iterator pos1;
  device_set::iterator pos2;
  device_set ignore;
  device_set mountpoint;
  string disk;
  bool ok;

  for (pos1=list.begin(); pos1!=list.end(); pos1++) {
    disk=*pos1;
    mountpoint=mounted_on(disk);
    if (verbose) {
      if (mountpoint.size() > 0) {
	cout << disk << " is mounted on ";
	for (pos2=mountpoint.begin(); pos2!=mountpoint.end(); pos2++) {
	  if (pos2 != mountpoint.begin())
	    cout << ", ";
	  cout << *pos2;
	}
	cout << endl;
      } else {
	cout << disk << " is not mounted" << endl;
      }
    }
    if ((mountpoint.size() > 0) && (!force_umount)) {
      cerr << "Ignoring " << disk << " (is mounted)" << endl;
      ignore.insert(disk);
    }
    if ((mountpoint.size() > 0) && (force_umount)) {
      ok=true;
      for (pos2=mountpoint.begin(); pos2!=mountpoint.end() && ok; pos2++) {
	if (unmount(*pos2)) {
	  cerr << "Can't umount " << disk << " (ignoring)" << endl;
	  ignore.insert(disk);
	  ok=false;
	}
      }
      if (!ok) {
	ignore.insert(disk);
	cerr << disk << " is still mounted (ignoring)" << endl;
      }
    }
  }
  for (pos1=ignore.begin(); pos1!=ignore.end(); pos1++) {
    disk = *pos1;
    list.erase(list.find(disk));
  }
}
