/*
 *	$Id: diskdump.h,v 1.2 2002/04/04 13:29:45 solyga Exp $
 */

#undef	DEBUG
#define	HAVE_LSEEK64

/*
 If your system doesn't know about 64-bit-integers, undefine
 HAVE_LSEEK64 and it should compile. However, this way the program cannot
 deal with offsets/sizes >2147483646 (~2G)
#undef	HAVE_LSEEK64
*/

#define	SIZE_MIN	(off_t) 0
#define	SIZE_MAX	LONG_MAX - 1
#define	STRTOL(A,B,C)	strtol((A),(B),(C))

#ifdef	HAVE_LSEEK64
#  define	_LARGEFILE64_SOURCE
#  define	_FILE_OFFSET_BITS	64
#  define	LLONG_MAX	0x7fffffffffffffffll

#  undef	SIZE_MIN
#  define	SIZE_MIN	(off_t) 0
#  undef	SIZE_MAX
#  define	SIZE_MAX	LLONG_MAX - 1

#  undef	STRTOL()
#  define	STRTOL(A,B,C)	strtoq((A),(B),(C))
#endif


#include <stdio.h>		/* printf() */
#include <errno.h>		/* error numbers */
#include <limits.h>		/* LONG_MAX */
#include <stdlib.h>		/* strtol() */
#include <unistd.h>		/* read(), write(), close(), lseek(), STDIN_FILENO, getopt() */
#include <sys/types.h>		/* open() */
#include <sys/stat.h>		/* open() */
#include <fcntl.h>		/* open(), O_RDONLY */

#define	STD_CHANNEL	stdout
#define	HELP_CHANNEL	stdout
#define	ERROR_CHANNEL	stderr
#define	VERSION_CHANNEL	stdout
#define	INFO_CHANNEL	stderr
#define	DEBUG_CHANNEL	stderr

#define	BUFFER_SIZE	0x1000

#define	RETVAL_OK	0
#define	RETVAL_ERROR	1
#define	RETVAL_BUG	2

#define	VERSION_NUMBER		"0.40.01"
#define	DATE_OF_LAST_MOD	"2002-04-04"
#define	MY_EMAIL_ADDRESS	"Steffen Solyga <solyga@absinth.net>"

#define	MIN(A,B)	( (A) < (B) ? (A) : (B) )
