/* os dependent functions */
#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include "lowlevel.h"
#include "global.h"

int init_soundcard(double rate, int bits)
{
#ifdef	ECHO_TO_SOUNDCARD
  if (global.echo) {
    if ((global.soundcard_fd = open(SOUND_DEV, O_WRONLY, 0)) == EOF) {
        fprintf(stderr, "Cannot open "SOUND_DEV"\n");
        global.echo = 0;
    } else { 
	int dummy;
	int garbled_rate = rate;
	int stereo = (global.channels == 2);
	if (ioctl(global.soundcard_fd, (signed)SNDCTL_DSP_GETBLKSIZE, &dummy) == -1) {
	    fprintf(stderr, "Cannot get blocksize for "SOUND_DEV"\n");
	    global.echo = 0;
	}
	if (ioctl(global.soundcard_fd, (signed)SNDCTL_DSP_SYNC, NULL) == -1) {
	    fprintf(stderr, "Cannot sync for "SOUND_DEV"\n");
	    global.echo = 0;
	}
	if (ioctl(global.soundcard_fd, (signed)SNDCTL_DSP_SETFMT, &bits) == -1) {
	    fprintf(stderr, "Cannot set %d bits/sample for "SOUND_DEV"\n",bits);
	    global.echo = 0;
	}

	/* limited sound devices may not support stereo */
	if (stereo
	    && ioctl(global.soundcard_fd, (signed)SNDCTL_DSP_STEREO, &stereo) == -1) {
	    fprintf(stderr, "Cannot set stereo mode for "SOUND_DEV"\n");
	    stereo = 0;
	}
	if (!stereo
            && ioctl(global.soundcard_fd, (signed)SNDCTL_DSP_STEREO, &stereo) == -1) {
	    fprintf(stderr, "Cannot set mono mode for "SOUND_DEV"\n");
	    global.echo = 0;
	}
	if (ioctl(global.soundcard_fd, (signed)SNDCTL_DSP_SPEED, &garbled_rate) == -1) {
	    fprintf(stderr, "Cannot set rate %g Hz for "SOUND_DEV"\n",rate);
	    global.echo = 0;
	}
	if ( abs((long)rate - garbled_rate) > rate / 20) {
	    fprintf(stderr, "sound device: next best sample rate is %d\n",garbled_rate);
	}
    }
  }
  /* if echo is enabled, set speed to 1x */
  if (global.echo)
    global.speed = 1;
#endif
  return 0;
}
