/*  cdrdao - write audio CD-Rs in disc-at-once mode
 *
 *  Copyright (C) 1998  Andreas Mueller <mueller@daneb.ping.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __CDRDRIVER_H__
#define __CDRDRIVER_H__

#include "ScsiIf.h"

class Toc;

class CdrDriver {
public:
  CdrDriver(ScsiIf *scsiIf, Toc *toc) 
    { scsiIf_ = scsiIf; toc_ = toc; blockLength_ = 0; }

  // static constructor
  static CdrDriver *instance(ScsiIf *scsiIf, Toc *toc);

  // returns name of driver
  virtual const char *driverName() const { return driverName_; }

  // returns current writing speed
  virtual int speed() const { return speed_; }
  
  // sets writing speed, returns 0 for OK or 1 for illegal speed
  virtual int speed(int) = 0;

  // returns 1 if simulation mode, 0 for real writing
  virtual int simulate() const { return simulate_; }

  // sets simulation mode
  virtual void simulate(int s) { simulate_ = s ? 1 : 0; }

  // general commands
  virtual int testUnitReady(int) const;

  virtual int startStopUnit(int) const;

  virtual int preventMediumRemoval(int) const;

  virtual int rezeroUnit() const;

  virtual int loadUnload(int) const = 0;

  virtual int writeData(const char *buf, long len) const;

  virtual int flushCache() const;

  // disc at once related commands
  virtual int initDao() = 0;

  virtual int startDao() = 0;

  virtual int finishDao() = 0;

  // disc read commands
  virtual Toc *readDiscToc() = 0;

protected:
  struct StringTable {
    int code;
    char *message;
  };
  
  ScsiIf *scsiIf_;
  char *driverName_;

  int blockLength_; // length of data block for 'writeData' command
  
  int speed_;
  int simulate_;

  Toc *toc_;

  static StringTable senseKeys[];

  virtual const char *getFromStringTable(const StringTable *, int code) const;
  virtual int decodeSense(const unsigned char *buf, int len,
			  int ignoreUnitAttention) const;

  virtual unsigned char ascii2Isrc(char) const;

};

#endif
