/*  SVGATextMode -- An SVGA textmode manipulation/enhancement tool
 *
 *  Copyright (C) 1995-1998  Koen Gadeyne
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * standard 80x25 text mode registers
 *
 */

#ifndef _TEXTREGS_H
#define _TEXTREGS_H

extern unsigned char STD_PALETTE[64][3];

/* 25 CRTC registers */
#define NUM_STD_CRTC_REGS  25
unsigned char TXT_CRTC_REGS[NUM_STD_CRTC_REGS] = {
     0x5f, 0x4f, 0x50, 0x82, 0x55, 0x81, 0xbf, 0x1f, 0x00, 0x4f, 0x0d, 0x0e,
     0x00, 0x00, 0x05, 0x00, 0x9c, 0x8e, 0x8f, 0x28, 0x1f, 0x96, 0xb9, 0xa3,
     0xff
};

/* 21 ATRCTL registers */

#define NUM_STD_ATRCTL_REGS  21
unsigned char TXT_ATRCTL_REGS[NUM_STD_ATRCTL_REGS] = {
     0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x14, 0x07, 0x38, 0x39, 0x3a, 0x3b,
     0x3c, 0x3d, 0x3e, 0x3f, 0x0c, 0x00, 0x0f, 0x08, 0x00
};

/* 9 GRCTL regs */

#define NUM_STD_GRCTL_REGS  9
unsigned char TXT_GRCTL_REGS[NUM_STD_GRCTL_REGS] = {
     0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x00, 0xff
};

/* 5 SEQ registers */

#define NUM_STD_SEQ_REGS  5
unsigned char TXT_SEQ_REGS[NUM_STD_SEQ_REGS] = {
     0x03, 0x00, 0x03, 0x00, 0x02
};

/* 1 MISC register */

unsigned char TXT_MISC_REG = 0x67;

/* standard palette */

unsigned char STD_PALETTE[64][3] = {
  { 0x00, 0x00, 0x00 },
  { 0x00, 0x00, 0x2A },
  { 0x00, 0x2A, 0x00 },
  { 0x00, 0x2A, 0x2A },
  { 0x2A, 0x00, 0x00 },
  { 0x2A, 0x00, 0x2A },
  { 0x2A, 0x2A, 0x00 },
  { 0x2A, 0x2A, 0x2A },
  { 0x00, 0x00, 0x15 },
  { 0x00, 0x00, 0x3F },
  { 0x00, 0x2A, 0x15 },
  { 0x00, 0x2A, 0x3F },
  { 0x2A, 0x00, 0x15 },
  { 0x2A, 0x00, 0x3F },
  { 0x2A, 0x2A, 0x15 },
  { 0x2A, 0x2A, 0x3F },
  { 0x00, 0x15, 0x00 },
  { 0x00, 0x15, 0x2A },
  { 0x00, 0x3F, 0x00 },
  { 0x00, 0x3F, 0x2A },
  { 0x2A, 0x15, 0x00 },
  { 0x2A, 0x15, 0x2A },
  { 0x2A, 0x3F, 0x00 },
  { 0x2A, 0x3F, 0x2A },
  { 0x00, 0x15, 0x15 },
  { 0x00, 0x15, 0x3F },
  { 0x00, 0x3F, 0x15 },
  { 0x00, 0x3F, 0x3F },
  { 0x2A, 0x15, 0x15 },
  { 0x2A, 0x15, 0x3F },
  { 0x2A, 0x3F, 0x15 },
  { 0x2A, 0x3F, 0x3F },
  { 0x15, 0x00, 0x00 },
  { 0x15, 0x00, 0x2A },
  { 0x15, 0x2A, 0x00 },
  { 0x15, 0x2A, 0x2A },
  { 0x3F, 0x00, 0x00 },
  { 0x3F, 0x00, 0x2A },
  { 0x3F, 0x2A, 0x00 },
  { 0x3F, 0x2A, 0x2A },
  { 0x15, 0x00, 0x15 },
  { 0x15, 0x00, 0x3F },
  { 0x15, 0x2A, 0x15 },
  { 0x15, 0x2A, 0x3F },
  { 0x3F, 0x00, 0x15 },
  { 0x3F, 0x00, 0x3F },
  { 0x3F, 0x2A, 0x15 },
  { 0x3F, 0x2A, 0x3F },
  { 0x15, 0x15, 0x00 },
  { 0x15, 0x15, 0x2A },
  { 0x15, 0x3F, 0x00 },
  { 0x15, 0x3F, 0x2A },
  { 0x3F, 0x15, 0x00 },
  { 0x3F, 0x15, 0x2A },
  { 0x3F, 0x3F, 0x00 },
  { 0x3F, 0x3F, 0x2A },
  { 0x15, 0x15, 0x15 },
  { 0x15, 0x15, 0x3F },
  { 0x15, 0x3F, 0x15 },
  { 0x15, 0x3F, 0x3F },
  { 0x3F, 0x15, 0x15 },
  { 0x3F, 0x15, 0x3F },
  { 0x3F, 0x3F, 0x15 },
  { 0x3F, 0x3F, 0x3F }
};

#endif

