#include <kapp.h>
#include <qpopmenu.h>
#include <qcolor.h>
#include <qmsgbox.h> 
#include <qfont.h>
#include <qdialog.h>
#include <qkeycode.h>
#include <kstatusbar.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <pwd.h>
#include "top.h"

class KAskDialog:public QDialog {
 public:
  KAskDialog(const char* cap, QWidget* parent=0, const char* name=0, bool modal=TRUE, WFlags f=0);
  char *getName(){strncpy(ret,line->text(),30);return ret;}
 private: 
  char ret[30];
  QLineEdit *line;
  QPushButton *ok,*cancel;
};

KAskDialog::KAskDialog(const char*cap,QWidget* parent, const char* name, bool modal, WFlags f)
           :QDialog(parent,name,modal,f) {
resize(300,80);
line=new QLineEdit(this);
line->setGeometry(10,10,280,20);
ok=new QPushButton(this);
ok->setGeometry(10,40,50,30);
ok->setText(i18n("OK"));
ok->setDefault(TRUE);
cancel=new QPushButton(this);    
cancel->setGeometry(70,40,50,30);
cancel->setText(i18n("Cancel"));
cancel->setAccel(Key_Escape);
connect(ok,SIGNAL(clicked()),SLOT(accept()));
connect(cancel,SIGNAL(clicked()),SLOT(reject()));
setCaption(cap);
line->setFocus();
}

KTop::KTop(QColor* sc,QFont *sf,const char* name)
   :KTopLevelWidget(name) {
 nproc=currow=sortindex=0;
 pin=0; //shouldn't it be NULL at startup?????
uid=-1;
tc1.cn=11;
tc1.rn=0;
char *col[11];
for (int i=0;i<11;i++) col[i]=new char[8];
strcpy(col[0],i18n("Pid"));
strcpy(col[1],i18n("User"));
strcpy(col[2],i18n("Pri"));
strcpy(col[3],i18n("Ni"));
strcpy(col[4],i18n("Size"));
strcpy(col[5],i18n("Rss"));
strcpy(col[6],i18n("Stat"));
strcpy(col[7],i18n("%Cpu"));
strcpy(col[8],i18n("%Mem"));
strcpy(col[9],i18n("Time"));
strcpy(col[10],i18n("Command"));

int* len=new int[11];
len[0]=45;
len[1]=45;
len[2]=30;
len[3]=30;
len[4]=40;
len[5]=40;
len[6]=40;
len[7]=45;
len[8]=45;
len[9]=40;
len[10]=150;
tc1.clabel=col;
tc1.cwidth=len;
tc1.cont=0;
 QPopupMenu* process=new QPopupMenu;
 process->insertItem(i18n("&Kill"),this,SLOT(tkill()),CTRL+Key_K);
 process->insertItem(i18n("&Terminate"),this,SLOT(term()),CTRL+Key_T);
 process->insertItem(i18n("&Renice"),this,SLOT(renice()),CTRL+Key_R);
 process->insertSeparator();
 process->insertItem(i18n("&Quit"),qApp,SLOT(quit()),ALT+Key_X);
 QPopupMenu* user=new QPopupMenu;
 user->insertItem(i18n("&Me"),this,SLOT(me()),CTRL+Key_M);
 user->insertItem(i18n("&All"),this,SLOT(all()),CTRL+Key_A);
 user->insertItem(i18n("&Other..."),this,SLOT(other()),CTRL+Key_O);
 QPopupMenu* help=new QPopupMenu;
 help->insertItem(i18n("&About"),this,SLOT(about()),CTRL+Key_I);
 mainmenu=new KMenuBar(this,"mainmenu");
 mainmenu->insertItem(i18n("&Process"),process);
 mainmenu->insertItem(i18n("&User"),user);
 mainmenu->insertSeparator(); 
 mainmenu->insertItem(i18n("&Help"),help);
 mainmenu->show();
 setMenu(mainmenu);
 status=new KStatusBar(this);
 char sline1[100];
 sprintf(sline1,"%s: 000000K/000000K %s: 000000K/000000K ",i18n("Free mem"),i18n("Free swap"));
 status->insertItem(sline1,0);
 sprintf(sline1,"%s: 00.0%%",i18n("CPU idle"));
 status->insertItem(sline1,1);
//status->insertItem("Free mem: 000000K/000000K Free swap: 000000K/000000K  ",0);
//status->insertItem("CPU Idle: 00.0%",1);
 setStatusBar(status);
 list=new KMultiList(&tc1,sc,sf,this);
 connect(list,SIGNAL(selItem(int)),this,SLOT(selItem(int)));
 connect(list,SIGNAL(selColumn(int)),this,SLOT(selColumn(int)));
 connect(list,SIGNAL(rmbPress(int,int)),this,SLOT(ctxMenu(int,int)));
 setView(list);
 setCaption("kTop <0.01 alpha>");
 if(readcpui(oldin)<0) exit(1);
 startTimer(5000);
}

KTop::~KTop() {
 delete [] pin;
}

void KTop::ctxMenu(int x,int y){
 QPopupMenu process;
 process.insertItem(i18n("Kill"),this,SLOT(tkill()));
 process.insertItem(i18n("Terminate"),this,SLOT(term()));
 process.move(x,y);
 process.exec();
}

int comp1(proci* a1,proci *a2) {return a1->pid-a2->pid;}
int comp2(proci* a1,proci *a2) {return strcmp(a1->user,a2->user);}
int comp3(proci* a1,proci *a2) {return a2->pri-a1->pri;}
int comp4(proci* a1,proci *a2) {return a2->nice-a1->nice;}
int comp5(proci* a1,proci *a2) {return a2->size-a1->size;}
int comp6(proci* a1,proci *a2) {return a2->rss-a1->rss;}
int comp7(proci* a1,proci *a2) {return a1->state-a2->state;}
int comp8(proci* a1,proci *a2) {return int(10000*a2->cpu-10000*a1->cpu);}
int comp9(proci* a1,proci *a2) {return int(10000*a2->mem-10000*a1->mem);}
int comp10(proci* a1,proci *a2) {return int(a2->time-a1->time);}
int comp11(proci* a1,proci *a2) {return strcmp(a1->command,a2->command);}

void KTop::timerEvent(QTimerEvent *te){
 cpui in;memi min; 
 char buf[100];
 proci *temp; int tempi;
 int i,a,n,oldpid;
 if (tc1.cont!=0) oldpid=atoi(tc1.cont[0][currow]); else oldpid=-1;
 if(readcpui(in)<0||readmemi(min)<0) exit(1);   // Read general info 
 sprintf(buf,"%s: %6dK/%6dK %s: %6dK/%6dK",i18n("Free mem"),min.free/1024,min.total/1024,
         i18n("Free swap"),min.sfree/1024,min.stotal/1024);
 status->changeItem(buf,0);
 int idlec=in.idle-oldin.idle;
 int totalc=in.user+in.system+in.nice+in.idle-oldin.user-oldin.system-oldin.nice-oldin.idle;
 oldin=in;
 sprintf(buf,"%s: %2.1f%%",i18n("CPU idle"),((float)idlec/totalc)*100);
 status->changeItem(buf,1);
 if ((n=readnproc())>nproc) {  // if number of procs has increased, enlarge array
   delete [] pin;
   nproc=n;
   pin=new proci[nproc];
   if(tc1.cont!=0)                    // resize the table contents array
     for (i=0;i<tc1.cn;i++) {
        for (a=0;a<tc1.rn;a++) delete [] tc1.cont[i][a];
      delete [] tc1.cont[i];
     }     
   delete [] tc1.cont;
   tc1.rn=n;
   tc1.cont=new char**[tc1.cn];
   for (i=0;i<tc1.cn;i++) {
    tc1.cont[i]=new char*[tc1.rn];
    for (a=0;a<tc1.rn;a++) tc1.cont[i][a]=new char[30];
   }
 }
 if(fillproci(n,pin,totalc,min.total)<0) exit(1);  // fill ALL processes info array;
 int x=0;
 switch(sortindex){
  case 0: qsort(pin,n,sizeof(proci),comp1);break;
  case 1: qsort(pin,n,sizeof(proci),comp2);break;
  case 2: qsort(pin,n,sizeof(proci),comp3);break;
  case 3: qsort(pin,n,sizeof(proci),comp4);break;
  case 4: qsort(pin,n,sizeof(proci),comp5);break;
  case 5: qsort(pin,n,sizeof(proci),comp6);break;
  case 6: qsort(pin,n,sizeof(proci),comp7);break;
  case 7: qsort(pin,n,sizeof(proci),comp8);break;
  case 8: qsort(pin,n,sizeof(proci),comp9);break;
  case 9: qsort(pin,n,sizeof(proci),comp10);break;
  case 10: qsort(pin,n,sizeof(proci),comp11);break;
 }
 for (i=0;i<n;i++) {
   if (uid!=-1&&pin[i].uid!=uid) {x++;continue;}
   sprintf(tc1.cont[0][i-x],"%d",pin[i].pid);
   strcpy(tc1.cont[1][i-x],pin[i].user);
   sprintf(tc1.cont[2][i-x],"%d",pin[i].pri);
   sprintf(tc1.cont[3][i-x],"%d",pin[i].nice);
   sprintf(tc1.cont[4][i-x],"%d",pin[i].size);
   sprintf(tc1.cont[5][i-x],"%d",pin[i].rss);
   tc1.cont[6][i-x][0]=pin[i].state;   tc1.cont[6][i-x][1]='\0';
   sprintf(tc1.cont[7][i-x],"%2.1f%%",100*pin[i].cpu);
   sprintf(tc1.cont[8][i-x],"%2.1f%%",100*pin[i].mem);
   sprintf(tc1.cont[9][i-x],"%d:%.2d",pin[i].time/6000,(pin[i].time/100)%60);
   strncpy(tc1.cont[10][i-x],pin[i].command,30);
 } 
 tc1.rn=i-x;
 curpid=atoi(tc1.cont[0][currow]);
 if (curpid!=oldpid) for (i=0;i<tc1.rn;i++) if((curpid=atoi(tc1.cont[0][i]))==oldpid) 
   {list->select(i);break;}
 list->redrawTable();
// printf("PROC %s PID %d STATE %c RSS %d SIZE %d TIME %d:%.2d NICE %d PRI %d\n",
// pin[i].command,pin[i].pid,pin[i].state,pin[i].rss,pin[i].size,pin[i].time/6000,
// (pin[i].time/100)%60,pin[i].nice,pin[i].pri);
}

void KTop::tkill(){kill(curpid,9);}
void KTop::term(){kill(curpid,15);}
void KTop::renice(){KAskDialog ask(i18n("New nice value"),this);
                  if (ask.exec()) {
                  char *name=ask.getName();
                  int nice=atoi(name);
                  setpriority(PRIO_PROCESS,curpid,nice);
                  timerEvent(0);}
                  }
void KTop::me(){uid=getuid();}
void KTop::all(){uid=-1;}
void KTop::other(){KAskDialog ask(i18n("Enter name"),this);
                  if (ask.exec()) {
                  char *name=ask.getName();
                  struct passwd* pass;
                  pass=getpwnam(name);
                  if(pass==0) uid=-1; else uid=pass->pw_uid;
                  timerEvent(0);
                  }
                 }
void KTop::about(){
QMessageBox::about( this, i18n("About kTop/Linux"),
                        i18n("This is a graphical shell for\n"
                        "a well known UNIX command: top\n"
                        "AUTHOR: maciejk@mat.uni.torun.pl") ); 
}

int main( int argc, char **argv )
{
   KApplication a( argc, argv );
   KTop w(&a.selectColor,&a.generalFont,"kTop");
   QObject::connect(&a,SIGNAL(kdisplayFontChanged()),&w,SLOT(refreshFont()));
    w.resize( 550, 500 );
    a.setMainWidget( &w );
    w.show();
    return a.exec();
}
