/*************************************************************************
** interpcom-3.1   (command interpreter)                                 **
** convert.c : conversion of a text file in a source file                **
**             (auxiliary program)                                       **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <sys/stat.h>

char           *black = "\033[01;30m",
               *red = "\033[01;31m",
               *green = "\033[01;32m",
               *yellow = "\033[01;33m",
               *blue = "\033[01;34m",
               *magenta = "\033[01;35m",
               *lightblue = "\033[01;36m",
               *white = "\033[01;37m";

void
add_subj(char *h, FILE *t, int color, int w)
{
    int             i,
                    l;
    void           *c;

    l = strlen(h);
    i = 0;

    while (i < l) {
        if (h[i] == '\\') {
            i++;
            if (color == 1 && i < l) {
                if (h[i] == '0')
                    fwrite(black, 8, 1, t);
                else {
                    if (h[i] == 'r')
                        fwrite(red, 8, 1, t);
                    else {
                    if (h[i] == 'g')
                        fwrite(green, 8, 1, t);
                        else {
                            if (h[i] == 'y')
                                fwrite(yellow, 8, 1, t);
                            else {
                                if (h[i] == 'b')
                                    fwrite(blue, 8, 1, t);
                                else {
                                    if (h[i] == 'm')
                                        fwrite(magenta, 8, 1, t);
                                    else {
                                        if (h[i] == 'l')
                                            fwrite(lightblue, 8, 1, t);
                                        else {
                                            if (h[i] == 'w')
                                                fwrite(white, 8, 1, t);
                                            else {
                                                c = (void *) &h[i - 1];
                                                fwrite(c, 1, 1, t);
                                                if (h[i] == '\%')
                                                    fwrite(c, 1, 1, t);
                                                c = (void *) &h[i];
                                                fwrite(c, 1, 1, t);
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        else {
            c = (void *) &h[i];
            fwrite(c, 1, 1, t);
        }
        i++;
    }
}

int
main(int argc, char *argv[])
{
    int             color,
                    w,
                    i,
                    j,
                    n;
    char           *Fil,
                   *h,
                    k[3];
    void           *v;
    FILE           *s,
                   *t;
    struct stat     b;

    if (argc < 4) {
        printf("Usage : help_convert <infile> <outfile> n\n");
        return 1;
    }
    s = fopen(argv[1], "r");
    if (s == NULL) {
        printf("Input file could not be open\n");
        return 1;
    }
    t = fopen(argv[2], "w");
    if (s == NULL) {
        printf("Output file could not be open\n");
        return 1;
    }
    color = strtol(argv[3], NULL, 10);
    fstat(fileno(s), &b);
    n = (int) b.st_size;
    Fil = (char *) malloc((size_t) n * sizeof(char));
    h = (char *) malloc((size_t) n * sizeof(char));
    fread((void *) Fil, n, 1, s);
    i = 0;
    v = (void *) k;

    while (i < n) {
        if (Fil[i] == ';') {
            memset(h, 0, n);
            j = -1;
            k[0] = ';';
            k[1] = '\n';
            fwrite(v, 2, 1, t);
            while (i < n && Fil[i] != '\n') {
                i++;
            }
            i++;
            while (i < n && Fil[i] != '\n') {
                k[0] = Fil[i];
                fwrite(v, 1, 1, t);
                i++;
            }
            k[0] = '\n';
            fwrite(v, 1, 1, t);
            i++;
            while (i < n && Fil[i] != ';') {
                j++;
                h[j] = Fil[i];
                i++;
            }
            i--;
            add_subj(h, t, color, w);
        }
        i++;
    }

    fclose(t);
    fclose(s);
    return 0;
}
