/*************************************************************************
** interpcom-3.1    (command interpreter)                                **
** com_sys.c : Execution of commands, messages and system commands       **
**                                                                       **
** Copyright (C) 2003  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      UMR 7586 du CNRS                                                 **
**      173, rue du Chevaleret                                           **
**      75013 Paris                                                      **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"


char               *esp_decalage = "                         ";
flow_data          *flow_interp0;



/*--------------------------------------------------------------------
----------------------------------------------------------------------
        INITIALIZATION FILES
----------------------------------------------------------------------
----------------------------------------------------------------------


----------------------------------------------------------------------
    Names of the sections of the initialization files
--------------------------------------------------------------------*/
char               *namesb[] =
{
    "mode",
    "greet",
    "func",
    "message",
    "param",
    "var",
    "def",
    "rep",
    "struct",
    "init",
    "include",
    "color",
    "help",
    ""
};

/*--------------------------------------------------------------------
    Corresponding functions
--------------------------------------------------------------------*/
pfib                procb[] =
{
    mode_cmd,
    greet_cmd,
    func_cmd,
    mess_cmd,
    param_cmd,
    var_cmd,
    objdef_cmd,
    rep_cmd,
    struct_cmd,
    init_interp_cmd,
    include_cmd,
    color_cmd,
    help_file_cmd,
};




/*--------------------------------------------------------------------
    Command interpreter messages
--------------------------------------------------------------------*/
extern char *mess_interp[];
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Functions associated to built-in commands
--------------------------------------------------------------------*/
pfi                 proc_interp[] =
{
    add_objet,                          /* add        */
    assign_membre,                      /* assign     */
    ch_expr_cmd,                        /* ch_expr    */
    temps,                              /* clock      */
    close_file_cmd,                     /* close      */
    Cmult_objet,                        /* cmultiply  */
    color_echo_cmd,                     /* color_echo */
    conjg_cmd,                          /* conjg      */
    cnst,                               /* const      */
    Ccnst_cmd,                          /* const_c    */
    RPolcnst,                           /* const_r    */
    ThPolcnst,                          /* const_th   */
    copie_objet,                        /* copy       */
    delcom,                             /* delcom     */
    deldon,                             /* deldat     */
    delprog_cmd,                        /* delprog    */
    delres,                             /* delres     */
    delstring_cmd,                      /* delstring  */
    dep_obj_struct,                     /* depend     */
    desassign_membre,                   /* desassign  */
    desc_struct,                        /* desc       */
    detruit_obj,                        /* destroy    */
    echo_cmd,                           /* echo       */
    echo_float_cmd,                     /* echof      */
    echo_int_cmd,                       /* echoi      */
    editeur,                            /* editor     */
    fin_mon_cmd,                        /* end_mon    */
    eval_cmd,                           /* eval       */
    exit_cmd,                           /* exit       */
    fill_obj_cmd,                       /* fillobj    */
    flush_cmd,                          /* flush      */
    Function_cmd,                       /* funct      */
    greetb_cmd,                         /* greet      */
    help_cmd,                           /* help       */
    hist_cmd,                           /* hist       */
    Imag_part,                          /* Imag       */
    init_var_cmd,                       /* initvar    */
    is_cmd,                             /* is         */
    kill_thread,                        /* kill       */
    liste_obj,                          /* list       */
    ListFunc_cmd,                       /* listfunc   */
    liststring_cmd,                     /* liststr    */
    list_threads,                       /* listt      */
    load_cmd,                           /* load       */
    bouclex,                            /* loop       */
    bouclex_f,                          /* loopf      */
    mkcomplex_cmd,                      /* mkcomplex  */
    mkpolaire_cmd,                      /* mkpolaire  */
    mon_cmd,                            /* mon        */
    Xmult_objet,                        /* mult       */
    mult_objet,                         /* multiply   */
    num_com,                            /* numcom     */
    obj_create,                         /* objdef     */
    pause_thread,                       /* pause      */
    Phase_part,                         /* phase      */
    proglist_cmd,                       /* proglist   */
    question_cmd,                       /* question   */
    Radius_part,                        /* radius     */
    fread_cmd,                          /* read       */
    Real_part,                          /* Real       */
    repetex,                            /* repete     */
    restore_cmd,                        /* restore    */
    send_print_cmd,                     /* send_print */
    setdir_cmd,                         /* setdir     */
    set_obj_val_cmd,                    /* setobj     */
    shell_cmd,                          /* shell      */
    si_cmd,                             /* si         */
    silence_cmd,                        /* silence    */
    setstring_cmd,                      /* string     */
    struc_create,                       /* strucdef   */
    sub_objet,                          /* substract  */
    svg_cmd,                            /* svg        */
    thread_interp_create,               /* thread     */
    time_cmd,                           /* time       */
    trace_cmd,                          /* trace      */
    undef_cmd,                          /* undef      */
    undep_obj_struct,                   /* undepend   */
    update_obj_struct,                  /* update     */
    var_list_cmd,                       /* varlist    */
    wait_thread,                        /* wait       */
    file_cmd,                           /* write      */
};
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Default functions of the expression evaluator
--------------------------------------------------------------------*/
extern    double    _I_sin(double *);
extern    double    _I_cos(double *);
extern    double    _I_tan(double *);
extern    double    _I_asin(double *);
extern    double    _I_acos(double *);
extern    double    _I_atan(double *);
extern    double    _I_sinh(double *);
extern    double    _I_cosh(double *);
extern    double    _I_tanh(double *);
extern    double    _I_exp(double *);
extern    double    _I_log(double *);
extern    double    _I_log10(double *);
extern    double    _I_sqrt(double *);
extern    double    _I_floor(double *);
extern    double    _I_ceil(double *);
extern    double    _I_fabs(double *);
extern    double    _I_deg(double *);
extern    double    _I_rad(double *);

FUNCTION            Funcs_interp[] =
{
   /* name, function to call */
   { "sin",     1,    _I_sin },            /* 0    */
   { "cos",     1,    _I_cos },            /* 1    */
   { "tan",     1,    _I_tan },            /* 2    */
   { "asin",    1,    _I_asin },           /* 3    */
   { "acos",    1,    _I_acos },           /* 4    */
   { "atan",    1,    _I_atan },           /* 5    */
   { "sinh",    1,    _I_sinh },           /* 6    */
   { "cosh",    1,    _I_cosh },           /* 7    */
   { "tanh",    1,    _I_tanh },           /* 8    */
   { "exp",     1,    _I_exp },            /* 9    */
   { "log",     1,    _I_log },            /* 10   */
   { "log10",   1,    _I_log10 },          /* 11   */
   { "sqrt",    1,    _I_sqrt },           /* 12   */
   { "floor",   1,    _I_floor },          /* 13   */
   { "ceil",    1,    _I_ceil },           /* 14   */
   { "abs",     1,    _I_fabs },           /* 15   */
   { "deg",     1,    _I_deg },            /* 16   */
   { "rad",     1,    _I_rad },            /* 17   */
   { 0 }                                   /* 18   */
};

int                 _NBFONC0=18;


extern    dcomplex  _I_dCsin_c(dcomplex *);
extern    dcomplex  _I_dCcos_c(dcomplex *);
extern    dcomplex  _I_dCtan_c(dcomplex *);
extern    dcomplex  _I_dCsinh_c(dcomplex *);
extern    dcomplex  _I_dCcosh_c(dcomplex *);
extern    dcomplex  _I_dCtanh_c(dcomplex *);
extern    dcomplex  _I_dCexp_c(dcomplex *);
extern    dcomplex  _I_dClog_c(dcomplex *);
extern    dcomplex  _I_xdCsqrt(dcomplex *);
extern    dcomplex  _I_CdCabs(dcomplex *);

FUNCTIONC           Funcs_interp_C[] =
{
   /* name, funtion to call */
   { "Csin",    1,    _I_dCsin_c },        /* 0    */
   { "Ccos",    1,    _I_dCcos_c },        /* 1    */
   { "Ctan",    1,    _I_dCtan_c },        /* 2    */
   { "Csinh",   1,    _I_dCsinh_c },       /* 3    */
   { "Ccosh",   1,    _I_dCcosh_c },       /* 4    */
   { "Ctanh",   1,    _I_dCtanh_c },       /* 5    */
   { "Cexp",    1,    _I_dCexp_c },        /* 6    */
   { "Clog",    1,    _I_dClog_c },        /* 7    */
   { "Csqrt",   1,    _I_xdCsqrt },        /* 8    */
   { "Cabs",    1,    _I_CdCabs },         /* 9    */
   { 0 }                                   /* 10   */
};

int                 _NBFONC0_C=10;
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Names of the built-in commands
--------------------------------------------------------------------*/
extern char *names_interp[];
/*------------------------------------------------------------------*/



/*--------------------------------------------------------------------
    Minimal number of arguments of the built-in commands
--------------------------------------------------------------------*/
int                 n_arg_com_interp[] =
{
        4,              /* add        */
        4,              /* assign     */
        2,              /* ch_expr    */
        2,              /* clock      */
        2,              /* close      */
        5,              /* cmultiply  */
        1,              /* color_echo */
        3,              /* conjg      */
        3,              /* const      */
        4,              /* const_c    */
        3,              /* const_r    */
        3,              /* const_th   */
        3,              /* copy       */
        2,              /* delcom     */
        2,              /* deldat     */
        2,              /* delprog    */
        2,              /* delres     */
        2,              /* delstring  */
        3,              /* depend     */
        3,              /* desassign  */
        2,              /* desc       */
        2,              /* destroy    */
        2,              /* echo       */
        2,              /* echof      */
        2,              /* echoi      */
        2,              /* editor     */
        1,              /* end_mon    */
        2,              /* eval       */
        1,              /* exit       */
        3,              /* fillobj    */
        1,              /* flush      */
        3,              /* funct      */
        1,              /* greet      */
        1,              /* help       */
        1,              /* hist       */
        3,              /* Imag       */
        1,              /* initvar    */
        2,              /* is         */
        2,              /* kill       */
        1,              /* list       */
        1,              /* listfunc   */
        1,              /* liststr    */
        1,              /* listt      */
        2,              /* load       */
        6,              /* loop       */
        6,              /* loopf      */
        4,              /* mkcomplex  */
        4,              /* mkpolaire  */
        2,              /* mon        */
        4,              /* mult       */
        4,              /* multiply   */
        2,              /* numcom     */
        3,              /* objdef     */
        1,              /* pause      */
        3,              /* phase      */
        1,              /* proglist   */
        1,              /* question   */
        3,              /* radius     */
        3,              /* read       */
        3,              /* Real       */
        5,              /* repete     */
        3,              /* restore    */
        2,              /* send_print */
        3,              /* setdir     */
        4,              /* setobj     */
        2,              /* shell      */
        2,              /* si         */
        2,              /* silence    */
        3,              /* string     */
        3,              /* strucdef   */
        4,              /* substract  */
        3,              /* svg        */
        3,              /* thread     */
        1,              /* time       */
        2,              /* trace      */
        2,              /* undef      */
        2,              /* undepend   */
        2,              /* update     */
        1,              /* varlist    */
        3,              /* wait       */
        3,              /* write      */
};

int                 _COMM_INTERP=81;
/*------------------------------------------------------------------*/






/*--------------------------------------------------------------------
    Function returning -1 if 'nom_cmd' is not a valid command name.
    Otherwise the number of the command is returned
--------------------------------------------------------------------*/
int
lookup_b(char *nom_cmd, flow_data *flow_interp)
{
    int             i;

    for (i = 0; i < nb_com; i++) {
        if (comp(nom_cmd, nom_com[i]) == 1) {
            if (mode_com_int[i][flow_interp->MODE_FONCT_] == 1)
                return i;
            else
                err_mess(25);
        }
    }
    return -1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function interpreting and executing the program number 'i_com0'.
    This function is called from the function 'shell_c' and may call
    it
--------------------------------------------------------------------*/
void
execute(int i_com0, int argc, char *argv[], flow_data *flow_interp)
{
    int             i,
                    i0,
                    ii,
                    ik,
                    k,
                    l,
                    dum,
                    nb_c,
                    argc_com;
    char          **argv_com,
                  **cw,
                   *h[100],
                    h2[MAX_CARS_COM],
                    ch;
    void           *res_Gen;
    dcomplex        z;

    flow_interp->I__COM_CUR = i_com0;
    if (argc < nb_par[i_com0] + 1) {
        err_mess(0);
        return;
    }
    i0 = 0;
    h[1] = (char *) &argc;
    for (i = 2; i <= argc  + 1; i++)
        h[i] = argv[i - 2];
    argc_com = 0;
    flow_interp->IS_COM = 1;
    cw = (char **) malloc((size_t) (__nbargmax + 3) * sizeof(char *));
    cw[0] = (char *) flow_interp;
    argv_com = cw + 1;
    for (i = 0; i < __nbargmax + 2; i++)
         argv_com[i] = NULL;
    i = 0;
    flow_interp->I_LIGNE_CUR = 0;
    flow_interp->I_LEC_CUR = 0;
    nb_c = nb_lignes[i_com0];

    while (i < nb_c) {
        flow_interp->n_instr++;
        if (ligne_com[i_com0][i][0] == '[') {
            flow_interp->I_SPEED = 1;
            if (strlen(ligne_com[i_com0][i]) > 1) {
                if (ligne_com[i_com0][i][1] == '0')
                    flow_interp->parse_com = 1;
                if (ligne_com[i_com0][i][1] == '1')
                    flow_interp->parse_com = 2;
            }
            goto suite0;
        }
        if (ligne_com[i_com0][i][0] == ']') {
            flow_interp->I_SPEED = 0;
            flow_interp->parse_com = 0;
            goto suite0;
        }
        argc_com = Argc_com[i_com0][i];
        if (Is_subst_ligne[i_com0][i] > 0) {
            i0 = 0;

            for (ik = 0; ik < argc_com; ik++) {
                argv_com[ik] = ch_copy(Argv_com[i_com0][i][ik]);
                if (Is_subst_arg[i_com0][i][ik] > 0) {
                    substit_argc_c2(argv_com[ik], h, flow_interp, &k);
                    if (argv_com[ik] != NULL)
                        free(argv_com[ik]);
                    argv_com[ik] = (char *) malloc((size_t)(k + 2) *
                        sizeof(char));
                    memcpy(argv_com[ik], h[0], k + 1);
                    argv_com[ik][k + 1] = 0;
                    free(h[0]);
                }
            }
        }
        else {
            i0 = 0;
            if (flow_interp->parse_com <= 1)
                for (ik = 0; ik < argc_com; ik++)
                    argv_com[ik] = ch_copy(Argv_com[i_com0][i][ik]);
            else {
                i0 = 1;
                for (ik = 0; ik < argc_com; ik++)
                    argv_com[ik] = Argv_com[i_com0][i][ik];
            }
        }

        for (ik = argc_com; ik < __nbargmax + 2; ik++)
            argv_com[ik] = NULL;
        ch = argv_com[0][0];
        if (ch == _EVAL) {
            memset(h2, 0, MAX_CARS_COM);
            for (l = 1; l < argc_com; l++)
                strcat(h2, argv_com[l]);
            if (flow_interp->expr_ev == 0)
                 convert_float(h2, flow_interp);
            else {
                if (flow_interp->expr_ev == 1) {
                    z.r = 0.;
                    z.i = 0.;
                    Evaluate_C(h2, &z, &dum, flow_interp);
                }
                else {
                    res_Gen = NULL;
                    Evaluate_Gen(flow_interp->expr_ev - 2, h2, &res_Gen, &dum,
                    flow_interp);
                    Expreval_ops[flow_interp->expr_ev - 2].clear(res_Gen);
                }
            }
            goto suite;
        }
        if (ch == _GOTO) {
            i = num_label[i_com0][atoi(argv_com[1])] - 1;
            goto suite;
        }
        if (ch == _IFGT) {
            if (sign_conv(argv_com[1], flow_interp) > 0) {
                i = num_label[i_com0][atoi(argv_com[2])] - 1;
                goto suite;
            }
            if (argc_com > 3)
                i = num_label[i_com0][atoi(argv_com[3])] - 1;
            goto suite;
        }
        if (ch == _IFLT) {
            if (sign_conv(argv_com[1], flow_interp) < 0) {
                i = num_label[i_com0][atoi(argv_com[2])] - 1;
                goto suite;
            }
            if (argc_com > 3)
                i = num_label[i_com0][atoi(argv_com[3])] - 1;
            goto suite;
        }
        if (ch == _IFEQ) {
            if (sign_conv(argv_com[1], flow_interp) == 0) {
                i = num_label[i_com0][atoi(argv_com[2])] - 1;
                goto suite;
            }
            if (argc_com > 3)
                i = num_label[i_com0][atoi(argv_com[3])] - 1;
            goto suite;
        }

        if (sil_com[i_com0] == 0)
            flow_interp->PRLEVEL++;
        if (flow_interp->PRLEVEL <= 0) {
#ifndef _WIN32
            print(flow_interp, "%s%s%s", col_prog,
                prompt_mode[__nmode_fonc - 1], end_col_mess);
#else
            print(flow_interp, "%s", prompt_mode[__nmode_fonc - 1]);
#endif

            for (ii = 0; ii < argc_com; ii++) {
#ifndef _WIN32
                print(flow_interp, "%s%s%s ", col_prog, argv_com[ii],
                    end_col_mess);
#else
                print(flow_interp, "%s ", argv_com[ii]);
#endif
            }

            print(flow_interp, "\n");
        }
        flow_interp->I_LEC_CUR = 0;
        shell_c(argc_com, argv_com, flow_interp);
        i += flow_interp->I_LEC_CUR;
        flow_interp->I_LEC_CUR = 0;
        flow_interp->IS_COM = 1;
        if (sil_com[i_com0] == 0)
            flow_interp->PRLEVEL--;
suite:  if (i0 == 0) {
            for (ik = 0; ik < argc_com; ik++)
                if (argv_com[ik] != NULL) {
                    free(argv_com[ik]);
                    argv_com[ik] = NULL;
                }
        }
suite0:
        i++;
        flow_interp->I_LIGNE_CUR = i;
        if (flow_interp->kill == 1)
            i = nb_c;
    }

    flow_interp->IS_COM = 0;
    cw[0] = NULL;
    free(cw);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
int
sign_conv(char *c, flow_data *flow_interp)
{
    void           *res_Gen;
    int             dum;
    double          x;
    dcomplex        z;

    if (flow_interp->expr_ev == 0) {
        x = convert_float(c, flow_interp);
        if (x < 0.0)
            return -1;
        else {
            if (x > 0.0)
                return 1;
            else
                return 0;
        }
    }
    else {
        if (flow_interp->expr_ev == 1) {
            z.r = 0.;
            Evaluate_C(c, &z, &dum, flow_interp);
            if (z.r < 0.0)
                return -1;
            else {
                if (z.r > 0.0)
                   return 1;
                else
                    return 0;
            }
        }
        else {
            res_Gen = NULL;
            Evaluate_Gen(flow_interp->expr_ev - 2, c, &res_Gen, &dum,
                flow_interp);
            if (res_Gen != NULL) {
                dum = Expreval_ops[flow_interp->expr_ev - 2].sign(res_Gen);
                Expreval_ops[flow_interp->expr_ev - 2].clear(res_Gen);
                return dum;
            }
            else
                return 0;
        }
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Reads lines (of initialization file) and counts them
--------------------------------------------------------------------*/
char *
fgets_count(char *h, int n, FILE *s)
{
    char           *c;

    c = fgets(h, n, s);
    if (c != NULL)
        Init_File_Line++;
    return c;
}
/*------------------------------------------------------------------*/



extern char *_PROGREPL_messg[];
/*--------------------------------------------------------------------
    Function reading the initialization file or the program file
    whose name is 'g'
--------------------------------------------------------------------*/
void
charge_com(char *g, char xg[], int nb, int cas, flow_data *flow_interp,
    FILE *sw, int ini)
{
    int             i,
                    j,
                    l,
                    o,
                    ind,
                    slen,
                    nb_par_b,
                    sil_com_b;
    char            h_ligne[100],
                    nom_com_b[100],
                    k[100],
                    direct[256],
                    inverse[256],
                   *xg_c,
                   *kk[3];
    FILE           *s;

    if (g != NULL)
        s = fopen(g, "r");
    else {
        if (cas == 0) {
            __perms(direct, inverse);
            xg_c = __Xdecode(xg, nb, inverse);
        }
        else
            xg_c = xg;
        s = fmemopen_((void *) xg_c, nb, "r", sw);
        if (cas == 0)
            free(xg_c);
    }
    if (s == NULL) {
        if (flow_interp->IND_COM == 0) {
            err_mess(42);
            exit_interp(NULL);
        }
        else {
            err_mess(23);
            return;
        }
    }
    memset(h_ligne, 0, 100);
    kk[0] = (char *) flow_interp;
    ind = 0;

    while (fgets_count(h_ligne, 99, s) != NULL) {

/*----------------------------------------------------
    Reading of a program (beginning)
----------------------------------------------------*/
        if (h_ligne[0] == ':') {
            slen = strlen(h_ligne);
            if (slen <= 2) {
                if (flow_interp->IND_COM == 0) {
                    err_mess(43);
                    exit_interp(NULL);
                }
                else {
                    fclose(s);
                    err_mess(22);
                    return;
                }
            }
/*--- Name of the program --------------*/
            memcpy(nom_com_b, h_ligne + 1, slen - 2);
            for (i = slen - 2; i < 100; i++)
                nom_com_b[i] = 0;
            if (exist_com(nom_com_b) == 1) {
                kk[1] = ch_copy("delprog");
                kk[2] = nom_com_b;
                if (delprog_cmd(2, kk + 1) == 1) {
                    err_mess(26);
                    free(kk[1]);
                    return;
                }
                free(kk[1]);
                print(flow_interp, "%s%s%s\n", _PROGREPL_messg[0], nom_com_b,
                    _PROGREPL_messg[1]);
            }
            memset(h_ligne, 0, 100);
            j = 0;


/*--- Number of parameters -------------*/
            while (j == 0) {
                if (fgets_count(h_ligne, 99, s) == NULL) {
                    if (flow_interp->IND_COM == 0) {
                        err_mess(44);
                        exit_interp(NULL);
                    }
                    else {
                        fclose(s);
                        err_mess(22);
                        return;
                    }
                }
                if (h_ligne[0] != ';')
                    j = 1;
            }

            nettoie(h_ligne);
            nb_par_b = convert_int(h_ligne, flow_interp);
            if (nb_par_b <= 0 || nb_par_b > 10) {
                if (flow_interp->IND_COM == 0) {
                    err_mess(45);
                    exit_interp(NULL);
                }
                else {
                    fclose(s);
                    err_mess(22);
                    return;
                }
             }
/*--------------------------------------*/


/*--- Index of silence -----------------*/
            j = 0;

            while (j == 0) {
                if (fgets_count(h_ligne, 99, s) == NULL) {
                    if (flow_interp->IND_COM == 0) {
                        err_mess(44);
                        exit_interp(NULL);
                    }
                    else {
                        fclose(s);
                        err_mess(22);
                        return;
                    }
                }

                if (h_ligne[0] != ';') /* comment line */
                    j = 1;
            }

            nettoie(h_ligne);
            sil_com_b = convert_int(h_ligne, flow_interp);
/*--------------------------------------*/


/*--- Running modes --------------------*/
            j = 0;

            while (j == 0) {
                if (fgets_count(h_ligne, 99, s) == NULL) {
                    if (flow_interp->IND_COM == 0) {
                        err_mess(44);
                        exit_interp(NULL);
                    }
                    else {
                        fclose(s);
                        err_mess(22);
                        return;
                    }
                }
                if (h_ligne[0] != ';') /* comment line */
                    j = 1;
            }

            nettoie(h_ligne);
            slen = strlen(h_ligne);
            i = 0;
            j = -1;
            memset(k, 0, 100);
            if (nb_com == __nbcom)  {
                err_mess(66);
                return;
            }

            nb_com++;

            while (i < slen) {
                if (isspace(h_ligne[i]) == 0) {
                    j++;
                    k[j] = h_ligne[i];
                    i++;
                }
                if (isspace(h_ligne[i]) != 0 || i == slen) {
                    if ((int) strlen(k) > 0) {
                        j = convert_int(k, flow_interp);
                        if (j < 0)
                            for (l = 0; l < __nmode_fonc; l++)
                                mode_com_int[nb_com - 1][l] = 1;
                        else
                            if (j < __nmode_fonc)
                                mode_com_int[nb_com - 1][j] = 1;
                        memset(k, 0, 100);
                        j = -1;
                    }
                    i++;
                }
            }
/*--------------------------------------*/


/*--- Initializations ------------------*/
            nom_com[nb_com - 1] = (char *) malloc((size_t)
                (strlen(nom_com_b) + 1) * sizeof(char));
            sprintf(nom_com[nb_com - 1], "%s", nom_com_b);
            nom_com[nb_com - 1][strlen(nom_com_b)] = 0;
            nb_par[nb_com - 1] = nb_par_b - 1;
            sil_com[nb_com - 1] = sil_com_b;
            nb_lignes[nb_com - 1] = 0;
            nb_label[nb_com - 1] = 0;
            tr_label[nb_com - 1] = 0;
            Is_Del_prog[nb_com - 1] = flow_interp->IND_COM;
            Is_visible_prog[nb_com - 1] = 1;
        ind = 1;
/*--------------------------------------*/
        }
/*--------------------------------------------------*/


        else {
/*----------------------------------------------------
    Reading of a section of an inititialization file
----------------------------------------------------*/
            if (h_ligne[0] == '!' && ini == 0) {
                if (flow_interp->IND_COM == 1) {
                    fclose(s);
                    return;
                }
                else {
                    flow_interp0 = flow_interp;
                    interp_com(s, h_ligne, flow_interp);
                }
            }
/*--------------------------------------------------*/


            else {
/*----------------------------------------------------
    Reading of a program (lines)
----------------------------------------------------*/
                if (h_ligne[0] != ';' && h_ligne[0] != '\n' &&
                     nb_com > 0 && ind == 1 && isnon_0(h_ligne) == 1) {
                    if (nb_lignes[nb_com - 1] < __nblignes - 1) {
                        slen = strlen(h_ligne);
                        ligne_com[nb_com - 1][nb_lignes[nb_com - 1]] =
                            (char *) malloc((size_t) slen * sizeof(char));
                        memcpy(ligne_com[nb_com - 1][nb_lignes[nb_com - 1]],
                            h_ligne, slen - 1);
                        ligne_com[nb_com - 1][nb_lignes[nb_com - 1]]
                            [slen - 1] = 0;
                        Argv_com[nb_com - 1][nb_lignes[nb_com - 1]] = (char **)
                            malloc((size_t) (__nbargmax + 2) * sizeof(char *));
                        for (o = 0; o < __nbargmax + 2; o++)
                            Argv_com[nb_com - 1][nb_lignes[nb_com - 1]][o] =
                                NULL;
                        extrait_argv_com(nb_com - 1, Argc_com[nb_com - 1] +
                            nb_lignes[nb_com - 1], nb_lignes[nb_com - 1],
                            Argv_com[nb_com - 1][nb_lignes[nb_com - 1]],
                            flow_interp);
                        nb_lignes[nb_com - 1]++;
                    }
                    else
                        err_mess(27);
                }
            }
/*--------------------------------------------------*/
        }
        memset(h_ligne, 0, 100);
    }

    fclose(s);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Finds if a string contains something
--------------------------------------------------------------------*/
int
isnon_0(char *g)
{
    int             i;

    for (i = 0; i < (int) strlen(g); i++) {
        if (isspace(g[i]) == 0)
            return 1;
    }

    return 0;
}
/*------------------------------------------------------------------*/



#define isnum(c)  (c >= '0' && c <= '9')

/*--------------------------------------------------------------------
    Finds if substitutions must be made in command lines
--------------------------------------------------------------------*/
void
Find_subst(int i0, int j0)
{
    int             i,
                    j,
                    k,
                    ind,
                    ind2,
                    ind3,
                    len;
    char           *W;

    Is_subst_ligne[i0][j0] = 0;
    ind = 0;

    for (i = 0; i < Argc_com[i0][j0]; i++) {
        W = Argv_com[i0][j0][i];
        len = strlen(W);
        ind2 = 0;
        ind3 = 0;

        for (j = 0; j < len; j++) {
            if (W[j] == '#') {
                if (j < len - 1 && (isnum(W[j + 1]) || W[j + 1] ==
                    Subst_Pat[0].delim.begin)) {
                    ind++;
                    ind2++;
                    break;
                }
            }
        }

        if (ind2 != 0) {
            if (Is_subst_arg[i0][j0] == NULL) {
                Is_subst_arg[i0][j0] = (int *) malloc((size_t) Argc_com[i0][j0]
                    * sizeof(int));
                for (k = 0; k < Argc_com[i0][j0]; k++)
                    Is_subst_arg[i0][j0][k] = 0;
            }
            Is_subst_arg[i0][j0][i] = 1;
        }

        if (ind2 == 0) {
            for (j = 0; j < len - 1; j++)
                for (k = 1; k < n_subst_pat; k++) {
                    if (W[j] == Subst_Pat[k].orig && W[j + 1] ==
                        Subst_Pat[k].delim.begin) {
                        ind++;
                        ind3++;
                        break;
                    }
                }

            if (ind3 != 0) {
                if (Is_subst_arg[i0][j0] == NULL) {
                    Is_subst_arg[i0][j0] = (int *) malloc((size_t)
                        Argc_com[i0][j0] * sizeof(int));
                    for (k = 0; k < Argc_com[i0][j0]; k++)
                        Is_subst_arg[i0][j0][k] = 0;
                }
                Is_subst_arg[i0][j0][i] = 1;
            }
        }
    }

    Is_subst_ligne[i0][j0] = ind;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function executing the function associated to a section of
    an initialization file
--------------------------------------------------------------------*/
void
interp_com(FILE *s, char *h_ligne, flow_data *flow_interp)
{
    int             i;
    char           *name_c;

    i = 0;
    name_c = h_ligne + 1;
    name_c[strlen(name_c) - 1] = 0;

    while (namesb[i][0] != 0) {
        if (comp(namesb[i], name_c) == 1) {
            (*(procb[i])) (s, name_c, flow_interp);
            return;
        }
        i++;
    }

    i = 0;

    while (namesb_user[i][0] != 0) {
        if (comp(namesb_user[i], name_c) == 1) {
            (*(procb_user[i])) (s, name_c, flow_interp);
            return;
        }
        i++;
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!mode' of an initialization
    file
--------------------------------------------------------------------*/
int
mode_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             slen;
    char            h_ligne[100];

    memset(h_ligne, 0, 100);
    if (nb_mode_fonc >= __nmode_fonc - 2)
        exit_interp("mode");
    nb_mode_fonc++;
    if (fgets_count(h_ligne, 99, s) == NULL)
        exit_interp("mode");
    slen = strlen(h_ligne) - 1;
    if (slen == 1)
        exit_interp("mode");
    h_ligne[slen] = 0;
    prompt_mode[nb_mode_fonc] = (char *) malloc((size_t) (slen + 1)
        * sizeof(char));
    memcpy(prompt_mode[nb_mode_fonc], h_ligne, slen);
    prompt_mode[nb_mode_fonc][slen] = 0;
    ind_x_mode = 1;

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function reading character strings in an initialization file
    (called by the functions associated to the sections '!greet'
    and '!message')
--------------------------------------------------------------------*/
int
gr_cmd(FILE *s, char *name_c, char **gr, int *i_gr, int i_grmax)
{
    int             slen;
    char            h_ligne[100];


    memset(h_ligne, 0, 100);

    while (fgets_count(h_ligne, 99, s) != NULL && i_gr[0] < i_grmax) {
        if (h_ligne[0] == '.')
            return 0;
        if (h_ligne[0] != ';') {
            i_gr[0]++;
            slen = strlen(h_ligne) - 1;
            if (slen > 2) {
                if (h_ligne[slen - 1] == 'n' && h_ligne[slen - 2] == 92) {
                    h_ligne[slen - 2] = '\n';
                    slen--;
                }
            }
            gr[i_gr[0]] = (char *) malloc((size_t) (slen + 2) * sizeof(char));
            memcpy(gr[i_gr[0]], h_ligne, slen);
            gr[i_gr[0]][slen] = 0;
        }
    }

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!greet' of an initialization
    file
--------------------------------------------------------------------*/
int
greet_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    if (ind_greet_x == 1)
        return 1;
    i_greet = -1;
    ind_greet_x = 1;
    return gr_cmd(s, name_c, greet, &i_greet, __greet_max);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!message' of an initialization
    file
--------------------------------------------------------------------*/
int
mess_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    return gr_cmd(s, name_c, mess, &i_message, __mess_max);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!func' of an initialization
    file
--------------------------------------------------------------------*/
int
func_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             slen,
                    i,
                    j,
                    l,
                    m;
    char            h_ligne[100],
                    k[100];

    memset(h_ligne, 0, 100);
    i_func_ind++;
    m = -1;
    if (func_init == 1)
        i_func_ind--;

    while (fgets_count(h_ligne, 99, s) != NULL && nb_commandes <
        __com_max - 1) {
        if (h_ligne[0] == '.') {
            ch_prem();
            if (nb_commandes >= 0)
                ind_x_func = 1;
            return 1;
        }
        if (proc[i_func_ind] != NULL) {
            m++;
            if (proc[i_func_ind][m] != NULL) {
                procw[nb_commandes + 1] = proc[i_func_ind][m];
                slen = strlen(h_ligne) - 1;
                names[nb_commandes + 1] = (char *) malloc((size_t) (slen + 1) *
                    sizeof(char));
                memcpy(names[nb_commandes + 1], h_ligne, slen);
                len_n[nb_commandes + 1] = slen;
                names[nb_commandes + 1][slen] = 0;
                if (exist_com(names[nb_commandes + 1]) == 1) {
                    err_mess(46);
                    exit_interp("func");
                }
                nb_commandes++;
                memset(h_ligne, 0, 100);
                if (fgets_count(h_ligne, 99, s) == NULL)
                    exit_interp("func");
                nettoie(h_ligne);
                par_com[nb_commandes] = convert_int(h_ligne, flow_interp);
                if (par_com[nb_commandes] < 1 || par_com[nb_commandes]
                    > __nbargmax) {
                    err_mess(45);
                    exit_interp("func");
                }
                memset(h_ligne, 0, 100);
                if (fgets_count(h_ligne, 99, s) == NULL)
                    exit_interp("func");
                nettoie(h_ligne);
                slen = strlen(h_ligne);
                i = 0;
                j = -1;
                memset(k, 0, 100);

                while (i < slen) {
                    if (isspace(h_ligne[i]) == 0) {
                        j++;
                        k[j] = h_ligne[i];
                        i++;
                    }
                    if (isspace(h_ligne[i]) != 0 || i == slen) {
                        if ((int) strlen(k) > 0) {
                            j = convert_int(k, flow_interp);
                            if (j < 0)
                                for (l = 0; l < __nmode_fonc; l++)
                                    mode_com[nb_commandes][l] = 1;
                            else
                                if (j < __nmode_fonc)
                                    mode_com[nb_commandes][j] = 1;
                            memset(k, 0, 100);
                            j = -1;
                        }
                        i++;
                    }
                }
            }
        }
    }

    ch_prem();
    if (nb_commandes >= 0)
        ind_x_func = 1;
    return 0;
}
/*------------------------------------------------------------------*/




/*-------------------------------------------------------------------
    Function ordering the commands according to their name
--------------------------------------------------------------------*/
void
ch_prem(void)
{
    int             i,
                    j,
                    k;

    k = 0;
    for (i = 0; i < nb_commandes - 1; i++)
        if (est_avant(names[i + 1], names[i]) == 1)
            k = 1;

    if (k == 1) {
        for (i = 0; i < nb_commandes; i++)
            for (j = i + 1; j < nb_commandes; j++)
                if (est_avant(names[j], names[i]) == 1)
                    echange_nom(i, j);
    }

    for (i = 0; i < 127; i++) {
        deb_nom[i] = nb_commandes + 1;

        for (j = 0; j <= nb_commandes; j++) {
            if (names[j][0] == (char) i) {
                deb_nom[i] = j;
                break;
            }
        }

        fin_nom[i] = -1;
        if (deb_nom[i] <= nb_commandes) {
            for (k = j; k <= nb_commandes; k++)
                if (names[k][0] == (char) i)
                    fin_nom[i] = k;
        }
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function returning 1 if the command name i0 is before the
    command name i1
--------------------------------------------------------------------*/
int
est_avant(char *c0, char *c1)
{
    int             i;

    i = 0;

    while (c0[i] != 0) {
        if (c1[i] == 0)
            return 0;
        if (c0[i] < c1[i])
            return 1;
        if (c0[i] > c1[i])
            return 0;
        i++;
    }

    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Interchange the commands i0 and i1
--------------------------------------------------------------------*/
void
echange_nom(int i0, int i1)
{
    int             i,
                    j;
    char           *xx;
    pfi             f;

    xx = names[i0];
    names[i0] = names[i1];
    names[i1] = xx;
    i = par_com[i0];
    par_com[i0] = par_com[i1];
    par_com[i1] = i;

    for (i = 0; i < __nmode_fonc; i++) {
         j = mode_com[i0][i];
         mode_com[i0][i] = mode_com[i1][i];
         mode_com[i1][i] = j;
    }

    f = procw[i0];
    procw[i0] = procw[i1];
    procw[i1] = f;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function returning 1 if the number of parameters given to
    a command is big enough, and 0 otherwise
--------------------------------------------------------------------*/
int
test_param(int nb_arg, int i_com0)
{
    if (nb_arg < par_com[i_com0]) {
        err_mess(0);
        return 0;
    }
    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!param' of an initialization
    file
--------------------------------------------------------------------*/
int
param_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             i,
                    j,
                    l,
                    nb,
                    slen;
    char            h_ligne[100],
                   *k;

    if (ind_x_param == 1)
        return 1;
    nb = 0;
    memset(h_ligne, 0, 100);

    while (fgets_count(h_ligne, 99, s) != NULL && nb < 22) {
        if (h_ligne[0] == '.') {
            if (nb == 21)
                ind_x_param = 1;
            return 0;
        }
        if (h_ligne[0] != ';') {
            nb++;
            slen = strlen(h_ligne) - 1;
            h_ligne[slen] = 0;

            if (nb == 1) {   /* Maximal number of programs */
                __nbcom = convert_int(h_ligne, flow_interp);
                if (__nbcom < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                nb_par = (int *) malloc((size_t) __nbcom * sizeof(int));
                sil_com = (int *) malloc((size_t) __nbcom * sizeof(int));
                nb_lignes = (int *) malloc((size_t) __nbcom * sizeof(int));
                nom_com = (char **) malloc((size_t) __nbcom * sizeof(char *));
                for (i = 0; i < __nbcom; i++)
                    nom_com[i] = NULL;
                ligne_com = (char ***) malloc((size_t) __nbcom *
                    sizeof(char **));
                mode_com_int = (int **) malloc((size_t) __nbcom *
                    sizeof(int *));
                nb_label = (int *) malloc((size_t) __nbcom * sizeof(int));
                tr_label = (int *) malloc((size_t) __nbcom * sizeof(int));
                for (i = 0; i < __nbcom; i++)
                    tr_label[i] = 0;
                num_label = (int **) malloc((size_t) __nbcom * sizeof(int *));
                for (i = 0; i < __nbcom; i++)
                    num_label[i] = NULL;
                Argc_com = (int **) malloc((size_t) __nbcom * sizeof(int *));
                Argv_com = (char ****) malloc((size_t) __nbcom *
                    sizeof(char ***));
                Is_subst_ligne = (int **) malloc((size_t) __nbcom *
                    sizeof(int *));
                Is_subst_arg = (int ***) malloc((size_t) __nbcom *
                    sizeof(int **));
                Is_Del_prog = (int *) malloc((size_t) __nbcom * sizeof(int));
                Is_visible_prog = (int *) malloc((size_t) __nbcom *
                    sizeof(int));
                for (i = 0; i < __nbcom; i++)
                    Is_visible_prog[i] = 0;
            }

            if (nb == 2) {   /* Maximal number of lines in a program */
                __nblignes = convert_int(h_ligne, flow_interp);
                if (__nblignes < 1) {
                    err_mess(47);
                    exit_interp("param");
                }

                for (i = 0; i < __nbcom; i++) {
                    ligne_com[i] = (char **) malloc((size_t) __nblignes *
                        sizeof(char *));
                    Argv_com[i] = (char ***) malloc((size_t) __nblignes *
                        sizeof(char **));
                    Argc_com[i] = (int *) malloc((size_t) __nblignes *
                        sizeof(int));
                    Is_subst_ligne[i] = (int *) malloc((size_t) __nblignes *
                        sizeof(int));
                    Is_subst_arg[i] = (int **) malloc((size_t) __nblignes *
                        sizeof(int *));

                    for (j = 0; j < __nblignes; j++) {
                        Is_subst_arg[i][j] = NULL;
                        Is_subst_ligne[i][j] = 0;
                    }
                }
            }

            if (nb == 3) {   /* Maximal number of commands */
                __com_max = convert_int(h_ligne, flow_interp);
                if (__com_max < _COMM_INTERP) {
                    err_mess(47);
                    exit_interp("param");
                }
                names = (char **) malloc((size_t)__com_max * sizeof(char *));
                mode_com = (int **) malloc((size_t) __com_max * sizeof(int *));
                par_com = (int *) malloc((size_t) __com_max * sizeof(int));
                len_n = (int *) malloc((size_t) __com_max * sizeof(int));
                deb_nom = (int *) malloc((size_t) __com_max * sizeof(int));
                fin_nom = (int *) malloc((size_t) __com_max * sizeof(int));
                procw = (pfi *) malloc((size_t) __com_max * sizeof(pfi));
                nb_commandes = _COMM_INTERP - 1;

                for (i = 0; i < _COMM_INTERP; i++) {
                    names[i] = ch_copy(names_interp[i]);
                    procw[i] = proc_interp[i];
                    par_com[i] = n_arg_com_interp[i];
                }

                ch_prem();
            }

            if (nb == 4) {   /* Maximal number of lines of the greeting
                                message                              */
                __greet_max = convert_int(h_ligne, flow_interp);
                if (__greet_max < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                greet = (char **) malloc((size_t)__greet_max * sizeof(char *));
                for (i = 0; i < __greet_max; i++)
                    greet[i] = NULL;
            }

            if (nb == 5) {   /* Maximal number of messages           */
                __mess_max = convert_int(h_ligne, flow_interp);
                if (__mess_max < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                mess = (char **) malloc((size_t)__mess_max * sizeof(char *));
                for (i = 0; i < __mess_max; i++)
                    mess[i] = NULL;
            }

            if (nb == 6) {   /* Maximal number of open files         */
                __nss = convert_int(h_ligne, flow_interp);
                if (__nss < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                sS = (FILE **) malloc((size_t) __nss * sizeof(FILE *));
                sS_cmpt = (int *) malloc((size_t) __nss * sizeof(int));
                sS_i_o = (int *) malloc((size_t) __nss * sizeof(int));

                for (i = 0; i < __nss; i++) {
                    sS[i] = NULL;
                    sS_cmpt[i] = 0;
                }

                sS_nom = (char **) malloc((size_t) __nss * sizeof(char *));
                for (i = 0; i < __nss; i++)
                    sS_nom[i] = NULL;
            }

            if (nb == 7) {   /* Maximal number of running modes     */
                __nmode_fonc = convert_int(h_ligne, flow_interp);
                if (__nmode_fonc < 1) {
                    err_mess(47);
                    exit_interp("param");
                }

                for (i = 0; i < __com_max; i++) {
                    mode_com[i] = (int *) malloc((size_t) __nmode_fonc *
                        sizeof(int));
                    for (j = 0; j < __nmode_fonc; j++)
                        mode_com[i][j] = 0;
                }

                for (i = 0; i < __nbcom; i++) {
                    mode_com_int[i] = (int *) malloc((size_t) __nmode_fonc *
                        sizeof(int));
                    for (j = 0; j < __nmode_fonc; j++)
                        mode_com_int[i][j] = 0;
                }

                for (i = 0; i <= nb_commandes; i++)
                    for (j = 0; j < __nmode_fonc; j++)
                        mode_com[i][j] = 1;

                prompt_mode = (char **) malloc((size_t) __nmode_fonc *
                    sizeof(char *));
                for (i = 0; i < __nmode_fonc; i++)
                    prompt_mode[i] = NULL;
                prompt_mode[__nmode_fonc - 1] =
                    (char *) malloc((size_t) 25 * sizeof(char));
                memset(prompt_mode[__nmode_fonc - 1], 0, 25);
                sprintf(prompt_mode[__nmode_fonc - 1],
                    " ------------------> ");
            }

            if (nb == 8) {   /* Maximal number of 'voices'           */
                __maxvoice = convert_int(h_ligne, flow_interp);
                if (__maxvoice < 2) {
                    err_mess(47);
                    exit_interp("param");
                }
            }

            if (nb == 9) {   /* Maximal number of conditions        */
                __nbcond = convert_int(h_ligne, flow_interp);
                if (__nbcond < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                s_cond = (int *) malloc((size_t) __nbcond * sizeof(int));
                for (i = 0; i < __nbcond; i++)
                    s_cond[i] = 0;
                v_cond = (v_c *) malloc((size_t) __nbcond * sizeof(v_c));
            }

            if (nb == 10) {  /* Maximal number of object types      */
                __nbtypmax = convert_int(h_ligne, flow_interp);
                if (__nbtypmax < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                mode_com_obj = int_alloc2(__nbtypmax, __nmode_fonc);
                Obj_alias = int_alloc1(__nbtypmax);
                Obj_typ = (obj_typ *) malloc((size_t) __nbtypmax *
                    sizeof(obj_typ));
                Obj = (obj **) malloc((size_t) __nbtypmax * sizeof(obj *));
            }

            if (nb == 11) {  /* Maximal number of arguments of commands */
                __nbargmax = convert_int(h_ligne, flow_interp);
                if (__nbargmax < 5) {
                    err_mess(47);
                    exit_interp("param");
                }
            }

            if (nb == 12) {  /* Maximal number of structure types    */
                __nbstrucmax = convert_int(h_ligne, flow_interp);
                 if (__nbstrucmax < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                mode_com_str = int_alloc2(__nbstrucmax, __nmode_fonc);
                Struc_typ = (struc_typ *) malloc((size_t) __nbstrucmax *
                    sizeof(struc_typ));
                Struc = (strucb **) malloc((size_t) __nbstrucmax *
                    sizeof(strucb *));
            }

            if (nb == 13) {  /* Maximal number of labels in a program  */
                __nblabelmax = convert_int(h_ligne, flow_interp);
                if (__nblabelmax < 5) {
                    err_mess(47);
                    exit_interp("param");
                }
            }

            if (nb == 14) {  /* Maximal number of character strings in
                                question files                         */
                __max_quest = convert_int(h_ligne, flow_interp);
                if (__max_quest < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                ques = (char **) malloc((size_t) __max_quest * sizeof(char *));
                for (i = 0; i < __max_quest; i++)
                    ques[i] = (char *) malloc((size_t) MAX_CARS_COM *
                        sizeof(char));
            }

            if (nb == 15) {  /* Maximal number of preceeding commands  */
                __n_com_prec = convert_int(h_ligne, flow_interp);
                if (__n_com_prec < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
            }

            if (nb == 16) {  /* Maximal number threads  */
                __n_max_threads = convert_int(h_ligne, flow_interp);
                if (__n_max_threads < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                flow_I = (flow_data *) malloc((size_t) __n_max_threads *
                    sizeof(flow_data));

                 for (i = 0; i < __n_max_threads; i++) {
                     flow_I[i].used = 0;
                     flow_I[i].name = NULL;
                 }
            }

            if (nb == 17) {  /* Maximal number of string variables */
                __max_Env_st = convert_int(h_ligne, flow_interp);
                if (__max_Env_st < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                Env_string = (char **) malloc((size_t) __max_Env_st *
                    sizeof(char *));
                Env_string2 = (char **) malloc((size_t) __max_Env_st *
                    sizeof(char *));

                for (i = 0; i < __max_Env_st; i++) {
                    Env_string[i] = NULL;
                    Env_string2[i] = NULL;
                }
            }

            if (nb == 18) {  /* Maximal number of sustitution patterns */
                __max_subst_pat = convert_int(h_ligne, flow_interp);
                if (__max_subst_pat < 5) {
                    err_mess(47);
                    exit_interp("param");
                }
                Subst_Pat = (subst_pat *) malloc((size_t) __max_subst_pat *
                    sizeof(subst_pat));
                Subst_Delim = (subst_delim *) malloc((size_t) __max_subst_pat *
                    sizeof(subst_delim));
                for (i = 0; i < __max_subst_pat; i++)
                    Subst_Pat[i].orig = 0;
            }

            if (nb == 19) {  /* Maximal number of expression
                                evaluators */
                __n_expr_eval = convert_int(h_ligne, flow_interp);
                if (__n_expr_eval < 1) {
                    err_mess(47);
                    exit_interp("param");
                }
                Expreval_ops = (EXPREVAL_GEN *) malloc(__n_expr_eval *
                    sizeof(EXPREVAL_GEN));
                _NBFONC_Gen = (int *) malloc(__n_expr_eval * sizeof(int));
                for (i = 0; i < __n_expr_eval; i++)
                    _NBFONC_Gen[i] = 0;
            }
            if (nb == 20) {  /* Maximal number of help subjects */
                __nbhelpsubj = convert_int(h_ligne, flow_interp);
                if (__nbhelpsubj > 0) {
                    help_name = (char **) malloc((size_t) __nbhelpsubj *
                        sizeof(char *));
                    help_content = (char **) malloc((size_t) __nbhelpsubj *
                        sizeof(char *));
                    help_name_length = (int *) malloc((size_t) __nbhelpsubj *
                        sizeof(int));
                    nb_help_print = (int *) malloc((size_t) __nbhelpsubj *
                        sizeof(int));

                    for (i = 0; i < __nbhelpsubj; i++) {
                        help_name[i] = NULL;
                        help_content[i] = NULL;
                        nb_help_print[i] = 0;
                    }
                }
            }
            if (nb == 21) {  /* Maximal number of used defined functions */
                __nbuserfunc = convert_int(h_ligne, flow_interp);
                if (__nbuserfunc > 0) {
                    _NBFONC_B = 0;
                    Funcs_b = (FUNCTION_B *) malloc((size_t) __nbuserfunc *
                        sizeof(FUNCTION_B));

                    for (i = 0; i < __nbuserfunc; i++) {
                        Funcs_b[i].name = NULL;
                        Funcs_b[i].args = 0;
                        Funcs_b[i].form = NULL;
                    }

                    Vars_F_name = (char **) malloc((size_t) MAX_F_ARGS *
                        sizeof(char *));

                    for (i = 0; i < MAX_F_ARGS; i++) {
                        k = ch_copy_int(i);
                        l = strlen(k) + 2;
                        Vars_F_name[i] = (char *) malloc((size_t) l *
                            sizeof(char));
                        memset(Vars_F_name[i], 0, l);
                        Vars_F_name[i][0] = 'x';
                        strcat(Vars_F_name[i], k);
                        Vars_F_name[i][l - 1] = 0;
                        free(k);
                    }
                }
            }
        }
        memset(h_ligne, 0, 100);
    }

    if (nb == 21)
        ind_x_param = 1;
    else
        exit_interp("param");
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!var' of an initialization
    file
--------------------------------------------------------------------*/
int
var_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             n;
    char            h_ligne[100],
                    h[150],
                    k[200];

    memset(h_ligne, 0, 100);

    while (fgets_count(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.')
            return 0;
        if (h_ligne[0] != ';') {
            memset(h, 0, 150);
            nettoie(h_ligne);
            strcat(h, h_ligne);
            memset(h_ligne, 0, 100);
            if (fgets_count(h_ligne, 99, s) == NULL)
                exit_interp("var");
            if (h_ligne[0] == '.' || h_ligne[0] == ':' || h_ligne[0] == '!')
                exit_interp("var");
            nettoie(h_ligne);
            n = convert_int(h_ligne, flow_interp);
            memset(k, 0, 200);
            sprintf(k, "%s=%d", h, n);
            S_convert_int(k, flow_interp);
            memset(h_ligne, 0, 100);
        }
    }

    return 0;
}
/*------------------------------------------------------------------*/




/*---------------------------------------------------------------------
    Function associated to the section '!rep' of an initialization
    file
---------------------------------------------------------------------*/
int
rep_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             i,
                    n;
    char            h_ligne[100];

    if (ind_x_rep == 1)
        return 1;
    memset(h_ligne, 0, 100);
    n = 0;

    while (fgets_count(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.' && n == 4) {
            ind_x_rep = 1;
            return 0;
        }
        if (h_ligne[0] == '!' || h_ligne[0] == ':')
            exit_interp("rep");
        if (h_ligne[0] != ';') {
            nettoie(h_ligne);
            i = strlen(h_ligne);
            if (h_ligne[i - 1] != '/')
                h_ligne[i] = '/';
            if (n == 0) {
                memset(command_rep, 0, 80);
                strcpy(command_rep, h_ligne);
            }
            if (n == 1) {
                memset(result_rep, 0, 80);
                strcpy(result_rep, h_ligne);
            }
            if (n == 2) {
                memset(data_rep, 0, 80);
                strcpy(data_rep, h_ligne);
            }
            if (n == 3) {
                memset(data_rep2, 0, 80);
                strcpy(data_rep2, h_ligne);
            }
            memset(h_ligne, 0, 100);
            n++;
        }
    }

    if (n == 4)
        ind_x_rep = 1;
    else
        exit_interp("rep");
    return 1;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!init' of an initialization
    file
--------------------------------------------------------------------*/
int
init_interp_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    int             n,
                    i,
                    j,
                    ind,
                    argn;
    char            h_ligne[100],
                    argtemp[100];

    n = 0;
    argn = -1;
    argv_init_interp = argv_init_interp_b + 1;
    argv_init_interp[-1] = (char *) flow_interp;

    while (fgets(h_ligne, 99, s) != NULL) {
        if (n == 2) {
            i_init_interp = 1;
            argc_init_interp = argn + 1;
            return 0;
        }
        nettoie(h_ligne);
        if (n == 0) {
            n = 1;
            sil_init_interp = convert_int(h_ligne, flow_interp);
        }
        else {
            n = 2;
            argn = -1;
            i = 0;
            ind = 0;
            j = 0;

            while (h_ligne[i] != 0) {
                if (isspace(h_ligne[i]) == 0) {
                    ind = 1;
                    argn++;
                    j = 0;
                    argtemp[j] = h_ligne[i++];

                    while (isspace(h_ligne[i]) == 0 && h_ligne[i] != 0) {
                        argtemp[++j] = h_ligne[i++];
                    }
                }
                i++;
                if (ind == 1) {
                    argv_init_interp[argn] = (char *) malloc((size_t) (j + 2) *
                        sizeof(char));
                    memcpy(argv_init_interp[argn], argtemp, j + 1);
                    argv_init_interp[argn][j + 1] = 0;
                    memset(argtemp, 0, 100);
                }
                ind = 0;
            }
        }
    }

    exit_interp("init");
    return 1;
}
/*------------------------------------------------------------------*/




extern char *_INITERR_messg[];
/*--------------------------------------------------------------------
    Function called when the command interpreter ends after an error
--------------------------------------------------------------------*/
void
exit_interp(char *w)
{
    if (w != NULL)
        printf("%s%s%s\n", _INITERR_messg[0], w, _INITERR_messg[1]);
    else
        printf("%s\n", _INITERR_messg[2]);
    printf("%s%d\n", _INITERR_messg[3], Init_File_Line);
    exit(0);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function printing an error message of the command interpreter
--------------------------------------------------------------------*/
void
err_mess(int i)
{
#ifndef _WIN32
    printf("%s %s ; %s%s\n", esp_decalage, col_mess, mess_interp[i],
        end_col_mess);
#else
    printf("%s ; %s\n", esp_decalage, mess_interp[i]);
#endif
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Treatment of the 'goto', 'if', 'do', 'enddo' in programs
--------------------------------------------------------------------*/
void
traite_label(flow_data *flow_interp)
{
    int             i,
                    argc_com,
                    j,
                    k,
                    l,
                    n,
                   *nb;
    char          **nom_label,
                  **argv_com,
                   *v,
                    h[200],
                    h1[200],
                    h2[200],
                    h3[200],
                    pos[1000];

    nom_label = (char **) malloc((size_t) __nblabelmax * sizeof(char *));
    for (i = 0; i < __nblabelmax; i++)
        nom_label[i] = NULL;
    nb = int_alloc1(__nblabelmax);
    argv_com = (char **) malloc((size_t)(__nbargmax + 2) * sizeof(char *));
    for (i = 0; i < __nbargmax + 2; i++)
        argv_com[i] = NULL;

    for (i = 0; i < nb_com; i++) {
        if (tr_label[i] == 0) {
/*-------------------------------------------------
    Treatment of lines 'do...' and 'enddo...'
-------------------------------------------------*/
            j = 0;
            n = -1;

            while (j < nb_lignes[i]) {
                extrait_argv_com(i, &argc_com, j, argv_com, flow_interp);

                if (comp(argv_com[0], "do") == 1) {
                    if (argc_com < 4) {
                        supprime_ligne_com(i,j);
                        j--;
                    }
                    else {
                        memset(h, 0, 200);
                        h[0] = _EVAL;
                        h[1] = ' ';
                        strcat(h, argv_com[1]);
                        strcat(h, "=");
                        strcat(h, argv_com[2]);
                        strcat(h, "-");
                        if (argc_com == 4)
                            strcat(h, "1");
                        else {
                            strcat(h, "(");
                            strcat(h, argv_com[4]);
                            strcat(h, ")");
                        }
                        memset(h1, 0, 200);
                        h1[0] = 127;
                        v = h1 + 1;
                        n++;
                        sprintf(v, "%d:", n);

                        memset(h2, 0, 200);
                        h2[0] = _EVAL;
                        h2[1] = ' ';
                        strcat(h2, argv_com[1]);
                        strcat(h2, "=");
                        strcat(h2, argv_com[1]);
                        strcat(h2, "+");
                        if (argc_com == 4)
                            strcat(h2, "1");
                        else {
                            strcat(h2, "(");
                            strcat(h2, argv_com[4]);
                            strcat(h2, ")");
                        }
                        memset(h3, 0, 200);
                        strcpy(h3, "if> ");
                        strcat(h3, argv_com[1]);
                        strcat(h3, "-");
                        strcat(h3, "(");
                        strcat(h3, argv_com[3]);
                        strcat(h3, ")");
                        strcat(h3, " ");
                        h3[strlen(h3)] = 127;
                        v = h3 + strlen(h3);
                        pos[n] = 0;
                        n++;
                        sprintf(v, "%d", n);
                        supprime_ligne_com(i, j);
                        insere_ligne_com(i, j, h, flow_interp);
                        insere_ligne_com(i, j + 1, h1, flow_interp);
                        insere_ligne_com(i, j + 2, h2, flow_interp);
                        insere_ligne_com(i, j + 3, h3, flow_interp);
                        j += 3;
                    }
                }

                if (comp(argv_com[0], "enddo") == 1) {
                    l = -1;

                    for (k = n - 1; k >= 0; k -= 2) {
                        if (pos[k] == 0) {
                            l = k;
                            break;
                        }
                    }

                    if (l == -1) {
                        supprime_ligne_com(i, j);
                        j--;
                    }
                    else {
                        memset(h, 0, 200);
                        strcpy(h, "goto ");
                        h[strlen(h)] = 127;
                        v = h + strlen(h);
                        sprintf(v, "%d", l);

                        memset(h1, 0, 200);
                        h1[0] = 127;
                        v = h1 + 1;
                        sprintf(v, "%d:", l + 1);
                        supprime_ligne_com(i, j);
                        insere_ligne_com(i, j, h, flow_interp);
                        insere_ligne_com(i, j + 1, h1, flow_interp);
                        pos[l] = 1;
                        j++;
                    }
                }

                j++;
            }
/*-----------------------------------------------*/


/*-------------------------------------------------
    Determination of lines containing labels
-------------------------------------------------*/
            nb_label[i] = 0;
            j = 0;

            while (j < nb_lignes[i]) {
                extrait_argv_com(i, &argc_com, j, argv_com, flow_interp);

                if (argv_com[0][strlen(argv_com[0]) - 1] == ':') {
                    nb[nb_label[i]] = j;
                    nettoie(argv_com[0]);
                    if (nom_label[nb_label[i]] != NULL)
                        free(nom_label[nb_label[i]]);
                    nom_label[nb_label[i]] = ch_copy(argv_com[0]);
                    nb_label[i]++;

                    supprime_ligne_com(i, j);
                    j--;
                }

                j++;
            }

            tr_label[i] = 1;
            if (nb_label[i] > 0) {
                num_label[i] = (int *) malloc((size_t) nb_label[i] *
                    sizeof(int));
                for (k = 0; k < nb_label[i]; k++)
                    num_label[i][k] = nb[k];
            }
/*-----------------------------------------------*/


/*-------------------------------------------------
    treatment of 'goto...'
-------------------------------------------------*/
            j = 0;

            while (j < nb_lignes[i]) {
                extrait_argv_com(i, &argc_com, j, argv_com, flow_interp);
                if (comp(argv_com[0], "goto") == 1) {
                    k = -1;
                    if (argc_com > 1) {

                        for (l = 0; l < nb_label[i]; l++) {
                            if (comp(nom_label[l], argv_com[1]) == 1) {
                                k = l;
                            }
                        }

                        if (k == -1) {
                            supprime_ligne_com(i, j);
                            j--;
                        }
                        else {
                            free(ligne_com[i][j]);
                            ligne_com[i][j] = (char *)malloc(20 * sizeof(char));
                            memset(ligne_com[i][j], 0, 20);
                            ligne_com[i][j][0] = _GOTO;
                            memset(h, 200, 0);
                            sprintf(h, " %d", k);
                            strcat(ligne_com[i][j], h);

                            for (l = 0; l < __nbargmax + 2; l++) {
                                if (Argv_com[i][j][l] != NULL)
                                    free(Argv_com[i][j][l]);
                                Argv_com[i][j][l] = NULL;
                            }

                            extrait_argv_com(i, Argc_com[i] + j, j,
                                Argv_com[i][j], flow_interp);

                        }
                    }
                    else {
                        supprime_ligne_com(i, j);
                        for (k = 0; k < nb_label[i]; k++)
                            if (num_label[i][k] > j)
                                num_label[i][k]--;
                        j--;
                    }
                }

                j++;
            }
/*-----------------------------------------------*/


/*-------------------------------------------------
    treatment of 'if...'
-------------------------------------------------*/
            j = 0;

            while (j < nb_lignes[i]) {
                extrait_argv_com(i, &argc_com, j, argv_com, flow_interp);
                if (comp(argv_com[0], "if>") == 1 ||
                    comp(argv_com[0], "if<") == 1 ||
                    comp(argv_com[0], "if=") == 1) {
                    if (argc_com < 3) {
                        supprime_ligne_com(i, j);
                        for (k = 0; k < nb_label[i]; k++)
                            if (num_label[i][k] > j)
                                num_label[i][k]--;
                        j--;
                    }
                    else {
                        l = -1;

                        for (k = 0; k < nb_label[i]; k++) {
                            if (comp(argv_com[2], nom_label[k]) == 1)
                                l = k;
                        }

                        if (l == -1) {
                            supprime_ligne_com(i, j);
                            for (k = 0; k < nb_label[i]; k++)
                                if (num_label[i][k] > j)
                                    num_label[i][k]--;
                            j--;
                        }
                        else {
                            memset(h, 0, 200);
                            if (comp(argv_com[0], "if>") == 1)
                                h[0] = _IFGT;
                            else {
                                if (comp(argv_com[0], "if<") == 1)
                                    h[0] = _IFLT;
                                else
                                    h[0] = _IFEQ;
                            }
                            h[1] = ' ';
                            strcat(h, argv_com[1]);
                            memset(h1, 0, 200);
                            sprintf(h1, " %d", l);
                            strcat(h, h1);
                            if (argc_com > 3) {
                                l = -1;

                                for (k = 0; k < nb_label[i]; k++) {
                                    if (comp(argv_com[2],
                                        nom_label[k]) == 1)
                                        l = k;
                                }

                                if (l >= 0) {
                                    memset(h2, 0, 200);
                                    sprintf(h2, " %d", l);
                                    strcat(h, h2);
                                }
                            }

                            supprime_ligne_com(i, j);
                            insere_ligne_com(i, j, h, flow_interp);
                        }
                    }
                }
                j++;
            }

            for (j = 0; j < nb_lignes[i]; j++)
                Find_subst(i, j);
        }
/*-----------------------------------------------*/
    }

    XFREE(nb);
    for (i = 0; i < __nblabelmax; i++)
        if (nom_label[i] != NULL)
            free(nom_label[i]);
    free(nom_label);
    for (i = 0; i < __nbargmax + 2; i++)
        if (argv_com[i] != NULL)
            free(argv_com[i]);
    free(argv_com);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Suppression of the line j of program i
--------------------------------------------------------------------*/
void
supprime_ligne_com(int i, int j)
{
    int             k,
                    l;

    free(ligne_com[i][j]);

    for (l = 0; l < __nbargmax + 2; l++) {
        if (Argv_com[i][j][l] != NULL) {
            free(Argv_com[i][j][l]);
            Argv_com[i][j][l] = NULL;
        }
    }

    for (k = j + 1; k < nb_lignes[i]; k++) {
        for (l = 0; l < __nbargmax + 2; l++)
            Argv_com[i][k - 1][l] = NULL;
        ligne_com[i][k - 1] = ligne_com[i][k];
        Argc_com[i][k - 1] = Argc_com[i][k];
        for (l = 0; l < Argc_com[i][k]; l++)
            Argv_com[i][k - 1][l] = Argv_com[i][k][l];
    }

    free(Argv_com[i][nb_lignes[i] - 1]);
    Argc_com[i][nb_lignes[i] - 1] = 0;
    Argv_com[i][nb_lignes[i] - 1] = NULL;
    nb_lignes[i]--;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Insertion of a line in program i, at line j
--------------------------------------------------------------------*/
void
insere_ligne_com(int i, int j, char *h, flow_data *flow_interp)
{
    int             k,
                    l;

    if (nb_lignes[i] >= __nblignes)
        return;
    Argv_com[i][nb_lignes[i]] = (char **) malloc((size_t) (__nbargmax + 2) *
        sizeof(char *));

    for (k = nb_lignes[i]; k > j; k--) {
        ligne_com[i][k] = ligne_com[i][k - 1];
        Argc_com[i][k] = Argc_com[i][k - 1];
        for (l = 0; l < Argc_com[i][k]; l++)
            Argv_com[i][k][l] = Argv_com[i][k - 1][l];
        for (l = Argc_com[i][k]; l < __nbargmax + 2; l++)
            Argv_com[i][k][l] = NULL;
    }

    ligne_com[i][j] = ch_copy(h);
    for (k = 0; k < __nbargmax + 2; k++)
        Argv_com[i][j][k] = NULL;
    extrait_argv_com(i, Argc_com[i] + j, j, Argv_com[i][j], flow_interp);

    nb_lignes[i]++;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Extraction of the arguments of a line in a program
--------------------------------------------------------------------*/
void
extrait_argv_com(int i_com0, int *argc_com, int iw, char *argv_com[],
flow_data *flow_interp)
{
    int             ind,
                    k,
                    l,
                    j,
                    slen0;
    char           *c;

    c = ligne_com[i_com0][iw];
    *argc_com = 0;
    j = -1;
    ind = 0;
    k = -1;
    slen0 = strlen(c);

    while (j < slen0) {
        j++;

        if (j != slen0 && isspace(c[j]) == 0) {
            if (ind == 0) {
                argc_com[0]++;
                k = -1;
                ind = 1;
            }
            if (*argc_com < 2 + __nbargmax)
                flow_interp->HCOM[++k] = c[j];
            else {
                argc_com[0]--;
                break;
            }
        }
        else {
            ind = 0;
            if (*argc_com > 0 && k >= 0) {
                l = *argc_com - 1;
                if (argv_com[l] != NULL)
                    free(argv_com[l]);
                argv_com[l] = (char *) malloc((size_t)(k + 2) * sizeof(char));
                memcpy(argv_com[l], flow_interp->HCOM, k + 1);
                argv_com[l][k + 1] = 0;
            }
        }
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function testing if a command name is already used
--------------------------------------------------------------------*/
int
exist_com(char *nom)
{
    int             i;

    for (i = 0; i <= nb_commandes; i++)
        if (comp(names[i], nom) == 1)
            return 1;
    for (i = 0; i < nb_com; i++)
        if (comp(nom_com[i], nom) == 1)
            return 1;
    return 0;
}
/*------------------------------------------------------------------*/




extern char *_DELPROG_messg[];
/*--------------------------------------------------------------------
    Function associated to the command 'delprog'
--------------------------------------------------------------------*/
int
delprog_cmd(int argc, char *argv[])
{
    int             i,
                    j,
                    k,
                    l;
    flow_data      *flow_interp;

    INIT_FLOW(flow_interp);
    if (num_thread_run > 0) {
        err_mess(40);
        return 1;
    }
    if (flow_interp->num != 0) {
        err_mess(39);
        return 1;
    }
    j = -1;
    for (i = 0; i < nb_com; i++)
        if (comp(nom_com[i], argv[1]) == 1)
            j = i;
    if (j == -1) {
        err_mess(28);
        return 1;
    }
    if (Is_Del_prog[j] == 0) {
        print(flow_interp,
            "%s%s%s\n", _DELPROG_messg[0], nom_com[j], _DELPROG_messg[1]);
        return 1;
    }

    for (i = j; i < nb_com - 1; i++) {
        for (k = 0; k < nb_lignes[i + 1]; k++) {
            if (k < nb_lignes[i]) {
                free(ligne_com[i][k]);
                ligne_com[i][k] = NULL;

                for (l = 0; l < __nbargmax + 2; l++) {
                    if (Argv_com[i][k][l] != NULL)
                        free(Argv_com[i][k][l]);
                }

                free(Argv_com[i][k]);
                if (Is_subst_ligne[i][k] > 0)
                    free(Is_subst_arg[i][k]);
                Is_subst_arg[i][k] = NULL;
            }
            ligne_com[i][k] = ch_copy(ligne_com[i + 1][k]);
            Argc_com[i][k] = Argc_com[i + 1][k];
            Argv_com[i][k] = (char **) malloc((size_t) (__nbargmax + 2) *
                sizeof(char *));
            Is_subst_ligne[i][k] = Is_subst_ligne[i + 1][k];
            if (Is_subst_ligne[i][k] > 0)
                Is_subst_arg[i][k] = (int *) malloc((size_t) Argc_com[i][k] *
                    sizeof(int));
            else
               Is_subst_arg[i][k] = NULL;

            for (l = 0; l < Argc_com[i][k]; l++) {
                Argv_com[i][k][l] = ch_copy(Argv_com[i + 1][k][l]);
                if (Is_subst_ligne[i][k] > 0)
                    Is_subst_arg[i][k][l] = Is_subst_arg[i + 1][k][l];
            }

            for (l = Argc_com[i][k]; l < __nbargmax + 2; l++)
                Argv_com[i][k][l] = NULL;
        }

        for (k = nb_lignes[i + 1]; k < nb_lignes[i]; k++) {
            free(ligne_com[i][k]);
            ligne_com[i][k] = NULL;

            for (l = 0; l < __nbargmax + 2; l++) {
                if (Argv_com[i][k][l] != NULL)
                    free(Argv_com[i][k][l]);
                Argv_com[i][k][l] = NULL;
            }

            free(Argv_com[i][k]);
            if (Is_subst_ligne[i][k] > 0)
                free(Is_subst_arg[i][k]);
            Is_subst_arg[i][k] = NULL;
            Is_subst_ligne[i][k] = 0;
        }

        nb_lignes[i] = nb_lignes[i + 1];
        sil_com[i] = sil_com[i + 1];
        free(nom_com[i]);
        nom_com[i] = ch_copy(nom_com[i + 1]);
        tr_label[i] = tr_label[i + 1];
        nb_label[i] = nb_label[i + 1];
        nb_par[i] = nb_par[i + 1];
        for (k = 0; k < __nmode_fonc; k++)
            mode_com_int[i][k] = mode_com_int[i + 1][k];
        if (num_label[i] != NULL)
            free(num_label[i]);
        if (nb_label[i] > 0)
            num_label[i] = (int *) malloc((size_t) nb_label[i] * sizeof(int));
        else
            num_label[i] = NULL;
        for (k = 0; k < nb_label[i]; k++)
            num_label[i][k] = num_label[i + 1][k];
    }

    nb_com--;

    for (k = 0; k < nb_lignes[nb_com]; k++) {
        free(ligne_com[nb_com][k]);
        ligne_com[nb_com][k] = NULL;

        for (l = 0; l < __nbargmax + 2; l++) {
            if (Argv_com[nb_com][k][l] != NULL)
                free(Argv_com[nb_com][k][l]);
            Argv_com[nb_com][k][l] = NULL;
        }

        free(Argv_com[nb_com][k]);
        if (Is_subst_ligne[nb_com][k] > 0)
            free(Is_subst_arg[nb_com][k]);
        Is_subst_arg[nb_com][k] = NULL;
        Is_subst_ligne[nb_com][k] = 0;
    }

    nb_lignes[nb_com] = 0;
    sil_com[nb_com] = 0;
    par_com[nb_com] = 0;
    free(nom_com[nb_com]);
    nom_com[nb_com] = NULL;
    nb_label[nb_com] = 0;
    if (num_label[nb_com] != NULL)
        free(num_label[nb_com]);
    num_label[nb_com] = NULL;
    for (k = 0; k < __nmode_fonc; k++)
        mode_com_int[nb_com][k] = 0;
    tr_label[nb_com] = 0;
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
FILE *
fmemopen_(void *xg, int nb, char *f, FILE *sw)
{
    char           *c;
    int             i;
    FILE           *s;

    s = tmpfile();
    c = (char *) xg;

    for (i = 0; i < nb; i++) {
        fwrite(&c[i], 1, 1, s);
    if (sw != NULL)
        fwrite(&c[i], 1, 1, sw);
    }

    if (sw != NULL)
        fclose(sw);
    rewind(s);
    return s;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Decodage of an initialisation file
--------------------------------------------------------------------*/
char *
__Xdecode(char K[], int nb, char *inverse)
{
    int             i,
                    j;
    char           *C;

    C = (char *) malloc((size_t) nb * sizeof(char));

    for (i = 0; i < nb; i++) {
        j = (int) K[i];
        if (j < 0)
            j += 256;
        C[i] = inverse[j];
    }

    return C;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
char
__chx(int i)
{
    if (i <= 128)
        return (char) i;
    else
        return (char)(i - 256);
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
void
__perms(char *direct, char *inverse)
{
    int             i,
                    j,
                    j0,
                    n,
                    x[256],
                    e[256];

    for (i = 0; i < 255; i++) {
        x[i] = (i * _P_MULT) % _PRIME_C;
        e[i] = 0;
    }

    for (i = 0; i < 255; i++) {
        n = -1;
        j0 = 0;

        for (j = 0; j < 255; j++) {
            if (e[j] == 0) {
                if (x[j] > n) {
                     j0 = j;
                     n = x[j];
                }
            }
        }

        e[j0] = 1;
        direct[i] = __chx(j0);
        inverse[j0] = __chx(i);
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!include' of an initialization
    file
--------------------------------------------------------------------*/
int
include_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    char            h_ligne[100];
    FILE           *t;

    memset(h_ligne, 0, 100);

    if (fgets_count(h_ligne, 99, s) != NULL) {
        nettoie(h_ligne);
        t = fopen(h_ligne, "r");
        if (t == NULL) {
            exit_interp("include");
            return 1;
        }
        fclose(t);
        charge_com(h_ligne, NULL, 0, 0, flow_interp0, NULL, 0);
    }
    else {
        exit_interp("include");
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!color' of an initialization
    file
--------------------------------------------------------------------*/
int
color_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    char            h_ligne[100];
    int             i;

    memset(h_ligne, 0, 100);

    if (fgets_count(h_ligne, 99, s) != NULL) {
        nettoie(h_ligne);
        i = convert_int(h_ligne, flow_interp);
        if (i >= 0 && i <= 7) {
#ifndef _WIN32
            memset(col_prompt, 0, 20);
            sprintf(col_prompt, "\033[01;%dm", 30 + i);
#endif
        }
    }
    else {
        exit_interp("color");
        return 1;
    }
    if (fgets_count(h_ligne, 99, s) != NULL) {
        nettoie(h_ligne);
        i = convert_int(h_ligne, flow_interp);
        if (i >= 0 && i <= 7) {
#ifndef _WIN32
            memset(col_mess, 0, 20);
            sprintf(col_mess, "\033[01;%dm", 30 + i);
#endif
        }
    }
    else {
        exit_interp("color");
        return 1;
    }
    if (fgets_count(h_ligne, 99, s) != NULL) {
        nettoie(h_ligne);
        i = convert_int(h_ligne, flow_interp);
        if (i >= 0 && i <= 7) {
#ifndef _WIN32
            memset(col_prog, 0, 20);
            sprintf(col_prog, "\033[01;%dm", 30 + i);
#endif
        }
    }
    else {
        exit_interp("color");
        return 1;
    }
    if (fgets_count(h_ligne, 99, s) != NULL) {
        nettoie(h_ligne);
        i = convert_int(h_ligne, flow_interp);
        if (i != 0)
            ind_monfile_color = 1;
    }
    else {
        exit_interp("color");
        return 1;
    }
    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
--------------------------------------------------------------------*/
void
interpcom_dummy(int *n)
{
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function associated to the section '!help' of an initialization
    file
--------------------------------------------------------------------*/
int
help_file_cmd(FILE *s, char *name_c, flow_data *flow_interp)
{
    char            h_ligne[100];
    char            h[400];
    FILE           *t;

    memset(h_ligne, 0, 100);

    while (fgets_count(h_ligne, 99, s) != NULL) {
        if (h_ligne[0] == '.') {
            help_reorder();
            return 0;
        }
        if (h_ligne[0] != ';') {
            nettoie(h_ligne);
            memset(h, 0, 400);
            strcpy(h, data_rep);
            strcat(h, h_ligne);
            t = fopen(h, "r");
            if (t == NULL) {
                exit_interp("help");
                return 1;
            }
            help_add_file(t);
            fclose(t);
        }
    }

    return 0;
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function reading a help file
--------------------------------------------------------------------*/
void
help_add_file(FILE *t)
{
    int             ic,
                    ind,
                    l,
                    l0;
    char            h_ligne[100],
                   *xx;

    ind = 0;
    ic = 0;
    l0 = 0;

    memset(h_ligne, 0, 100);

    while (fgets(h_ligne, 99, t) != NULL) {
        if (h_ligne[0] == ';' && h_ligne[1] != '3') {  /* beginning of a subject */
            nb_help_subj++;
            ic = 1;
            ind = 1;
            if (nb_help_subj >= __nbhelpsubj) {
                exit_interp("help");
                return;
            }
            help_content[nb_help_subj] = (char *) malloc((size_t) 200 *
                sizeof(char));
            memset(help_content[nb_help_subj], 0, 200);
            l0 = 200;
        }
        else {
            if (ic == 1) {
                if (ind == 1) {
                    nettoie(h_ligne);
                    if (h_ligne[0] != 0) {
                        help_name[nb_help_subj] = ch_copy(h_ligne);
                        help_name_length[nb_help_subj] = strlen(
                            help_name[nb_help_subj]);
                    }
                    else {
                        exit_interp("help");
                        return;
                    }
                    ind = 0;
                }
                else {
                    l = strlen(h_ligne) + strlen(help_content[nb_help_subj]);
                    if (l >= l0) {
                        xx = ch_copy(help_content[nb_help_subj]);
                        free(help_content[nb_help_subj]);
                        help_content[nb_help_subj] = (char *) malloc((size_t)
                            (l + 1) * sizeof(char));
                        memset(help_content[nb_help_subj], 0, l + 1);
                        strcpy(help_content[nb_help_subj], xx);
                        free(xx);
                        l0 = l;
                    }
                    strcat(help_content[nb_help_subj], h_ligne);
                }
            }
        }
        memset(h_ligne, 0, 100);
    }
}
/*------------------------------------------------------------------*/




/*--------------------------------------------------------------------
    Function reordering the help subjects
--------------------------------------------------------------------*/
void
help_reorder(void)
{
    int             i,
                    j,
                    k,
                    o;
    char           *xx;

    k = 0;

    for (i = 0; i <= nb_help_subj - 1; i++)
        if (est_avant(help_name[i + 1], help_name[i]) == 1)
            k = 1;

    if (k == 1) {
        for (i = 0; i <= nb_help_subj; i++)
            for (j = i + 1; j <= nb_help_subj; j++)
                if (est_avant(help_name[j], help_name[i]) == 1) {
                    xx = help_name[i];
                    help_name[i] = help_name[j];
                    help_name[j] = xx;
                    xx = help_content[i];
                    help_content[i] = help_content[j];
                    help_content[j] = xx;
                    o = help_name_length[i];
                    help_name_length[i] = help_name_length[j];
                    help_name_length[j] = o;
                }
    }
}
/*------------------------------------------------------------------*/

