/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <Xm/Xm.h>
#include "xdir.h"


static char *help_xdir_overview[] = {
	"LLNL XDIR provides a graphical user interface for file",
	"transfer and for direct manipulation of local and remote",
	"directories on UNIX (and a number of non-UNIX) platforms.",
	" LLNL XDIR offers the ability to view directory",
	"information in four different formats, ranging from long",
	"lists to tree structures.  LLNL XDIR is based on UNIX,",
	"the C programming language, OSF/Motif and FTP; hence,",
	"LLNL XDIR is highly portable.\n",
	"\n",
	"With LLNL XDIR, the user can manage all of his/her files",
	"in a network.  Specifically, LLNL XDIR can be used to",
	"browse directory structures, transfer files and",
	"directories, view local and remote files, delete files",
	"and directories, rename files and directories, and search",
	"directories on one or more hosts for entries matching a",
	"specified pattern.\n",
	"\n",
	"LLNL XDIR uses the familiar folder-icon metaphor to",
	"simultaneously display any number of directories of any",
	"number of (local or remote) hosts, with each directory",
	"being displayed in its own window.  Several existing",
	"products are able to manage files on a single system, but",
	"LLNL XDIR extends this capability to manage files on an",
	"entire network.\n",
	"\n",
	"LLNL XDIR does not have a \"main\" window, as such, but",
	"instead consists of a number of windows, each of which",
	"displays the contents of a local or remote host's",
	"directory.  Each of these \"directory windows\" has a",
	"complete set of controls for setting modes and invoking",
	"operations.  Several other windows are provided for",
	"setting general preferences and displaying diagnostic",
	"information.\n",
	"\n",
	"LLNL XDIR offers elaborate directory-browsing",
	"functionality.  Each directory can be viewed in several",
	"different formats, ranging from long lists to tree",
	"structures.  A number of mechanisms are provided to",
	"traverse directory structures, including: (1)",
	"double-clicking a directory name/icon to enter that",
	"directory, (2) a \"go to parent directory\" button, (3) a",
	"\"go to home directory\" button, and (4) a sophisticated",
	"history mechanism for easily reentering previously",
	"visited directories.\n",
	"\n",
	"LLNL XDIR provides powerful file transfer capability",
	"using drag-and-drop.  For the user, it is just as easy to",
	"copy a file between two remote systems as it is to copy a",
	"file from the local host to itself.  Files and",
	"directories may be transferred either singly or in groups",
	"with just a few movements of the mouse.\n",
	"\n",
	"One of LLNL XDIR's most powerful features is its ability",
	"to search directory structures for entry names matching a",
	"specified pattern.  The user is able to specify the range",
	"and depth of such searches.  The search can be restricted",
	"to a single subdirectory or can extend across machine",
	"boundaries.\n",
	"\n",
	"With LLNL XDIR, the user is able to view local or remote",
	"files, using either the built-in viewer or any",
	"combination of external viewers of the user's choice",
	"(e.g., \"emacs\" or \"xv\").\n",
	"\n",
	"LLNL XDIR's history mechanism make it simple to establish",
	"a connection with a remote host.  This and other features",
	"make it especially painless to connect to an anonymous",
	"FTP site.\n",
	"\n",
	"A number of directory-manipulation features are provided",
	"for operating on selected entries.  There are several",
	"ways to select a group of directory entries to operate",
	"upon, including direct toggling of entries, sweeping out",
	"a rectangular area, and wildcard selection.  Once entries",
	"are selected, the user is able to rename entries, delete",
	"entries (including entire subdirectories), or move",
	"entries between directories within the same host.  The",
	"user is also able to create directories, both on local",
	"and remote hosts.\n",
	"\n",
	"LLNL XDIR utilizes a history mechanism for automatically",
	"saving (1) wildcard expressions used in selecting",
	"directory entries, (2) previously visited directories,",
	"(3) host/user name pairs used in connecting to remote",
	"hosts, and (4) low-level \"quoted\" commands sent to the",
	"host's FTP server.  The purpose of this mechanism",
	"is to reduce the amount",
	"of typing and mouse movement required.  For example, when",
	"the user wishes to apply a wildcard expression to select",
	"directory entries to operate on, a list of recently",
	"referenced wildcard expressions for that host will be",
	"presented to the user; the user can then double-click on",
	"an existing wildcard expression to apply it.  The histories",
	"are automatically preserved across LLNL XDIR sessions.\n",
	"\n",
	"LLNL XDIR presents the user with a graphical user",
	"interface for easily tailoring the program's behavior. ",
	"The user is able to specify such things as whether he/she",
	"would like the delete operation to first pop up a",
	"verification dialog listing the entries to be deleted.\n",
	"\n",
	"Finally, an extensive on-line help facility, much of",
	"which is contextual, is provided.  However, experience",
	"has shown that the user interface is so intuitive that",
	"the user rarely needs to access the help package.\n",
	NULL
};


static char *availability[] = {
	"Source code for LLNL XDIR is tarred and compressed, and is",
	"available as follows:\n",
	"\n",
	"        ftp://coral.ocf.llnl.gov/pub/ia/llnlxdir/latest_xdir.tar.Z\n",
	"\n",
	"        http://www.llnl.gov/ia/xdir.html\n",
	NULL,
};

static char *hidden_features[] = {
	"Here we list some features and ways to perform operations ",
	"that might not be immediately obvious.\n",
	"\n",
	"\n",
	"SELECTING ENTRIES\n",
	"\n",
	"Many operations require that entries in a directory window ",
	"first be selected.   Besides using any of the items in a ",
	"directory window's SELECT menu, you can select/deselect ",
	"entries by (1) single-clicking on an entry (which toggles ",
	"its selection state), (2) holding the left mouse button ",
	"down and dragging to sweep out a selection rectangle ",
	"(which individually toggles each entry's selection state), ",
	"or (3) typing a sequence of characters into the display ",
	"area to select the first entry that most closely matches ",
	"the characters.\n",
	"\n",
	"\n",
	"COPYING FILES AND DIRECTORIES\n",
	"\n",
	"Copy (i.e., transfer) selected entries by using the left ",
	"mouse button to drag the entries.  The drop site of the ",
	"drag can be (1) the background of another directory ",
	"window, or (2) a directory entry in any directory window ",
	"(including the source directory window).  Directories, as ",
	"well as files, can be copied.  LLNL XDIR does not permit ",
	"transfers from a remote host to itself.  The desired file ",
	"transfer mode (\"ASCII\" or \"Binary\") can be specified ",
	"by using the option menu in the toolbar of any directory ",
	"window.\n",
	"\n",
	"\n",
	"MOVING FILES AND DIRECTORIES\n",
	"\n",
	"Move selected entries by using the left mouse button to ",
	"drag the entries, and holding down the control key when ",
	"the mouse button is released over the drop site.  (A move ",
	"differs from a copy operation in that (1) the source entries are ",
	"destroyed, and (2) a move is usually implemented by ",
	"manipulating file system pointers rather than by actually ",
	"copying bits.)  The drop site of the drag may be (1) the ",
	"background of another directory window, or (2) a directory ",
	"entry in any directory window (including the source ",
	"directory window).  LLNL XDIR allows moves only from a ",
	"host to itself.\n",
	"\n",
	"\n",
	"VIEWING A FILE\n",
	"\n",
	"Besides viewing files by selecting the VIEW SELECTED ",
	"ENTRIES item in a directory window's OPS menu, you can ",
	"view a single file by double-clicking on an entry that ",
	"LLNL XDIR knows not to represent a directory.\n",
	"\n",
	"\n",
	"DISPLAYING A DIRECTORY\n",
	"\n",
	"One of the many ways to display a directory is to double-click",
	"on an entry that represents a directory.\n",
	"\n",
	"\n",
	"POP UP LAUNCH MENU\n",
	"\n",
	"Another way to pop up a launch menu (besides using the ",
	"LAUNCH submenu of the OPS menu) is to hold down the ",
	"right mouse button while the cursor is in the display ",
	"area.\n",
	"\n",
	"\n",
	"POP UP \"GO TO ANCESTORS\" MENU\n",
	"\n",
	"Another way to pop up a \"go to ancestors\" menu (besides ",
	"using the ANCESTOR submenu of the GOTO menu) is to ",
	"hold down the right mouse button while the cursor is over ",
	"the \"Up Arrow\" button in the toolbar.\n",
	"\n",
	NULL
};

static char *using_help[] = {
	"Select LLNL XDIR OVERVIEW in the HELP menu for a description",
	"of LLNL XDIR.\n",
	"\n",
	"Select GETTING STARTED in the HELP menu for a brief",
	"discussion on how to use LLNL XDIR.\n",
	"\n",
	"Select CONTEXTUAL HELP in the HELP menu to change the cursor",
	"to a pointing hand.  Move the hand and click on any graphical",
	"element in the directory window you wish to know more about.\n",
	"\n",
	"Many popup dialogs have  help packages that can be accessed",
	"by clicking on their HELP buttons.\n",
	"\n",
	"Select ABOUT LLNL XDIR in the FILE menu for version and author",
	"information.",
	NULL
};

static char *getting_started[] = {
	"When LLNL XDIR is started, a window appears that displays the",
	"contents of a directory on the local host.  This window",
	"is called a \"directory window.\"  You can have any number",
	"of directory windows for any number of hosts.\n",
	"\n",
	"Use the CONNECT menu to connect to a remote host.  Select",
	"CONNECT TO ANONYMOUS to connect to an anonymous FTP site.",
	" Choose CONNECT TO REMOTE to connect to other remote",
	"hosts.  A directory window will be created for the",
	"specified host.\n",
	"\n",
	"You can use a host's directory window to create another",
	"directory window for that host.  First make sure that",
	"tunneling mode is off for that directory window (using",
	"the tunnel icon in the toolbar).  Then, simply change to",
	"another undisplayed directory by using any of the",
	"following techniques: (1) double-click an entry name or",
	"icon that represents a directory, (2) press the \"go to",
	"parent directory\" button (the up-arrow button in the",
	"toolbar), (3) press the \"go to home directory\" button",
	"(the house button in the toolbar), or (4) select an item",
	"in the GOTO menu.  If tunneling mode happens to be on,",
	"the current directory window is used to display the",
	"specified directory.\n",
	"\n",
	"LLNL XDIR has several mechanisms to aid the user in managing a",
	"proliferation of directory windows: (1) directory windows",
	"may be individually iconified (using the window manager),",
	"(2) all iconified LLNL XDIR windows can be redisplayed by",
	"selecting DEICONIFY ALL in the FILE menu, (3) any request",
	"to display a directory that is iconified or buried under",
	"other windows causes it to be brought to the",
	"top, and (4) the WINS menu can be used to identify",
	"existing directory windows and display them on top.\n",
	"\n",
	"Change between different formats for displaying",
	"information within a directory window by toggling the",
	"layout buttons in the directory window's toolbar.\n",
	"\n",
	"Many operations require that entries in a directory window",
	"first be selected.  Select/deselect entries by (1)",
	"single-clicking on an entry (toggles selection state),",
	"(2) holding the left mouse button down and dragging to",
	"sweep out a selection rectangle (toggles selection",
	"states), (3) selecting any of the items in the directory",
	"window's SELECT menu, or (4) typing a sequence of",
	"characters into a directory window to select the first",
	"entry that most closely matches the characters.\n",
	"\n",
	"Copy (i.e., transfer) selected entries by using the left",
	"mouse button to drag the entries.  The drop site of the",
	"drag can be (1) the background of another directory",
	"window, or (2) a directory entry in any directory window",
	"(including the source directory window).  Directories, as",
	"well as files, can be transferred.  LLNL XDIR does not permit",
	"transfers from a remote host to itself.  The desired file",
	"transfer mode can be specified by using the option menu",
	"in the toolbar of any directory window.\n",
	"\n",
	"Move selected entries by using the left mouse button to",
	"drag the entries, and holding down the control key when",
	"the mouse button is released over the drop site.  (A move",
	"differs from a copy in that (1) the source entries",
	"are destroyed, and (2) a move is usually implemented by",
	"manipulating file system pointers rather than by actually",
	"copying bits.)  The drop site of the drag can be (1) the",
	"background of another directory window, or (2) a directory",
	"entry in any directory window (including the source",
	"directory window).  LLNL XDIR only allows moves from a host to",
	"itself.\n",
	"\n",
	"View selected files by selecting VIEW SELECTED ENTRIES in",
	"a directory window's OPS menu.  Also, you may",
	"double-click on an entry that LLNL XDIR knows not to be a",
	"directory.  Configure the viewer by selecting item VIEWER",
	"PREFERENCES in the PREFS menu.  Be sure to first set the",
	"file transfer mode by using the option menu in the",
	"toolbar of any directory window.\n",
	"\n",
	"Delete selected entries by pressing the trash can button",
	"in the toolbar.  Directories, as well as files, may be",
	"deleted.\n",
	"\n",
	"Search for an entry that matches a specified wildcard",
	"expression by selecting SEARCH in the OPS menu.  You are",
	"able to specify the range and depth of the search.  After",
	"a match has been found, you can continue the search by",
	"selecting SEARCH AGAIN in the OPS menu.\n",
	"\n",
	"Other operations on selected entries may be invoked",
	"by selecting appropriate items in the directory window's",
	"OPS menu.\n",
	"\n",
	"Abort in-progress operations by pressing the animated",
	"stop button in the upper-right corner of the affected",
	"directory window (this button is normally labeled \"LLNL",
	"XDIR\").  LLNL XDIR will attempt to return control to you",
	"at the earliest possible moment.\n",
	"\n",
	"Use the cache mode button (the one labeled \"C\" in the toolbar)",
	"to control whether directory lists from remote hosts will",
	"be saved and reused to quickly display revisited directories.\n",
	"\n",
	"Configure LLNL XDIR by selecting the GENERAL PREFERENCES",
	"item in the PREFS menu.",
	NULL
};

static char *help_file_menu[] = {
	"The FILE menu contains the following commands:\n",
	"\n",
	"\n",
	"ABOUT LLNL XDIR\n",
	"\n",
	"Displays information about this version of LLNL XDIR.\n",
	"\n",
	"\n",
	"ICONIFY ALL\n",
	"\n",
	"Changes all the top-level windows in the application into icons.\n",
	"\n",
	"\n",
	"DEICONIFY ALL\n",
	"\n",
	"Changes all the application's icons back into top-level windows.\n",
	"\n",
	"\n",
	"CLOSE\n",
	"\n",
	"Destroys this directory window.  If this directory window is",
	"the last for its host, the host is disconnected.  This is",
	"not an iconify operation.\n",
	"\n",
	"\n",
	"EDIT HISTORY\n",
	"\n",
	"Displays the Edit History dialog.\n",
	"\n",
	"\n",
	"QUIT\n",
	"\n",
	"Terminates LLNL XDIR.",
	NULL
};

static char *help_connect_menu[] = {
	"The CONNECT menu contains the following commands for",
	"connecting/disconnecting local and remote hosts:\n",
	"\n",
	"\n",
	"CONNECT TO LOCAL\n",
	"\n",
	"Connects to the local host (i.e., the host upon which LLNL",
	"XDIR is executing).  If already connected, an existing directory",
	"window for that host is brought to the front.\n",
	"\n",
	"\n",
	"CONNECT TO REMOTE\n",
	"\n",
	"Displays a dialog that allows the user to connect to a",
	"remote host.  If you wish to connect to an anonymous FTP site,",
	"it is better to select CONNECT TO ANONYMOUS, instead.\n",
	"\n",
	"\n",
	"CONNECT TO ANONYMOUS\n",
	"\n",
	"Displays a dialog that enables the user to easily connect to a",
	"remote FTP site.\n",
	"\n",
	"\n",
	"DISCONNECT\n",
	"\n",
	"Terminates the connection to the host associated with this",
	"directory window.  All directory windows associated with this",
	"host are closed.\n",
	NULL
};

static char *help_select_menu[] = {
	"The SELECT menu contains the following commands for",
	"selecting/deselecting entries in this directory window:\n",
	"\n",
	"\n",
	"SELECT ALL ENTRIES\n",
	"\n",
	"Selects all entries in this directory window.\n",
	"\n",
	"\n",
	"DESELECT ALL ENTRIES\n",
	"\n",
	"Deselects all entries in this directory window.\n",
	"\n",
	"\n",
	"USE WILDCARD\n",
	"\n",
	"Pops up a dialog that prompts for a wildcard expression to use",
	"in selecting entries in this directory window.",
	NULL
};

static char *help_ops_menu[] = {
	"The OPS menu contains the following commands:\n",
	"\n",
	"\n",
	"SEARCH\n",
	"\n",
	"Pops up a dialog to initiate a search of directory windows",
	"for entry names that match a specified pattern.\n",
	"\n",
	"\n",
	"SEARCH AGAIN\n",
	"\n",
	"Searches for the next entry that satifies the search criteria",
	"specified by the last search command.\n",
	"\n",
	"\n",
	"DELETE SELECTED ENTRIES\n",
	"\n",
	"Deletes the selected entries.  Set general preference",
	"DELETE MODE to RECURSIVE to allow deletion of nonempty",
	"directories.  A dialog pops up to enable you to monitor",
	"the progress of the deletions.  This dialog contains a button",
	"for aborting the delete operation.\n",
	"\n",
	"WARNING: Exercise extreme caution when using this command",
	"because, if recursion is enabled, you can delete entire directory",
	"subtrees.\n",
	"\n",
	"\n",
	"RENAME SELECTED ENTRIES\n",
	"\n",
	"Pops up a dialog to individually rename selected entries.  This is",
	"similar to the UNIX \"mv\" command (except that the renamed entries",
	"cannot be moved to another directory).\n",
	"\n",
	"\n",
	"VIEW SELECTED ENTRIES\n",
	"\n",
	"Displays the selected files.  The \"Viewer Preferences\"",
	"dialog (accessible via the PREFS menu) can be used to",
	"control whether a particular file will be displayed using",
	"the built-in viewer or using an external viewer of your",
	"choice (e.g., \"emacs\" or \"xv\").  The selection of the viewer",
	"is configurable, based on the file extension (e.g.,",
	"\".gif\" or \".jpg\").  This is no limit on the number or",
	"types of viewers that can be simultaneously displayed.\n",
	"\n",
	"The file is transferred according to the mode (ASCII or",
	"Binary) specified in the directory window's toolbar.  A",
	"dialog pops up to enable you to monitor the progress of",
	"the transfers.  The dialog contains a button for aborting",
	"the transfers.\n",
	"\n",
	"The destination of the transfers is a temporary directory",
	"created in the directory defined as \"P_tmpdir\" in the",
	"include file \"/usr/include/stdio.h\".  If the environment",
	"variable TMPDIR is defined, it is used to determine the",
	"directory.  The temporary directory, and the files it",
	"contains, are automatically deleted when you dismiss the",
	"viewer or terminate LLNL XDIR.\n",
	"\n",
	"If a file to be viewed is recognized as being compressed,",
	"it is expanded before viewing.  LLNL XDIR executed the",
	"following decompressors based on the file extension:",
	"\"gunzip\" for \".z\" and \".gz\"; \"uncompress\"",
	"for \".Z\"; \"atob\" for",
	"\".atob\"; and \"uudecode\" for \".uu\".  LLNL XDIR searches for",
	"the decompressor application in the standard way using",
	"the PATH environment variable.\n",
	"\n",
	"\n",
	"SEND QUOTED COMMAND\n",
	"\n",
	"Pops up a dialog to prompt for a \"raw\" command to send to the",
	"FTP server of the remote host.\n",
	"\n",
	"\n",
	"REFRESH DIRECTORY\n",
	"\n",
	"Redisplay this window's directory.\n",
	"\n",
	"\n",
	"MAKE DIRECTORY\n",
	"\n",
	"Props up a dialog that prompts for the name of a directory to",
	"create in the currently displayed directory.\n",
	"\n",
	"\n",
	"LAUNCH\n",
	"\n",
	"Launch application as a child process.  Press HELP button in",
	"Launcher Preferences window (via the PREFS menu) for more",
	"information.",
	NULL
};

static char *help_goto_menu[] = {
	"The GOTO menu contains the following items:\n",
	"\n",
	"\n",
	"ANCESTOR\n",
	"\n",
	"This pullright menu contains the paths for each ancestor of this",
	"directory window.  Select a path to display that directory.\n",
	"\n",
	"\n",
	"DIRECTORY\n",
	"\n",
	"Displays an arbitrary directory.  A dialog pops up to prompt for",
	"the directory path.\n",
	"\n",
	"\n",
	"HOME DIRECTORY\n",
	"\n",
	"Displays the home directory of this directory window's host.\n",
	"\n",
	"\n",
	"PARENT DIRECTORY\n",
	"\n",
	"Displays the parent directory of this directory window.\n",
	"\n",
	"\n",
	"The remaining items are names of directories on this host that",
	"were previously displayed (perhaps in earlier LLNL XDIR",
	"sessions).  Choose one of these items to display that directory.",
	NULL
};

static char *help_prefs_menu[] = {
	"The PREFS menu contains the following items:\n",
	"\n",
	"\n",
	"GENERAL PREFERENCES\n",
	"\n",
	"Displays the General Preferences window.\n",
	"\n",
	"\n",
	"LAUNCHER PREFERENCES\n",
	"\n",
	"Displays the Launcher Preferences window.\n",
	"\n",
	"\n",
	"VIEWER PREFERENCES\n",
	"\n",
	"Displays the Viewer Preferences window.\n",
	"\n",
	"\n",
	"SAVE PREFERENCES\n",
	"\n",
	"Saves the current settings of the general, launcher and viewer\n",
	"preferences.",
	NULL
};

static char *help_wins_menu[] = {
	"The WINS menu contains the following items:\n",
	"\n",
	"\n",
	"DIAGNOSTICS\n",
	"\n",
	"Displays the diagnostics window.\n",
	"\n",
	"\n",
	"VIEWED FILES\n",
	"\n",
	"This pullright menu contains an item for each file currently",
	"being viewed using the built-in viewer.  Choose an item to cause",
	"the associated viewer window to be brought to the front.\n",
	"\n",
	"\n",
	"The remaining items are pullright menus containing active directory",
	"windows for each connected host.  Choose an item to cause the",
	"associated directory window to be brought to the front.",
	NULL
};

static char *help_ur_button[] = {
	"When this button is labeled \"LLNL XDIR\", pressing it displays",
	"information about this version of the program.\n",
	"\n",
	"During most lengthy operations, this button changes into an animated",
	"stop button.  If the stop button is pressed, LLNL XDIR begins to abort",
	"the current operation.  Although LLNL XDIR will attempt to return",
	"control to you at the earliest possible moment, the abort operation",
	"can take some time if LLNL XDIR has to exchange messages with one",
	"or more noncommunicative remote hosts.",
	NULL
};

static char *help_close_button[] = {
	"Press this button to destroy this directory window.",
	NULL
};

static char *help_delete_button[] = {
	"Press this button to delete the selected entries.",
	NULL
};

static char *help_mkdir_button[] = {
	"Press this button to pop up a dialog that prompts for the name",
	"of a directory to create in the directory being displayed.",
	NULL
};

static char *help_home_button[] = {
	"Press this button to display the home directory of this",
	"directory window's host.",
	NULL
};

static char *help_parent_button[] = {
	"Press this button to display this window's parent directory.\n",
	"\n",
	"Also, pressing the right mouse button pops up a menu",
	"that contains the paths for each ancestor of this",
	"directory window.  Select a path to display that directory.",
	NULL
};

static char *help_refresh_button[] = {
	"Press this button to refresh this directory window (a new",
	"directory listing is obtained from the host).",
	NULL
};

static char *help_dot_files_button[] = {
	"Press this button to toggle this directory window's \"dot files\"",
	"mode.  If dot files mode is on, then entry names that begin with a",
	"period will be displayed.",
	NULL
};

static char *help_tunneling_button[] = {
	"Press this button to toggle this directory window's \"tunneling\"",
	"mode.  If tunneling is off and you invoke a command from this",
	"window to view a directory that is not already displayed, then",
	"a new window will be created to display that directory.  If",
	"tunneling is on and you invoke a command from this window to",
	"view a directory that is not already displayed, then the",
	"directory will be displayed in this window.",
	NULL
};

static char *help_cache_button[] = {
	"Press this button to toggle this directory window's \"cache\"",
	"mode.  If cache mode is on, then directory lists from remote",
	"hosts will be saved and reused to quickly display revisited",
	"directories.\n",
	"\n",
	"The cache mode has no effect on the action of the refresh",
	"button, so clicking on the refresh button is a convenient way",
	"of temporarily bypassing the cache without leaving cache mode.\n",
	"\n",
	"The cache will be bypassed when LLNL XDIR automatically updates",
	"affected directory windows after certain operations that",
	"change their contents (e.g., copies, renames, deletes, etc.).\n",
	"\n",
	"See General Preferences INITIAL CACHE MODE and MAX DIR CACHE LEN",
	"(KB) to configure the directory cache.",
	NULL
};

static char *help_full_info_button[] = {
	"Press this button to place this directory window into",
	"\"Full Info Layout\" mode, in which as much information as",
	"possible is displayed (the amount of information available",
	"is controlled by the host's FTP server).",
	NULL
};

static char *help_tree_button[] = {
	"Press this button to place this directory window into",
	"\"Tree Layout\" mode, which is similar to Iconic Layout mode",
	"except that each entry that is a directory also has a small",
	"triangle-shaped button that can be used to expand and",
	"collapse the subdirectory.  An icon and name are displayed",
	"for each entry.  Five different icons are used to identify",
	"the entry type: directory, executable file, generic",
	"file, socket and link.",
	NULL
};

static char *help_iconic_button[] = {
	"Press this button to place this directory window into",
	"\"Iconic Layout\" mode, in which an icon and name are displayed",
	"for each entry.  In this mode, five different icons are used to",
	"identify the entry type:  directory, executable file, generic",
	"file, socket and link.",
	NULL
};

static char *help_tabular_button[] = {
	"Press this button to place this directory window into",
	"\"Tabular Layout\" mode, in which only entry names are",
	"displayed.",
	NULL
};

static char *help_xfer_mode_menu[] = {
	"This option menu allows you to choose the file transfer mode",
	"(ASCII or Binary).  This mode is global in scope; hence, changing",
	"the value in one directory window will automatically change all",
	"directory windows.",
	NULL
};

static char *help_display_area[] = {
	"This area is where directory entries are displayed.\n",
	"\n",
	"Change between different formats for displaying",
	"entries by toggling the",
	"layout buttons in the directory window's toolbar.\n",
	"\n",
	"Select/deselect entries by (1) single-clicking on an",
	"entry (toggles selection states), (2) holding the left",
	"mouse button down and dragging to sweep out a selection",
	"rectangle (toggles selection state), (3) selecting any of",
	"the items in the SELECT menu, or (4) typing a sequence of",
	"characters to select the first entry that most closely",
	"matches the characters.\n",
	"\n",
	"Copy (i.e., transfer) selected entries by using the left",
	"mouse button to drag the entries.  The drop site of the",
	"drag can be (1) the background of another directory",
	"window, or (2) a directory entry in any directory window",
	"(including this one).  Directories, as well as files, can",
	"be transferred.  LLNL XDIR does not permit transfers from a",
	"remote host to itself.  The desired file transfer mode",
	"can be specified by using the option menu in the toolbar",
	"of any directory window.\n",
	"\n",
	"Move selected entries by using the left mouse button to",
	"drag the entries , and holding down the control key when",
	"the mouse button is released over the drop site.  (Move",
	"differs from Copy in that (1) the source entries",
	"are destroyed, and (2) a move is usually implemented by",
	"manipulating file system pointers rather than by actually",
	"copying bits.)  The drop site of the drag can be (1) the",
	"background of another directory window, or (2) a directory",
	"entry in any directory window (including this one).  LLNL XDIR",
	"only allows moves from a host to itself.\n",
	"\n",
	"Double-clicking an entry has the following effect:  If",
	"the entry is known to be a directory, an attempt is made",
	"to display the directory; otherwise, the entry is assumed",
	"to be a file, and a viewer is invoked to attempt to",
	"display the file.",
	NULL
};

/*
 * cb_help_file_menu - Callback to display help message for "File" menu.
 */
void
cb_help_file_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "File Menu", help_file_menu);
}


/*
 * cb_help_connect_menu - Callback to display help message for "Connect" menu.
 */
void
cb_help_connect_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Connect Menu", help_connect_menu);
}


/*
 * cb_help_select_menu - Callback to display help message for "Select" menu.
 */
void
cb_help_select_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Select Menu", help_select_menu);
}


/*
 * cb_help_ops_menu - Callback to display help message for "Ops" menus.
 */
void
cb_help_ops_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Ops Menu", help_ops_menu);
}


/*
 * cb_help_goto_menu - Callback to display help message for "Goto" menus.
 */
void
cb_help_goto_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Goto Menu", help_goto_menu);
}


/*
 * cb_help_prefs_menu - Callback to display help message for "Prefs" menu.
 */
void
cb_help_prefs_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Prefs Menu", help_prefs_menu);
}


/*
 * cb_help_wins_menu - Callback to display help message for "Wins" menus.
 */
void
cb_help_wins_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Wins Menu", help_wins_menu);
}


/*
 * cb_xdir_overview - Callback to display help message that gives overview
 *                    of Xdir.
 */
void
cb_xdir_overview(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "LLNL XDIR Overview",
		help_xdir_overview);
}


/*
 * cb_getting_started - Callback to display "Getting Started" help message.
 */
void
cb_getting_started(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Getting Started", getting_started);
}


/*
 * cb_using_help - Callback to display help message describing how to use
 *                 the online help facility.
 */
void
cb_using_help(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Using Help", using_help);
}


/*
 * cb_help_close_button - Callback to display help message for close
 *                        button.
 */
void
cb_help_close_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Close Directory Window Button",
		help_close_button);
}


/*
 * cb_help_delete_button - Callback to display help message for delete
 *                         button.
 */
void
cb_help_delete_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Delete Selected Entries Button",
		help_delete_button);
}


/*
 * cb_help_mkdir_button - Callback to display help message for make
 *                        directory button.
 */
void
cb_help_mkdir_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Make Directory Button",
		help_mkdir_button);
}


/*
 * cb_help_home_button - Callback to display help message for goto home
 *                       button.
 */
void
cb_help_home_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Go to Home Directory Button",
		help_home_button);
}


/*
 * cb_help_parent_button - Callback to display help message for goto
 *                         parent directory button.
 */
void
cb_help_parent_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Go to Parent Directory Button",
		help_parent_button);
}


/*
 * cb_help_refresh_button - Callback to display help message for refresh
 *                          directory button.
 */
void
cb_help_refresh_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Refresh Directory Button",
		help_refresh_button);
}


/*
 * cb_help_dot_files_button - Callback to display help message for toggle
 *                            dot files mode button.
 */
void
cb_help_dot_files_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Dot Files Mode Button",
		help_dot_files_button);
}


/*
 * cb_help_tunneling_button - Callback to display help message for
 *                            tunneling mode button.
 */
void
cb_help_tunneling_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Tunneling Mode Button",
		help_tunneling_button);
}


/*
 * cb_help_cache_button - Callback to display help message for cache
 *                        mode button.
 */
void
cb_help_cache_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Cache Mode Button", help_cache_button);
}


/*
 * cb_help_full_info_button - Callback to display help message for
 *                            full information layout button.
 */
void
cb_help_full_info_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Full Info Mode Layout Button",
		help_full_info_button);
}


/*
 * cb_help_tree_button - Callback to display help message for tree
 *                       layout button.
 */
void
cb_help_tree_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Tree Layout Mode Button",
		help_tree_button);
}


/*
 * cb_help_iconic_button - Callback to display help message for iconic
 *                         layout.
 */
void
cb_help_iconic_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Iconic Layout Mode Button",
		help_iconic_button);
}


/*
 * cb_help_tabular_button - Callback to display help message for tabular
 *                          layout.
 */
void
cb_help_tabular_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Tabular Layout Mode Button",
		help_tabular_button);
}


/*
 * cb_help_xfer_mode_menu - Callback to display help message for
 *                            file transfer mode option menu.
 */
void
cb_help_xfer_mode_menu(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "File Transfer Mode Menu",
		help_xfer_mode_menu);
}


/*
 * cb_help_display_area - Callback to display help message for the
 *                        directory display area.
 */
void
cb_help_display_area(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Display Area", help_display_area);
}


/*
 * cb_help_ur_button - Callback to display help message for the upper-right
 *                     button.
 */
void
cb_help_ur_button(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "LLNL XDIR / Stop Button",
		help_ur_button);
}


/*
 * cb_hidden_features - Callback to display "Hidden Features" help message.
 */
void
cb_hidden_features(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Hidden Features", hidden_features);
}


/*
 * cb_availability - Callback to display availability help message.
 */
void
cb_availability(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	struct dirwin_st *dirwin = (struct dirwin_st *)client_data;

	help_dialog(dirwin->w_shell, False, "Availability", availability);
}

