/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <Xm/Xm.h>
#include "logo50.h"
#include "logo64.h"

struct {
	unsigned char *data;
	int width;
	int height;
} icon_image[] = {
	{ &logo64_bits[0], 64, 64 },
	{ &logo50_bits[0], 50, 50 }
};

static Pixmap wm_icon_pixmap;
static int icon_created = False;

extern Widget w_toplev;
extern Display *display;
extern int depth;
extern Window root_window;


/*
 * create_wm_icon - Create custom icon for use with Mwm.  This routine will
 *                  try to create either a 50x50 icon or a 64x64 icon,
 *                  depending on what size the window manager prefers.
 */
create_wm_icon()
{
    XIconSize *list;
    int count;
    Status status;
    int i;
    int j;
    int width;
    int height;

    /* Only create custom icon if window manager is MWM */
    if (!XmIsMotifWMRunning(w_toplev))
        return;

    /* Get window manager's list of preferred icon sizes */
    status = XGetIconSizes(display, root_window, &list, &count);
    if (status == 0)
        return;

    /* See if we can handle one of the preferred sizes */
    for (i=0; i<XtNumber(icon_image); i++)
        for (j=0; j<count; j++) {
            width = icon_image[i].width;
            height = icon_image[i].height;
            if (width >= list[j].min_width &&
                width <= list[j].max_width &&
                (width-list[j].min_width)%list[j].width_inc == 0 &&
                height >= list[j].min_height &&
                height <= list[j].max_height &&
                (height-list[j].min_height)%list[j].height_inc == 0) {
				wm_icon_pixmap = XCreatePixmapFromBitmapData(
			        display,
			        root_window,
			        (char *)icon_image[i].data,
			        icon_image[i].width,
			        icon_image[i].height,
			        BlackPixelOfScreen(XtScreen(w_toplev)),
			        WhitePixelOfScreen(XtScreen(w_toplev)),
			        depth
			    );
                XFree((caddr_t)list);
				icon_created = True;
                return;
            }
        }

    XFree((caddr_t)list);
}


/*
 * attach_wm_icon - Associate the custom Xdir icon to the specified shell
 *                  widget for use by the window manager.  If the window
 *                  manager is not mwm, the association is not made.
 */
attach_wm_icon(w_shell)
Widget w_shell;
{
	/* Sanity check */
	if (!XtIsShell(w_shell))
		fatal_error("Bug in attach_wm_icon()");

    /* Only attach custom icon if window manager is MWM */
    if (XmIsMotifWMRunning(w_toplev) || icon_created)
		XtVaSetValues(w_shell, XmNiconPixmap, wm_icon_pixmap, NULL);
}

