/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include <Xm/Xm.h>
#include "xdir.h"
#include "entries.h"
#include "treectrls.h"
#include "resources.h"

GC gcv1;
GC gcv2;
GC gcf1;
GC gcf2;
GC gc_rect;
GC gc_move;
Pixmap exec12_pixmap;
Pixmap file12_pixmap;
Pixmap folder12_pixmap;
Pixmap link12_pixmap;
Pixmap socket12_pixmap;
Pixmap unknown12_pixmap;
Pixmap exec12_inv_pixmap;
Pixmap file12_inv_pixmap;
Pixmap folder12_inv_pixmap;
Pixmap link12_inv_pixmap;
Pixmap socket12_inv_pixmap;
Pixmap unknown12_inv_pixmap;
Pixmap hidedir12_pixmap;
Pixmap viewdir12_pixmap;

extern Widget w_toplev;
extern Display *display;
extern Window root_window;
extern int depth;
extern AppData app_data;


initialize_graphics(dirwin)
struct dirwin_st *dirwin;
{
	static char dash[] = { 3, 3 };
	Pixel fg;
	Pixel bg;

    /* Get foreground and background colors of drawing area */
    XtVaGetValues(
        dirwin->w_drawingArea,
        XmNbackground,  &bg,
        XmNforeground,  &fg,
        NULL
    );

    /* Create first Graphics Context displaying entries (variable width) */
    gcv1 = XCreateGC(display, XtWindow(w_toplev), (unsigned long)0, NULL);
    XSetForeground(display, gcv1, fg);
    XSetBackground(display, gcv1, bg);
	XSetFont(display, gcv1, app_data.variable_width_layout_font->fid);
   
    /* Create second Graphics Context displaying entries (variable width) */
    gcv2 = XCreateGC(display, XtWindow(w_toplev), (unsigned long)0, NULL);
    XSetForeground(display, gcv2, bg);
    XSetBackground(display, gcv2, fg);
    XSetFont(display, gcv2, app_data.variable_width_layout_font->fid);

    /* Create first Graphics Context displaying entries (fixed width) */
    gcf1 = XCreateGC(display, XtWindow(w_toplev), (unsigned long)0, NULL);
    XSetForeground(display, gcf1, fg);
    XSetBackground(display, gcf1, bg);
	XSetFont(display, gcf1, app_data.fixed_width_layout_font->fid);
   
    /* Create second Graphics Context displaying entries (fixed width) */
    gcf2 = XCreateGC(display, XtWindow(w_toplev), (unsigned long)0, NULL);
    XSetForeground(display, gcf2, bg);
    XSetBackground(display, gcf2, fg);
    XSetFont(display, gcf2, app_data.fixed_width_layout_font->fid);

    /* Create Graphics Context for toggle rectangle */
    gc_rect = XCreateGC(display, XtWindow(w_toplev), (unsigned long)0, NULL);
    XSetForeground(display, gc_rect, fg);
    XSetBackground(display, gc_rect, bg);
	XSetFunction(display, gc_rect, GXinvert);
	XSetPlaneMask(display, gc_rect, BlackPixelOfScreen(XtScreen(w_toplev))
		^WhitePixelOfScreen(XtScreen(w_toplev)));
	XSetLineAttributes(display, gc_rect, 0, LineOnOffDash, CapButt, JoinMiter);
	XSetDashes(display, gc_rect, 0, dash, 2);

	/* Create Graphics Context for move outline rectangles */
	gc_move = XCreateGC(display, XDefaultRootWindow(display),
		(unsigned long)0, NULL);
    XSetForeground(display, gc_move, fg);
    XSetBackground(display, gc_move, bg);
	XSetFunction(display, gc_move, GXinvert);
	XSetPlaneMask(display, gc_move, BlackPixelOfScreen(XtScreen(w_toplev))
		^WhitePixelOfScreen(XtScreen(w_toplev)));
	XSetLineAttributes(display, gc_move, 0, LineOnOffDash, CapButt, JoinMiter);
	XSetSubwindowMode(display, gc_move, IncludeInferiors);
	XSetDashes(display, gc_move, 0, dash, 2);

	/* Create icons for hierarchical viewing */
    hidedir12_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)hidedir12_bits, hidedir12_width, hidedir12_height, fg, bg,
		depth);
    viewdir12_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)viewdir12_bits, viewdir12_width, viewdir12_height, fg, bg,
		depth);

	/* Create icons for unselected directory entries */
    exec12_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)exec12_bits, exec12_width, exec12_height, fg, bg, depth);
    file12_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)file12_bits, file12_width, file12_height, fg, bg, depth);
    folder12_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)folder12_bits, folder12_width, folder12_height, fg, bg, depth);
    link12_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)link12_bits, link12_width, link12_height, fg, bg, depth);
    socket12_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)socket12_bits, socket12_width, socket12_height, fg, bg, depth);
	unknown12_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)unknown12_bits, unknown12_width, unknown12_height, fg, bg,
		depth);

	/* Create icons for selected directory entries */
    exec12_inv_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)exec12_bits, exec12_width, exec12_height, bg, fg, depth);
    file12_inv_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)file12_bits, file12_width, file12_height, bg, fg, depth);
    folder12_inv_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)folder12_bits, folder12_width, folder12_height, bg, fg, depth);
    link12_inv_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)link12_bits, link12_width, link12_height, bg, fg, depth);
    socket12_inv_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)socket12_bits, socket12_width, socket12_height, bg, fg, depth);
	unknown12_inv_pixmap = XCreatePixmapFromBitmapData(display, root_window,
		(char *)unknown12_bits, unknown12_width, unknown12_height, bg, fg,
		depth);
}

