/***************************************************************************/
/***************************************************************************/
/*                                                                         */
/*   (c) 1995.  The Regents of the University of California.  All rights   */
/*   reserved.                                                             */
/*                                                                         */
/*   This work was produced at the University of California, Lawrence      */
/*   Livermore National Laboratory (UC LLNL) under contract no.            */
/*   W-7405-ENG-48 (Contract 48) between the U.S. Department of Energy     */
/*   (DOE) and The Regents of the University of California (University)    */
/*   for the operation of UC LLNL.  Copyright is reserved to the           */
/*   University for purposes of controlled dissemination,                  */
/*   commercialization through formal licensing, or other disposition      */
/*   under terms of Contract 48; DOE policies, regulations and orders;     */
/*   and U.S. statutes.  The rights of the Federal Government are          */
/*   reserved under Contract 48 subject to the restrictions agreed upon    */
/*   by the DOE and University.                                            */
/*                                                                         */
/*                                                                         */
/*                              DISCLAIMER                                 */
/*                                                                         */
/*   This software was prepared as an account of work sponsored by an      */
/*   agency of the United States Government.  Neither the United States    */
/*   Government nor the University of California nor any of their          */
/*   employees, makes any warranty, express or implied, or assumes any     */
/*   liability or responsibility for the accuracy, completeness, or        */
/*   usefulness of any information, apparatus, product, or process         */
/*   disclosed, or represents that its specific commercial products,       */
/*   process, or service by trade name, trademark, manufacturer, or        */
/*   otherwise, does not necessarily constitute or imply its               */
/*   endorsement, recommendation, or favoring by the United States         */
/*   Government or the University of California. The views and opinions    */
/*   of the authors expressed herein do not necessarily state or reflect   */
/*   those of the United States Government or the University of            */
/*   California, and shall not be used for advertising or product          */
/*   endorsement purposes.                                                 */
/*                                                                         */
/*   Permission to use, copy, modify and distribute this software and its  */
/*   documentation for any non-commercial purpose, without fee, is         */
/*   hereby granted, provided that the above copyright notice and this     */
/*   permission notice appear in all copies of the software and            */
/*   supporting documentation, and that all UC LLNL identification in      */
/*   the user interface remain unchanged.  The title to copyright LLNL     */
/*   XDIR shall at all times remain with The Regents of the University     */
/*   of California and users agree to preserve same. Users seeking the     */
/*   right to make derivative works with LLNL XDIR for commercial          */
/*   purposes may obtain a license from the Lawrence Livermore National    */
/*   Laboratory's Technology Transfer Office, P.O. Box 808, L-795,         */
/*   Livermore, CA 94550.                                                  */
/*                                                                         */
/***************************************************************************/
/***************************************************************************/

#include "gprefs.h"

char *help_anonymous_ftp_password[] = {
	"The value to initialize the \"Password\" field of the \"Connect",
	"to Anonymous\" dialog to.  This is normally your email address.  If",
	"the value is blank, LLNL XDIR attemps to construct a password of",
	"the form \"user@host\".  The \"Connect to Anonymous\" dialog is",
	"accessible via each directory window's \"Connect\" menu.",
	NULL
};

char *help_beep_when_ops_done[] = {
	"Specifies whether to beep when each set of deletion, move,",
	"quoted command, search,  and file transfer operations completes.",
	NULL
};

char *help_copy_mode[] = {
	"Specifies whether to  allow recursive file transfers.",
	NULL
};

char *help_delete_mode[] = {
	"Specifies whether to  allow recursive deletions.",
	NULL
};

char *help_initial_cache_mode[] = {
	"Specifies whether the first created directory window will",
	"have \"cache\" mode turned off or on.  Each",
	"subsequently created directory window inherits its cache",
	"mode from its parent directory window.",
	NULL
};

char *help_initial_diagnostics[] = {
	"Specifies the initial level of diagnostics information to be written",
	"to the diagnostics window.  Choose QUIET for error messages,",
	"only.  Choose NORMAL for error messages and success messages.  ",
	"Choose VERBOSE for error messages, success messages, and replies",
	"received from the FTP servers.  Choose DEBUG for error",
	"messages, replies received from the FTP servers,  commands",
	"sent to the FTP servers, and other assorted diagnostics.",
	NULL
};

char *help_initial_dir_layout[] = {
	"The layout used by the first created directory window.  Each",
	"subsequently created directory window inherits its directory",
	"layout mode from its parent directory window.",
	NULL
};

char *help_initial_dotfiles_mode[] = {
	"Specifies whether the first created directory window will",
	"display \"dot\" files.  Each",
	"subsequently created directory window inherits its dot files",
	"mode from its parent directory window.",
	NULL
};

char *help_initial_max_viewer_width[] = {
	"The maximum initial width in characters that the built-in viewer",
	"takes on.  The first part of the file to be viewed is examined",
	"to determine an appropriate width to initialize the viewer to.  The",
	"initial width will not exceed the value of this preference.",
	NULL
};

char *help_initial_search_depth[] = {
	"The default maiximum number of directory levels the search",
	"command will explore when looking for an entry that matches",
	"the specified pattern.",
	NULL
};

char *help_initial_search_direction[] = {
	"The default value that specifies the direction to search the",
	"built-in file viewer for a text string using the \"Find\"",
	"operation.",
	NULL
};

char *help_initial_search_case_match[] = {
	"The default value that specifies whether search or find commands",
	"should consider case when looking for an entry that matches",
	"the specified pattern.",
	NULL
};

char *help_initial_search_range[] = {
	"The default value of the search range in the \"Search\" dialog.  ",
	"Choose \"THIS DIR\" to make \"SEARCH THIS DIRECTORY\" ",
	"the default.  Choose \"THIS HOST\" to make the \"SEARCH ALL OPEN ",
	"DIRECTORIES FOR THIS HOST\" the default.  Choose \"ALL HOSTS\" ",
	"to make the \"SEARCH ALL OPEN DIRECTORIES FOR ALL HOSTS\" ",
	"the default.",
	NULL
};

char *help_initial_transfer_mode[] = {
	"The default file transfer mode (ASCII or BINARY).",
	NULL
};

char *help_initial_tunneling_mode[] = {
	"Specifies whether the first created directory window will",
	"have \"tunneling\" mode turned off or on.  Each",
	"subsequently created directory window inherits its tunneling",
	"mode from its parent directory window.",
	NULL
};

char *help_initial_wildcard_mode[] = {
	"The default mode of the \"Use Wildcard\" dialog.  Choose",
	"REPLACE to make \"Replace Selection\" the default.  ",
	"Choose ADD to make \"Add to Selection\" the default.",
	NULL
};

char *help_inquire_on_copy[] = {
	"Specifies whether to pop up a dialog that asks the user to",
	"confirm that the indicated file transfers should take place.",
	NULL
};

char *help_inquire_on_delete[] = {
	"Specifies whether to pop up a dialog that asks the user to",
	"confirm that the indicated deletions should take place.",
	NULL
};

char *help_inquire_on_move[] = {
	"Specifies whether to pop up a dialog that asks the user to",
	"confirm that the indicated moves should take place.",
	NULL
};

char *help_inquire_on_quoted_cmd[] = {
	"Specifies whether to pop up a dialog that asks the user to",
	"confirm that the indicated commands should be sent.",
	NULL
};

char *help_max_dir_cache_len[] = {
	"Specifies the maximum number of kilobytes of memory allocated",
	"for the purpose of caching the contents of previously listed",
	"directories.",
	NULL
};

char *help_max_dir_name_history[] = {
	"The maximum number of previously referenced directory paths",
	"saved per host.  These path names are preserved across LLNL XDIR",
	"sessions.",
	NULL
};

char *help_max_ftp_retries[] = {
	"Specifies the maximum number of retries LLNL XDIR will attempt",
	"if it receives a response from an FTP server that indicates",
	"the desired operation failed because of some temporary",
	"condition on the remote host.",
	NULL
};

char *help_max_host_name_history[] = {
	"The maximum number of hosts to save history items for.  The",
	"history information is preserved across LLNL XDIR sessions.",
	NULL
};

char *help_max_quoted_cmd_history[] = {
	"The number of quoted commands to save.  These commands are preserved",
	"across LLNL XDIR sessions.",
	NULL
};

char *help_max_time_for_ftp_reply[] = {
	"Specifies the maximum time in seconds that LLNL XDIR will wait",
	"for a response from an FTP server before concluding that the",
	"connection has been broken.",
	NULL
};

char *help_max_user_name_history[] = {
	"The number of user names to save (for remote hosts).  These",
	"user names are preserved across LLNL XDIR sessions.",
	NULL
};

char *help_overwrite_dir_on_copy[] = {
	"Specifies whether it is okay to overwrite an existing directory",
	"when recursively copying another directory by the same name.  If a sink",
	"directory is overwritten then none of its subdirectories will be",
	"deleted, but new files and subdirectories might be added to it,",
	"and some existing files might be replaced.",
	NULL
};

char *help_preserve_vms_ver_nums[] = {
	"Specifies whether to preserve VMS file version numbers when",
	"transferring files from a VMS system.  This is only an issue",
	"for those VMS FTP servers that provide version numbers (not",
	"all do).",
	NULL,
};

char *help_print_password_in_debug[] = {
	"Specifies whether to print passwords in the diagnostics window when",
	"the user preference DIAGNOSTICS is set to DEBUG.",
	NULL,
};

char *help_history_sort_order[] = {
	"Specifies how to sort history items (such as names of previously",
	"visited directories) when they are displayed in dialogs and",
	"menus.  If ALPHANUMERIC, then sort by the ASCII-collating",
	"sequence.  If BY LAST USE, then the most recently used items are",
	"placed at the top of the list.",
	NULL
};

char *help_stop_button_blinking[] = {
	"Specifies whether the STOP button (shown during potentially",
	"lengthy operations) should blink or not.",
	NULL
};

char *help_store_unique[] = {
	"Specifies whether existing sink files are to be renamed before",
	"file transfer occurs.  If YES, then the existing sink file",
	"is typically renamed by appending a \".\" (period) followed",
	"by an integer between 1 and 99.",
	NULL
};

char *help_type_to_select_delay[] = {
	"The number of milliseconds to wait before LLNL XDIR determines that",
	"you are finished typing characters into a directory window to select",
	"the first entry that best matches the characters.",
	NULL
};

char *help_use_last_dir[] = {
	"Specifies whether to automatically re-enter the most recently",
	"referenced directory after connecting to a host.  If this",
	"option is requested, but is not possible to perform (e.g.,",
	"because the directory no longer exists),",
	"your home directory will be entered.  Note: This mechanism",
	"attempts to enter the last directory referenced on the host,",
	"regardless of whether it is another user's directory.",
	NULL
};

char *help_max_wildcard_history[] = {
	"The number of wildcard expressions to save.  These wildcard",
	"expressions are preserved across LLNL XDIR sessions.",
	NULL
};

char *help_prefs_dialog[] = {
	"This window allows you to configure LLNL XDIR according to",
	"your tastes.  Use the option menu at the top of the window",
	"to display a subset of the configuration parameters, whose",
	"values may then be changed by either toggling,",
	"sliding, or typing.  Click the APPLY button to cause the",
	"new values to take effect.  The OK button has the same",
	"effect as APPLY, but the dialog is also closed.",
	"The CANCEL button undoes changes made since OK or APPLY",
	"were last pressed.\n",
	"\n",
	"The preferences can be preserved across LLNL XDIR sessions in",
	"a text file named \".xdirrc\" in the user's home directory",
	"(select SAVE PREFERENCES in the main window's FILE menu).\n",
	"\n",
	"IMPORTANT: An online description of each user preference can be viewed",
	"by clicking on the name of the desired user preference.",
	NULL
};

extern struct prefs_struct prefs[];


/*
 * cb_gprefs_item_help - Callback that displays help information about the
 *                       user preference clicked on.
 */
void
cb_gprefs_item_help(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
    int indx = (int)client_data;
	int len;
	char *label;
	int i;

    len = strlen(prefs[indx].file_label);
    label = XtNewString(prefs[indx].file_label);
    for (i=0; i<len; i++)
        if (label[i] == '_')
            label[i] = ' ';
	help_dialog(widget, False, label, prefs[indx].help_text);
    XtFree(label);
}


/*
 * cb_gprefs_help - Callback that displays help information about the
 *                  User Preferences dialog.
 */
cb_gprefs_help(widget, client_data, call_data)
Widget widget;
XtPointer client_data;
XtPointer call_data;
{
	help_dialog(widget, False, "General Preferences", help_prefs_dialog);
}

