


xdir(1)                  USER COMMANDS                    xdir(1)



NAME
     _L_L_N_L _X_D_I_R - A graphical network-oriented file manager


SYNOPSIS
     xdir [options] [directory path]


DESCRIPTION
     _L_L_N_L _X_D_I_R provides a graphical user interface for file
     transfer and for direct manipulation of local and remote
     directories on UNIX (and a number of non-UNIX) platforms.
     _L_L_N_L _X_D_I_R offers the ability to view directory information
     in four different formats, ranging from long lists to tree
     structures.  _L_L_N_L _X_D_I_R is based on UNIX, the C programming
     language, OSF/Motif and FTP; hence, _L_L_N_L _X_D_I_R is highly
     portable.

     With _L_L_N_L _X_D_I_R, you can manage virtually all of your files
     in a network.  Specifically, _L_L_N_L _X_D_I_R can be used to browse
     directory structures, transfer files and directories, view
     local and remote files, delete files and directories, rename
     files and directories, and search directories on one or more
     hosts for entries matching a specified pattern.

     _L_L_N_L _X_D_I_R simultaneously displays any number of directories
     of any number of (local or remote) hosts, with each direc-
     tory being displayed in its own window.  Several existing
     products are able to manage files on a single system, but
     _L_L_N_L _X_D_I_R extends this capability to manage files on an
     entire network.

     _L_L_N_L _X_D_I_R does not have a "main" window, as such, but
     instead consists of a number of windows, each of which
     displays the contents of a local or remote host's directory.
     Each of these "directory windows" has a complete set of con-
     trols for setting modes and invoking operations.  Several
     other windows are provided for setting general preferences
     and displaying diagnostic information.

     _L_L_N_L _X_D_I_R offers elaborate directory-browsing functionality.
     Each directory can be viewed in several different formats,
     ranging from long lists to tree structures.  A number of
     mechanisms are provided to traverse directory structures,
     including: (1) double-clicking a directory name/icon to
     enter that directory, (2) a "go to parent directory" button,
     (3) a "go to home directory" button, and (4) a sophisticated
     history mechanism for easily reentering previously visited
     directories.

     _L_L_N_L _X_D_I_R provides powerful file transfer capability using
     drag-and-drop.  It is just as easy to copy a file between



                  Last change: 23 October 1995                  1






xdir(1)                  USER COMMANDS                    xdir(1)



     two remote systems as it is to copy a file from the local
     host to itself.  Files and directories may be transferred
     either singly or in groups with just a few movements of the
     mouse.

     One of _L_L_N_L _X_D_I_R's most powerful features is its ability to
     search directory structures for entry names matching a
     specified pattern.  You are able to specify the range and
     depth of such searches.  The search can be restricted to a
     single subdirectory or can extend across machine boundaries.

     With _L_L_N_L _X_D_I_R, you are able to view local or remote files,
     using either the built-in viewer or any combination of
     external viewers of your choice (e.g., _e_m_a_c_s or _x_v).

     _L_L_N_L _X_D_I_R's history mechanism makes it simple to establish a
     connection with a remote host.  This and other features make
     it especially painless to connect to an anonymous FTP site.

     A number of directory-manipulation features are provided for
     operating on selected entries.  There are several ways to
     select a group of directory entries to operate on, including
     direct toggling of entries, sweeping out a rectangular area,
     and wildcard selection.  Once entries are selected, you are
     able to rename entries, delete entries (including entire
     subdirectories), or move entries between directories within
     the same host.  You are also able to create directories,
     both on local and remote hosts.

     _L_L_N_L _X_D_I_R utilizes a history mechanism for automatically
     saving (1) wildcard expressions used in selecting directory
     entries, (2) previously visited directories, (3) host/user
     name pairs used in connecting to remote hosts, and (4) low-
     level "quoted" commands sent to the host's FTP server.  The
     purpose of this mechanism is to reduce the amount of typing
     and mouse movement required.  For example, when you wish to
     apply a wildcard expression to select directory entries to
     operate on, a list of recently referenced wildcard expres-
     sions for that host will be presented; you can then double-
     click on an existing wildcard expression to apply it.  The
     histories are automatically preserved across _L_L_N_L _X_D_I_R ses-
     sions.

     _L_L_N_L _X_D_I_R presents a graphical user interface for easily
     tailoring the program's behavior.  You are able to specify
     such things as whether you would like the delete operation
     to first pop up a verification dialog listing the entries to
     be deleted.

     Finally, an extensive on-line help facility, much of which
     is contextual, is provided.  However, experience has shown
     that the user interface is so intuitive that the user rarely



                  Last change: 23 October 1995                  2






xdir(1)                  USER COMMANDS                    xdir(1)



     needs to access the help package.

OPTIONS
     _L_L_N_L _X_D_I_R accepts all of the standard X Toolkit command line
     options, as well as the following option:

     -color
          Force _L_L_N_L _X_D_I_R to use a nice color scheme, even if the
          application defaults file, _X_D_i_r, is not found.

GETTING STARTED
     When _L_L_N_L _X_D_I_R is started, a window appears that displays
     the contents of a directory on the local host.  This window
     is called a "directory window."  You can have any number of
     directory windows for any number of hosts.

     Use the _C_o_n_n_e_c_t menu to connect to a remote host.  Select
     _C_o_n_n_e_c_t _t_o _A_n_o_n_y_m_o_u_s to connect to an anonymous FTP site.
     Choose _C_o_n_n_e_c_t _t_o _R_e_m_o_t_e to connect to other remote hosts.
     A directory window will be created for the specified host.

     You can use a host's directory window to create another
     directory window for that host,  First make sure that tun-
     neling mode is off for that directory window (using the tun-
     nel icon in the toolbar).  Then, simply change to another
     undisplayed directory by using any of the following tech-
     niques: (1) double-click an entry name or icon that
     represents a directory, (2) press the "go to parent direc-
     tory" button (the up-arrow button in the toolbar), (3) press
     the "go to home directory" button (the house button in the
     toolbar), or (4) select an item in the _G_o_t_o menu.  If tun-
     neling mode happens to be on, the current directory window
     is used to display the specified directory.

     _L_L_N_L _X_D_I_R has several mechanisms to aid you in managing a
     proliferation of directory windows: (1) directory windows
     may be individually iconified (using the window manager),
     (2) all iconified _L_L_N_L _X_D_I_R windows can be redisplayed by
     selecting _D_e_i_c_o_n_i_f_y _A_l_l in the _F_i_l_e menu, (3) any request to
     display a directory that is iconified or buried under other
     windows causes its directory window to be brought to the
     front, and (4) the _W_i_n_s menu can be used to identify exist-
     ing directory windows and bring them to the front.

     Change between different formats for displaying information
     within a directory window by toggling the layout buttons in
     the directory window's toolbar.

     Many operations require that entries in a directory window
     first be selected.  Select/deselect entries by (1) single-
     clicking on an entry (which toggles its selection state),
     (2) holding the left mouse button down and dragging to sweep



                  Last change: 23 October 1995                  3






xdir(1)                  USER COMMANDS                    xdir(1)



     out a selection rectangle (which individually toggles each
     entry's selection state), (3) selecting any of the items in
     the directory window's _S_e_l_e_c_t menu, or (4) typing a sequence
     of characters into a directory window to select the first
     entry that most closely matches the characters.

     Copy (i.e., transfer) selected entries by using the left
     mouse button to drag the entries.  The drop site of the drag
     can be (1) the background of another directory window, (2) a
     directory entry in any directory window (including the
     source directory window).  Directories, as well as files,
     can be transferred.  _L_L_N_L _X_D_I_R does not permit transfers
     from a remote host to itself.  The desired file transfer
     mode can be specified by using the option menu in the tool-
     bar of any directory window.

     Move selected entries by using the left mouse button to drag
     the entries, and holding down the control key when the mouse
     button is released over the drop site.  (A move differs from
     a transfer in that (1) the source entries are destroyed, and
     (2) a move is usually implemented by manipulating file sys-
     tem pointers rather than by actually copying bits.)  The
     drop site of the drag may be (1) the background of another
     directory window, (2) a directory entry in any directory
     window (including the source directory window).  _L_L_N_L _X_D_I_R
     only allows moves from a host to itself.

     View selected files by selecting _V_i_e_w _S_e_l_e_c_t_e_d _E_n_t_r_i_e_s in
     the directory window's _O_p_s menu.  Also, you may double-click
     on an entry that _L_L_N_L _X_D_I_R knows not to be a directory.
     Configure the viewer by selecting item _V_i_e_w_e_r _P_r_e_f_e_r_e_n_c_e_s in
     the _P_r_e_f_s menu.  Be sure to first set the file transfer mode
     by using the option menu in the toolbar of any directory
     window.

     Delete selected entries by pressing the trash can button in
     the toolbar.  Directories, as well as files, may be deleted.

     Search for an entry that matches a specified wildcard
     expression by selecting _S_e_a_r_c_h in the _O_p_s menu.  You are
     able to specify the range and depth of the search.  After a
     match has been found, you can continue the search by select-
     ing _S_e_a_r_c_h _A_g_a_i_n in the _O_p_s menu.

     Some other operations on selected entries may be invoked by
     selecting appropriate items in the directory window's _O_p_s
     menu.

     Abort in-progress operations by pressing the animated stop
     button in the upper-right corner of the affected directory
     window (this button is normally labeled "LLNL XDIR").  _L_L_N_L
     _X_D_I_R will attempt to return control to you at the earliest



                  Last change: 23 October 1995                  4






xdir(1)                  USER COMMANDS                    xdir(1)



     possible moment.

     Configure _L_L_N_L _X_D_I_R by selecting the _G_e_n_e_r_a_l _P_r_e_f_e_r_e_n_c_e_s
     item in the _P_r_e_f_s menu.


DIRECTORY WINDOW TOOLBAR
     Each directory window has a toolbar that can be used to set
     modes and to invoke operations.  From left to right, the
     toolbar controls are:

     Transfer Mode  (Option menu)
          The option menu at the left allows you to choose the
          file transfer mode (_A_S_C_I_I or _B_i_n_a_r_y).  This mode is
          global in scope; hence, changing the value in one
          directory window will automatically change the value in
          all directory windows.

     Layout Mode  (Group of four buttons)
          The layout mode controls how the directory entries are
          displayed.  The first button selects "Tabular Layout,"
          in which only the entry names are displayed.  The
          second button selects "Iconic Layout," in which an icon
          and name is displayed for each entry.  In Iconic Lay-
          out, five different icons are used to identify the
          entry type: directory, executable file, generic file,
          socket, and link.  The third button selects "Tree Lay-
          out," which is similar to Iconic Layout except that
          each entry that is a directory also has a small
          triangle-shaped button, which can be used to expand and
          collapse the subdirectory.  The last button selects
          "Full Info Layout," which displays as much information
          about each directory entry as possible (the amount of
          information available is limited by the host's FTP
          server).

     Tunneling Mode  (Button with picture of tunnel)
          If "tunneling mode" is off, entering a directory that
          is not already displayed will cause a new window to be
          created to display that directory.  If tunneling mode
          is on, an existing directory window (the one from the
          which the command was invoked) will be used to display
          a directory that does not already have it own window.

     Dot Files Mode  (Button with dot in dog-eared page)
          If "dot files mode" is on, then entry names that begin
          with a dot (i.e., period) will be displayed.

     Cache Mode  (Button with "C")
          If "cache mode" is on, then directory lists from remote
          hosts will be saved and used to quickly display
          revisited directories.



                  Last change: 23 October 1995                  5






xdir(1)                  USER COMMANDS                    xdir(1)



     Refresh Directory  (Button with starburst shape)
          Redisplay this window's directory.

     Go To Parent  (Up arrow button)
          Display this window's parent directory.

          Also, pressing the right mouse button pops up a menu
          that contains the paths for each ancestor of this win-
          dow.  Select a path to display that directory.

     Go To Home   (House button)
          Display the home directory of this directory window's
          host.

     Delete  (Trash can button)
          Delete selected directory entries.

     Make Directory  (Button containing folder labeled "New")
          Create a directory.

     Close  (Skull and cross bones button)
          Get rid of this directory window.


DIRECTORY WINDOW COMMANDS
     _L_L_N_L _X_D_I_R contains a large number of commands that can be
     invoked from the directory windows.  Most commands are
     invoked (1) from the menus, (2) from the toolbars, and (3)
     by dragging and dropping directory entries.  Here is a list
     of the commands:

     About _L_L_N_L _X_D_I_R (in _F_i_l_e menu)
          Give version information.

     Close (in _F_i_l_e menu and toolbar)
          Remove (not iconify) this directory window.  If this
          directory window is the last for its host, the host is
          disconnected.

     Connect to Anonymous (in _C_o_n_n_e_c_t menu)
          Easily connect to an anonymous FTP site.  A dialog pops
          up to prompt for the remote host, user name and pass-
          word.  The user name is initialized to "anonymous". The
          password is initialized to the value of the general
          preference _A_n_o_n_y_m_o_u_s _F_t_p _P_a_s_s_w_o_r_d (which you will prob-
          ably want to set to your email address).  If the gen-
          eral preference _A_n_o_n_y_m_o_u_s _F_t_p _P_a_s_s_w_o_r_d is blank, _L_L_N_L
          _X_D_I_R will attempt to create a password of the form
          "user@host".  An optional, space-delimited port number
          may follow the host name.  Previously used host/user
          name pairs are saved across sessions, and those with
          user names "anonymous" or "ftp" are displayed in the



                  Last change: 23 October 1995                  6






xdir(1)                  USER COMMANDS                    xdir(1)



          scrolled list _R_e_c_e_n_t_l_y _R_e_f_e_r_e_n_c_e_d _H_o_s_t_s.  Double-
          clicking on a host/user name pair initiates a connec-
          tion.  Single-clicking on a host/user name pair places
          those values into the host name and user name fields,
          where they can be edited.  Click on the _C_o_n_n_e_c_t button
          to initiate a connection.  (If already connected, a
          directory window for that host is simply brought to the
          front.)  (See general preferences _A_n_o_n_y_m_o_u_s _F_t_p _P_a_s_s_-
          _w_o_r_d, _H_i_s_t_o_r_y _S_o_r_t _O_r_d_e_r, _M_a_x _H_o_s_t _N_a_m_e _H_i_s_t_o_r_y, and
          _M_a_x _U_s_e_r _N_a_m_e _H_i_s_t_o_r_y.)

     Connect to Local (in _C_o_n_n_e_c_t menu)
          Connect to the local host (i.e., the host upon which
          _L_L_N_L _X_D_I_R is executing).  If already connected, an
          existing directory window for the local host is brought
          to the front.

     Connect to Remote (in _C_o_n_n_e_c_t menu)
          Connect to a remote host (use _C_o_n_n_e_c_t _t_o _A_n_o_n_y_m_o_u_s to
          more easily connect to an anonymous FTP site).  A dia-
          log pops up to prompt for the remote host and user
          names. The user name is initialized to the value of the
          environment variable _U_S_E_R.  An optional, space-
          delimited port number may follow the host name.  Previ-
          ously used host/user name pairs are saved across ses-
          sions, and those with user names other than "anonymous"
          and "ftp" are displayed in the scrolled list _R_e_c_e_n_t_l_y
          _R_e_f_e_r_e_n_c_e_d _H_o_s_t_s.  Double-clicking on a host/user name
          pair initiates a connection.  Single-clicking on a
          host/user name pair places those values into the host
          name and user name fields, where they can be edited.
          Click on the _C_o_n_n_e_c_t button to initiate a connection.
          (If already connected, a directory window for the host
          is simply popped to the top.)  (See general preferences
          _H_i_s_t_o_r_y _S_o_r_t _O_r_d_e_r, _M_a_x _H_o_s_t _N_a_m_e _H_i_s_t_o_r_y, and _M_a_x _U_s_e_r
          _N_a_m_e _H_i_s_t_o_r_y.)

     Contextual Help (in _H_e_l_p menu)
          Enter contextual-help mode.  The mouse cursor changes
          to a pointing hand.  Click on any graphical element in
          the directory window that you wish to know more about.

     Copy (drag-and-drop operation)
          Copy (i.e., transfer) the selected files according to
          the mode (ASCII or Binary) specified in the toolbar's
          file transfer mode option menu.  Copy selected items by
          using the left mouse button to drag the items.  The
          drop site of the drag can be (1) the background of
          another directory window, (2) a directory entry in any
          directory window (including the source directory win-
          dow).  Directories, as well as files, can be
          transferred (but the general preference _C_o_p_y _M_o_d_e must



                  Last change: 23 October 1995                  7






xdir(1)                  USER COMMANDS                    xdir(1)



          be set to _R_e_c_u_r_s_i_v_e).  _L_L_N_L _X_D_I_R does not permit
          transfers from a remote host to itself.  The desired
          file transfer mode can be specified via the option menu
          in the toolbar of any directory window.  Set general
          preference _C_o_p_y _M_o_d_e to _R_e_c_u_r_s_i_v_e to allow copying of
          directories.  Set general preference _O_v_e_r_w_r_i_t_e _D_i_r _O_n
          _C_o_p_y to specify whether or not it is okay to overwrite
          an existing directory.  A dialog pops up to enable the
          user to monitor the progress of the transfers.  This
          dialog contains a button for aborting the transfers.
          (See general preferences _B_e_e_p _W_h_e_n _O_p_s _D_o_n_e, _C_o_p_y _M_o_d_e,
          _I_n_i_t_i_a_l _T_r_a_n_s_f_e_r _M_o_d_e, _I_n_q_u_i_r_e _O_n _C_o_p_y, and _O_v_e_r_w_r_i_t_e
          _D_i_r _O_n _C_o_p_y.)

     Delete Selected Entries (in _O_p_s menu and toolbar)
          Delete the selected entries.  Set general preference
          _D_e_l_e_t_e _M_o_d_e to _R_e_c_u_r_s_i_v_e to allow deletion of nonempty
          directories.  A dialog pops up to enable the user to
          monitor the progress of the deletions.  This dialog
          contains a button for aborting the deletions.  (See
          general preferences _B_e_e_p _W_h_e_n _O_p_s _D_o_n_e, _D_e_l_e_t_e _M_o_d_e and
          _I_n_q_u_i_r_e _O_n _D_e_l_e_t_e.)

     Deselect All Entries (in _S_e_l_e_c_t menu)
          Deselect all the entries in this directory window.

     Deiconify All (in _F_i_l_e menu)
          Deiconify all top-level windows in the application.

     Diagnostics (in _W_i_n_s menu)
          Display the diagnostics window.

     Disconnect (in _C_o_n_n_e_c_t menu)
          Terminate the connection to this directory window's
          host.  All directory windows associated with this host
          are closed.

     Edit History (in _F_i_l_e menu)
          Display the Edit History dialog.  See section _E_d_i_t _H_i_s_-
          _t_o_r_y for details.

     Getting Started (in _H_e_l_p menu)
          Learn how to get started using _L_L_N_L _X_D_I_R.

     General Preferences (in _P_r_e_f_s menu)
          Display the General Preferences window.  See section
          _G_e_n_e_r_a_l _P_r_e_f_e_r_e_n_c_e_s for details.

     Go to Ancestor ((in _G_o_t_o menu and toolbar)
          Display an ancestor of this directory window.

     Go to Directory (in _G_o_t_o menu)



                  Last change: 23 October 1995                  8






xdir(1)                  USER COMMANDS                    xdir(1)



          Display a directory.  A dialog pops up to prompt for
          the directory path.  The directory may be specified
          with a full or relative path.  Previously referenced
          directories are saved and displayed in a scrollable
          list.  Double-click on a path in the list to display
          that directory.  Single click on a path in the list to
          place that entry into text field _D_i_r_e_c_t_o_r_y, where it
          can be edited.  Click on the _O_K button to change to the
          directory displayed in the text field.  (See general
          preferences _H_i_s_t_o_r_y _S_o_r_t _O_r_d_e_r, _M_a_x _D_i_r _N_a_m_e _H_i_s_t_o_r_y,
          and _M_a_x _H_o_s_t _N_a_m_e _H_i_s_t_o_r_y.)

     Go to Home Directory (in _G_o_t_o menu and toolbar)
          Display the home directory of this directory window's
          host.

     Go to Parent Directory (in _G_o_t_o menu and toolbar)
          Display the parent directory of this directory window.

     Iconify All (in _F_i_l_e menu)
          Iconify all top-level windows in the application.

     Launch (submenu in _O_p_s menu and popup menu in entries area)
          Launch application as a child process.  Select a com-
          mand name in the _L_a_u_n_c_h submenu to fork and exec the
          associated command.  See section _L_a_u_n_c_h_e_r _P_r_e_f_e_r_e_n_c_e_s
          for details on constructing commands.) When a command
          is launched, placeholders are replaced by their values
          as follows: "%u" is replaced by the user name, "%h" is
          replaced by the host name, "%s" is replaced by the name
          of a selected entry, and "%l" is replaced by the
          blank-delimited names of all selected entries.  If "%s"
          is used, then the command is launched once for each
          selected entry, each time "%s" being replaced by the
          full path of the next selected entry name.

     Launcher Preferences (in _P_r_e_f_s menu)
          Display the Launcher Preferences window.  See section
          _L_a_u_n_c_h_e_r _P_r_e_f_e_r_e_n_c_e_s for details.

     LLNL XDIR Overview (in _H_e_l_p menu)
          Give a high-level description of _L_L_N_L _X_D_I_R.

     Make Directory (in _O_p_s menu and toolbar)
          Pop up a dialog to prompt for the name of a directory
          to create in the displayed directory.

     Move (drag-and-drop operation)
          Move selected entries from one directory to another on
          the same host.  Move selected items by using the left
          mouse button to drag the items, and holding down the
          control key when the mouse button is released over the



                  Last change: 23 October 1995                  9






xdir(1)                  USER COMMANDS                    xdir(1)



          drop site.  (A move differs from a transfer in that (1)
          the source entries are destroyed, and (2) a move is
          usually implemented by manipulating file system
          pointers rather than by actually copying bits.) The
          drop site of the drag can be (1) the background of
          another directory window, and (2) a directory entry in
          any directory window (including the source directory
          window).  _L_L_N_L _X_D_I_R only allows moves from a host to
          itself.  A dialog pops up to enable the user to monitor
          the progress of the moves.  This dialog contains a but-
          ton for aborting the move operations.  (See general
          preferences _B_e_e_p _W_h_e_n _O_p_s _D_o_n_e, and _I_n_q_u_i_r_e _o_n _M_o_v_e.)

     Quit (in _F_i_l_e menu)
          Terminate the application.

     Refresh Directory (in _O_p_s menu)
          Redisplay this window's directory.

     Rename Selected Entries (in _O_p_s menu)
          Pop up a dialog to individually rename selected
          entries.

     Save Preferences (in _P_r_e_f_s menu)
          Save the current settings of the general, viewer, and
          launcher preferences.

     Search (in _O_p_s menu)
          Pop up a dialog to initiate a search of directory win-
          dows for entry names that match a specified pattern.
          The pattern to be matched can contain the usual wild-
          card characters ('*', '?', '[', and ']').  The toggle
          item _M_a_t_c_h _C_a_s_e controls whether case (upper or lower)
          should be considered when looking for a match.  The
          _M_a_x_i_m_u_m _S_e_a_r_c_h _D_e_p_t_h slider is used to specify the max-
          imum number of directory levels the search command will
          explore when looking for an entry that matches the
          specified pattern.  Choose one of the toggle items,
          _S_e_a_r_c_h _t_h_i_s _d_i_r_e_c_t_o_r_y, _S_e_a_r_c_h _a_l_l _d_i_s_p_l_a_y_e_d _d_i_r_e_c_t_o_r_i_e_s
          _o_f _t_h_i_s _h_o_s_t, or _S_e_a_r_c_h _a_l_l _d_i_s_p_l_a_y_e_d _d_i_r_e_c_t_o_r_i_e_s _o_f
          _a_l_l _h_o_s_t_s, to specify which directory windows (and
          their descendants) are to be searched.

          When the _O_K button is pressed, a dialog appears to mon-
          itor the progress of the search.  This dialog contains
          a button that can be used to abort the search.

          If a match is found in a directory that is already
          displayed, the entry is selected, scrolled into view,
          and its directory window is brought to the front.  If a
          match is found in a directory that is not already
          displayed, there are two cases: If the search was



                  Last change: 23 October 1995                 10






xdir(1)                  USER COMMANDS                    xdir(1)



          initiated from a directory window with tunneling mode
          on, the entry's directory is displayed in that direc-
          tory window; otherwise a new window is created to
          display the entry's directory.

          Use _S_e_a_r_c_h _A_g_a_i_n to continue the search once an entry
          has been found.  (See general preferences _B_e_e_p _W_h_e_n _O_p_s
          _D_o_n_e, _I_n_i_t_i_a_l _M_a_x _S_e_a_r_c_h _D_e_p_t_h, _I_n_i_t_i_a_l _S_e_a_r_c_h _C_a_s_e
          _M_a_t_c_h, and _I_n_i_t_i_a_l _S_e_a_r_c_h _R_a_n_g_e).

     Search Again (in _O_p_s menu)
          Search for the next entry that satisfies the search
          criteria specified by the last search command.  (See
          general preference _B_e_e_p _W_h_e_n _O_p_s _D_o_n_e).

     Select All Entries (in _S_e_l_e_c_t menu)
          Select all the entries in this window.

     Send Quoted Command (in _O_p_s menu)
          Pop up a dialog to prompt for a "raw" command to send
          to the FTP server of the remote host.  Previously
          issued commands are saved and displayed in a scrolled
          list.  Double-clicking on a command in the list issues
          that command.  To have a command act on selected
          entries, use the quote placeholder ("%s") to represent
          a selected item.  For example, type "stage 1 %s" to
          send a STAGE command to the the remote host for each
          selected entry.  (See general preference _B_e_e_p _W_h_e_n _O_p_s
          _D_o_n_e and _M_a_x _Q_u_o_t_e_d _C_m_d _H_i_s_t_o_r_y.)

     Use Wildcard (in _S_e_l_e_c_t menu)
          Pop up a dialog to prompt for a wildcard expression to
          use in selecting entries in this directory window.
          Previously referenced wildcard expressions are saved
          and displayed in a scrolled list.  Double-clicking on
          an item in the list applies that wildcard expression.
          Single-clicking on an item in the list places the
          expression in a text field where it may be edited.
          Choose the toggle item _R_e_p_l_a_c_e _S_e_l_e_c_t_i_o_n to cause the
          currently selected entries to be cleared before apply-
          ing the wildcard.  Choose the toggle item _A_d_d _t_o _S_e_l_e_c_-
          _t_i_o_n to cause the entries selected by the wildcard to
          be added to the current selection.  (See general
          preference _I_n_i_t_i_a_l _W_i_l_d_c_a_r_d _M_o_d_e and _M_a_x _W_i_l_d_c_a_r_d _H_i_s_-
          _t_o_r_y).

     Using Help (in _H_e_l_p menu)
          Describe the online help package.

     View Selected Files (in _O_p_s menu)
          Display the selected files.  The viewer preferences
          dialog (accessible via the _P_r_e_f_s menu) can be used to



                  Last change: 23 October 1995                 11






xdir(1)                  USER COMMANDS                    xdir(1)



          control whether files will be displayed using the
          built-in viewer or using an external viewer of the
          user's choice (e.g., _e_m_a_c_s or _x_v).  The selection of
          the viewer is configurable, based on the file extension
          (e.g., ".gif" or ".jpg").

          The file is transferred according to the mode (ASCII or
          Binary) specified in the toolbar of the directory win-
          dow.  A dialog pops up to enable the user to monitor
          the progress of the transfer.  This dialog contains a
          button for aborting the transfer.

          The destination of the transfer is a temporary direc-
          tory created in the directory defined as _P__t_m_p_d_i_r in
          the include file "/usr/include/stdio.h".  If the
          environment variable _T_M_P_D_I_R is defined, it is used as
          the directory.  The temporary directory, and the files
          it contains, are automatically deleted when the user
          dismisses the viewer or terminates _L_L_N_L _X_D_I_R.

          If the file is recognized as being compressed, it is
          expanded before viewing.  _L_L_N_L _X_D_I_R excutes the follow-
          ing decompressors based on the file extension: _g_u_n_z_i_p
          for ".z" and ".gz"; _u_n_c_o_m_p_r_e_s_s for ".Z"; _a_t_o_b for
          "atob"; and _u_u_d_e_c_o_d_e for ".uu".  _L_L_N_L _X_D_I_R searches for
          the decompressor application in the standard way using
          the _P_A_T_H environment variable.

     Viewer Preferences (in _P_r_e_f_s menus)
          Display the viewer preferences window.  See section
          _V_i_e_w_e_r _P_r_e_f_e_r_e_n_c_e_s for details.


GENERAL PREFERENCES
     Selecting item _G_e_n_e_r_a_l _P_r_e_f_e_r_e_n_c_e_s in a directory window's
     _P_r_e_f_s menu pops up a dialog that allows you to configure
     _L_L_N_L _X_D_I_R according to your tastes.  Use the option menu at
     the top of the window to display a subset of the configura-
     tion parameters, whos values may then be changed by either
     toggling, sliding, or typing.  Click the _A_p_p_l_y button to
     cause the new values to take effect.  The _O_K button has the
     same effect as _A_p_p_l_y, but the dialog is also closed.  The
     _C_a_n_c_e_l button undoes changes made since _O_K or _A_p_p_l_y were
     last pressed.  The preferences can be preserved across _L_L_N_L
     _X_D_I_R sessions in a text file named ".xdirrc" in your home
     directory.

     Anonymous Ftp Password
          The value to initialize the _P_a_s_s_w_o_r_d field of the Con-
          nect to Anonymous dialog to.  This is normally your
          email address.  If the value is blank, _L_L_N_L _X_D_I_R
          attempts to construct a password of the form



                  Last change: 23 October 1995                 12






xdir(1)                  USER COMMANDS                    xdir(1)



          "user@host".  The Connect to Anonymous dialog is acces-
          sible via each directory window's _C_o_n_n_e_c_t menu.

     Beep When Ops Done
          Specifes whether to beep when each set of deletion,
          move, quoted command, search, and file transfer opera-
          tions completes.

     Copy Mode
          Specifies whether to allow recursive file transfers.

     Delete Mode
          Specifies whether to allow recursive delete operations.

     History Sort Order
          Specifies how to sort history items (such as names of
          previously visited directories) when they are displayed
          in dialogs and menus.  If _A_l_p_h_a_n_u_m_e_r_i_c, then sort by
          the ASCII-collating sequence.  If _B_y _L_a_s_t _U_s_e, then the
          most recently used items are placed at the top of the
          list.

     Initial Cache Mode
          Specifies cache mode for the first created directory
          window.  Cache mode controls whether directory lists
          from remote hosts will be saved and used to quickly
          display revisited directories.  Each subsequently
          created directory window inherits its cache mode from
          its parent directory window.

     Initial Diagnostics
          The default level of diagnostics information to be
          written to the diagnostics window.  Choose _Q_u_i_e_t for
          error messages, only.  Choose _N_o_r_m_a_l for error messages
          and success messages.  Choose _V_e_r_b_o_s_e for error mes-
          sages, success messages, and replies received from the
          FTP servers.  Choose _D_e_b_u_g for error messages, success
          messages, commands sent to the FTP servers, replies
          received from the FTP servers, and other assorted diag-
          nostics.

     Initial Directory Layout
          The layout used by the first created directory window.
          Each subsequently created directory window inherits its
          directory layout mode from its parent directory window.

     Initial Dot Files Mode
          Specifies whether the first created directory window
          will display dot files.  Each subsequently created
          directory window inherits its dot files mode from its
          parent directory window.




                  Last change: 23 October 1995                 13






xdir(1)                  USER COMMANDS                    xdir(1)



     Initial Max Search Depth
          The default maximum number of directory levels the
          search command will explore when looking for an entry
          that matches the specified pattern.

     Initial Max Viewer Width
          The maximum initial width in characters that the
          built-in viewer takes on.  The first part of the file
          to be viewed is examined to determine an appropriate
          width to initialize the viewer to.  The initial width
          will not exceed the value of this preference.

     Initial Search Direction
          The default value that specifies the direction to
          search the built-in file viewer for a text string using
          the "Find" operation.

     Initial Search Case Match
          The default value that specifies whether search or find
          commands should consider case when looking for an entry
          that matches the specified pattern.

     Initial Search Range
          The default value used as the search range in the
          Search dialog.  Choose _T_h_i_s _D_i_r to make _S_e_a_r_c_h _t_h_i_s
          _d_i_r_e_c_t_o_r_y the default.  Choose _T_h_i_s _H_o_s_t to make _S_e_a_r_c_h
          _a_l_l _d_i_s_p_l_a_y_e_d _d_i_r_e_c_t_o_r_i_e_s _o_f _t_h_i_s _h_o_s_t the default.
          Choose _A_l_l _H_o_s_t_s to make _S_e_a_r_c_h _a_l_l _d_i_s_p_l_a_y_e_d _d_i_r_e_c_-
          _t_o_r_i_e_s _o_f _a_l_l _h_o_s_t_s the default.

     Initial Transfer Mode
          The default file transfer mode (_A_S_C_I_I or _B_i_n_a_r_y).

     Initial Tunneling Mode
          Specifies tunneling mode for the first created direc-
          tory window.  Tunneling mode controls whether or not a
          new directory window is created to display a directory.
          Each subsequently created directory window inherits its
          tunneling mode from its parent directory window.

     Initial Wildcard Mode
          The default mode of the Use Wildcard dialog.  Choose
          _R_e_p_l_a_c_e to make _R_e_p_l_a_c_e _S_e_l_e_c_t_i_o_n the default.  Choose
          _A_d_d to make _A_d_d _t_o _S_e_l_e_c_t_i_o_n the default.

     Inquire On Copy
          Specifies whether to pop up a dialog that asks the user
          to confirm that the indicated file transfers should
          take place.

     Inquire On Delete
          Specifies whether to pop up a dialog that asks the user



                  Last change: 23 October 1995                 14






xdir(1)                  USER COMMANDS                    xdir(1)



          to confirm that the indicated delete operations should
          take place.

     Inquire On Move
          Specifies whether to pop up a dialog that asks the user
          to confirm that the indicated moves should take place.

     Inquire On Quoted Cmd
          Specifies whether to pop up a dialog that asks the user
          to confirm that the indicated commands should be sent.

     Max Dir Cache Len (KB)
          Specifies the maximum size (in kilobytes) of the direc-
          tory cache.

     Max Dir Name History
          The maximum number of previously referenced directory
          paths saved per host.  These path names are preserved
          across _L_L_N_L _X_D_I_R sessions.

     Max Ftp Retries
          Specifies the maximum number of retries _L_L_N_L _X_D_I_R will
          attempt if it receives a response from an FTP server
          that indicates the desired operation failed because of
          some temporary condition on the remote host.

     Max Host Name History
          The maximum number of hosts to save history items for.
          The history information is preserved across _L_L_N_L _X_D_I_R
          sessions.

     Max Quoted Cmd History
          The number of quoted commands to save.  These commands
          are preserved across _L_L_N_L _X_D_I_R sessions.

     Max Time For Ftp Reply
          Specifies the maximum time in seconds that _L_L_N_L _X_D_I_R
          will wait for a response from an FTP server before con-
          cluding that the connection has been broken.

     Max User Name History
          The number of user names to save for remote hosts).
          These user names are preserved across _L_L_N_L _X_D_I_R ses-
          sions.

     Max Wildcard History
          The number of wildcard expressions to save.  These
          wildcard expressions preserved across _L_L_N_L _X_D_I_R ses-
          sions.

     Overwrite Dir On Copy
          Specifies whether it is okay to overwrite an existing



                  Last change: 23 October 1995                 15






xdir(1)                  USER COMMANDS                    xdir(1)



          directory when recursively copying another directory by
          the same name.  If a sink directory is overwritten then
          none of its subdirectories will be deleted, but new
          files and subdirectories might be added to it, and some
          existing files might be replaced.

     Preserve Vms Ver Nums
          Specifies whether to preserve VMS file version numbers
          when transferring files from a VMS system.  This is
          only an issue for those VMS FTP servers that provide
          version numbers (at least one server does not).

     Print Password In Debug
          Specifies whether to print passwords in the diagnostics
          window when the level of diagnostics messages is set to
          _D_e_b_u_g.

     Stop Button Blinking
          Specifies whether the STOP button (shown during poten-
          tially lengthy operations) should blink or not.

     Store Unique
          Specifies whether existing sink files are to be renamed
          before file transfer occurs.  If _Y_e_s then the existing
          sink file is typically renamed by appending a "."
          (period) followed by an integer between 1 and 99.

     Type To Select Delay
          The number of milliseconds to wait before _L_L_N_L _X_D_I_R
          determines that you are finished typing characters into
          a directory window to select the first entry that best
          matches the characters.

     Use Last Dir At Login
          Specifies whether to automatically enter the most
          recently referenced directory after connecting to a
          host.  If this option is requested, but is not possible
          to perform (e.g., because the directory no longer
          exists), your home directory will be entered.


VIEWER PREFERENCES
     Selecting item _V_i_e_w_e_r _P_r_e_f_e_r_e_n_c_e_s in a directory window's
     _P_r_e_f_s menu pops up a dialog that allows the user to control
     which file will be displayed with which viewer, based on the
     file extension.

     A file to be viewed is first transferred to a temporary
     directory and then, if necessary, is decompressed.  The file
     extension (e.g., ".gif") is then examined to determine which
     viewer the file is to be displayed in.  There are two types
     of viewers: the viewer built into _L_L_N_L _X_D_I_R (which is



                  Last change: 23 October 1995                 16






xdir(1)                  USER COMMANDS                    xdir(1)



     suitable for displaying text files) and external viewers
     (e.g., _e_m_a_c_s for text and _x_v for graphics).

     Single-click on an entry in the _E_x_t_e_n_s_i_o_n_s list to place
     that extension and its associated command line into the
     _E_x_t_e_n_s_i_o_n and _V_i_e_w_e_r _C_o_m_m_a_n_d _L_i_n_e text fields, respectively.

     An extension is a file suffix that begins with a period
     (".").  A special entry in the extensions list, "OTHERS,"
     represents all files that do not have their extension listed
     (including files with no extensions).

     The pattern "%s" in a command line is a placeholder for the
     name of the file to be viewed.  A blank command line indi-
     cates that the built-in viewer is to be used.  To add a new
     extension to the list, fill in the _E_x_t_e_n_s_i_o_n and _V_i_e_w_e_r _C_o_m_-
     _m_a_n_d _L_i_n_e text fields and press the _A_d_d button.  If the text
     in _E_x_t_e_n_s_i_o_n does not begin with a period, one will be
     added.  If the extension is already in the list, it will be
     replaced.

     To replace the command line associated with an extension,
     (1) single-click on the list item to select it, (2) edit the
     command line, and (3) press the _R_e_p_l_a_c_e button.

     To delete an extension from the list, single-click on the
     list item to select it and then press the _D_e_l_e_t_e button.
     The "OTHERS" entry cannot be deleted (but its command line
     can be replaced).

     Click the _A_p_p_l_y button to cause the new changes to take
     effect.  The _O_K button has the same effect as _A_p_p_l_y, but the
     dialog is also closed.  The _C_a_n_c_e_l button undoes the changes
     made since _O_K or _A_p_p_l_y were last pressed.

     The viewer preferences can be preserved across _L_L_N_L _X_D_I_R
     sessions in a text file named ".xdirrc" in the user's home
     directory (select _S_a_v_e _P_r_e_f_e_r_e_n_c_e_s in a directory window's
     _P_r_e_f_s menu).


LAUNCHER PREFERENCES
     Selecting item _L_a_u_n_c_h_e_r _P_r_e_f_e_r_e_n_c_e_s in a directory window's
     _P_r_e_f_s menu pops up a dialog that allows the user to specify
     commands that can be invoked using the _L_a_u_n_c_h submenu of the
     _O_p_s menu.  The idea is to be able to fork and exec child
     processes with execute lines based on information about
     selected entries.

     Single-click on an entry in the _C_o_m_m_a_n_d _N_a_m_e_s list to place
     that command name and its associated command line into the
     _C_o_m_m_a_n_d _N_a_m_e and _C_o_m_m_a_n_d _L_i_n_e text fields, respectively.



                  Last change: 23 October 1995                 17






xdir(1)                  USER COMMANDS                    xdir(1)



     The following placeholders can be specified in a command
     line: "%u" for the user name, "%h" for the host name, "%s"
     for the name of a selected entry, and "%l" for the blank-
     delimited names of all selected entries.  To add a new com-
     mand to the list, fill in the _C_o_m_m_a_n_d _N_a_m_e and _C_o_m_m_a_n_d _L_i_n_e
     text fields and press the _A_d_d button.  If the command name
     is already in the list, it will be replaced.

     To replace the command line associated with a command name,
     (1) single-click on the list item to select it, (2) edit the
     command line, and (3) press the _R_e_p_l_a_c_e button.

     To delete a command from the list, single-click on the list
     item to select it and then press the _D_e_l_e_t_e button.

     Click the _A_p_p_l_y button to cause the new changes to take
     effect.  The _O_K button has the same effect as _A_p_p_l_y, but the
     dialog is also closed.  The _C_a_n_c_e_l button undoes the changes
     made since _O_K or _A_p_p_l_y were last pressed.

     The launcher preferences can be preserved across _L_L_N_L _X_D_I_R
     sessions in a text file named ".xdirrc" in the user's home
     directory (select _S_a_v_e _P_r_e_f_e_r_e_n_c_e_s in a directory window's
     _P_r_e_f_s menu).

     The names of the commands will be placed in the _L_a_u_n_c_h sub-
     menu of the _O_p_s menu.  (See command _L_a_u_n_c_h in section _D_i_r_e_c_-
     _t_o_r_y _W_i_n_d_o_w _C_o_m_m_a_n_d_s for details on how commands are actu-
     ally launched.)


EDIT HISTORY
     Selecting item _E_d_i_t _H_i_s_t_o_r_y in a directory window's _F_i_l_e
     menu pops up a dialog that allows the user to remove
     unwanted history information.  (_L_L_N_L _X_D_I_R automatically
     saves certain information, such as the paths of previously
     visited directories, for future use.)

     Four categories of history information are saved for each
     host: (1) paths of previously visited directories, (2) wild-
     card expressions used in selecting directory entries, (3)
     user names used in connecting to the host, and (4) low-level
     "quoted" commands sent to the host's FTP server.

     An entire host's history information may be removed by
     selecting an entry in the _H_o_s_t_s list and then clicking the
     _D_e_l_e_t_e _H_o_s_t button.

     A single item may be removed by using the three lists to
     specify host, category and item, and then clicking the
     _D_e_l_e_t_e _I_t_e_m button.




                  Last change: 23 October 1995                 18






xdir(1)                  USER COMMANDS                    xdir(1)



     Click the _O_K button to cause the changes to take effect (and
     remove the dialog).  Click the _C_a_n_c_e_l button to undo the
     changes (and remove the dialog).



LIMITATIONS
     Here are some things to watch out for:

     _L_L_N_L _X_D_I_R might not work with some old X servers.  For exam-
     ple, some older OpenWindows servers might dump core.  MacX
     fans should use nothing older than version 1.1.7b.

     Old, buggy versions of Motif can cause weirdness.

     _L_L_N_L _X_D_I_R might not work correctly with some non-Unix FTP
     servers.  (If you can give us temporary access to such a
     server, we might be able to fix the problem.)

     Out-of-spec FTP servers can cause untold grief.  (Most
     Unix-based servers work correctly.)

     Third-party file transfers will not work unless at least one
     of the remote FTP servers supports the PASV (passive) com-
     mand.


FILES
     $HOME/.xdirhistory   history file
     $HOME/.xdirrc        preferences
     XDir                 application defaults file


AVAILABILITY
     Source code for _L_L_N_L _X_D_I_R is tarred and compressed, and is
     available as follows:

         ftp://coral.ocf.llnl.gov/pub/ia/llnlxdir/latest_xdir.tar.Z

         http://www.llnl.gov/ia/xdir.html


SUPPORT
     Because our resources are limited, we will not be able to
     give individual assistance in building and using _L_L_N_L _X_D_I_R.
     However, your comments, suggestions and bug reports are
     valuable in helping us determine how to best direct our
     efforts.  Our email address is

                                llnlxdir@llnl.gov





                  Last change: 23 October 1995                 19






xdir(1)                  USER COMMANDS                    xdir(1)



COPYRIGHT
     (c) 1995.  The Regents of the University of California.  All
     rights reserved.

     This work was produced at the University of California,
     Lawrence Livermore National Laboratory (UC LLNL) under con-
     tract no.  W-7405-ENG-48 (Contract 48) between the U.S.
     Department of Energy (DOE) and The Regents of the University
     of California (University) for the operation of UC LLNL.
     Copyright is reserved to the University for purposes of con-
     trolled dissemination, commercialization through formal
     licensing, or other disposition under terms of Contract 48;
     DOE policies, regulations and orders; and U.S. statutes.
     The rights of the Federal Government are reserved under Con-
     tract 48 subject to the restrictions agreed upon by the DOE
     and University.

                                DISCLAIMER

     This software was prepared as an account of work sponsored
     by an agency of the United States Government.  Neither the
     United States Government nor the University of California
     nor any of their employees, makes any warranty, express or
     implied, or assumes any liability or responsibility for the
     accuracy, completeness, or usefulness of any information,
     apparatus, product, or process disclosed, or represents that
     its specific commercial products, process, or service by
     trade name, trademark, manufacturer, or otherwise, does not
     necessarily constitute or imply its endorsement, recommenda-
     tion, or favoring by the United States Government or the
     University of California. The views and opinions of the
     authors expressed herein do not necessarily state or reflect
     those of the United States Government or the University of
     California, and shall not be used for advertising or product
     endorsement purposes.

     Permission to use, copy, modify and distribute this software
     and its documentation for any non-commercial purpose,
     without fee, is hereby granted, provided that the above
     copyright notice and this permission notice appear in all
     copies of the software and supporting documentation, and
     that all UC LLNL identification in the user interface remain
     unchanged.  The title to copyright LLNL XDIR shall at all
     times remain with The Regents of the University of Califor-
     nia and users agree to preserve same. Users seeking the
     right to make derivative works with LLNL XDIR for commercial
     purposes may obtain a license from the Lawrence Livermore
     National Laboratory's Technology Transfer Office, P.O. Box
     808, L-795, Livermore, CA 94550.






                  Last change: 23 October 1995                 20






xdir(1)                  USER COMMANDS                    xdir(1)



SEE ALSO
     ftpd(8C)


AUTHOR
          Neale G. Smith, Lawrence Livermore National Laboratory

















































                  Last change: 23 October 1995                 21



