#! /usr/bin/perl
#
# modemusage
#
# Draws a graph of used ttys over time
#
# The graph's got a line per modem which is either
# colored or empty depending on whether the tty's
# used or not.
#
# version 0.1    on Wed Nov 19 18:32:11 CET 1997
# version 0.1.1  on Mon Nov 24 16:23:33 CET 1997
# version 0.2.1  on Mon Nov 24 21:49:39 CET 1997
# version 0.3    on Fri Nov 28 20:30:21 CET 1997
# version 0.3.1  on Fri Sep 29 15:53:47 CET 2000
#                - moved to png, published on sunsite, freshmeat
# version 0.3.2  on Fri Dec  1 11:56:31 CET 2000
#                - oops, removed stale png refernces
#
# This program is (c) by T.Pospisek <tpo@spin.ch>
# under the GPL <http://www.gnu.org/copyleft/gpl.html>
#
# If ever I decide to make an update or what you'll find
# it under http://www.spin.ch/~tpo/linux/modemusage
#
# Thanks to the following persons for contributions, bugreports etc:
#
# Kelly French  - incompatibility with non-Cyclades
# Jeff Brinklow - reported bug with png support
#

use GD;

#use strict;

#
# default settings
#

# template, contains the last generated graph
# if there's no such file, modemusage will die. You have to create
# one by touching it. This must be an absolute path.
#
# no default for this
#
$template = '';

# final graph with axes drawn in it
#
# no default here
#
$grafik = '';

# y_scale streth factor (should be ok as it is)
$y_factor = 4;

# x_scale stretch factor (should be ok as it is)
$x_factor = 1;

# maximum number of monitored modems (ttys)
$n_modems = 32;

# length of x_scale in updates * stretch factor ( = number of pixels)
# an update is an event when the graph will be redrawn, evidently
# this depends on how often it is sceduled in cron
#
# 3 1/3 days * 24 (hours/day) * 60 (minutes/hour) / 5 (minutes/update)
#  = 960 updates

$x_s = 960 * $x_factor; # refresh = 300s = 5min. -> 3 1/3 days = 960

# y scale in pixels
$y_s = $n_modems * $y_factor;

#
# We need to get a list of ttys that are active.
# On my system this works follows. If you don't
# have a Cyclades serial board you probaly need
# to replace ttyC by something different like f.ex.
# ttyB for Boca or such. You might need to modify
# the cut command depending on the output of w
#
# server:~$ w -hs|fgrep ttyC|cut -b 14-17
# 1
# 2
# 4
# 5
# 6
# 8
# 12
# 10
# 0
$get_ttys="w -hs|fgrep ttyC|cut -b 14-17";

#
# Config file inclusion like in Roy Fielding's wwwstat
#
my $UconfigFile = "/etc/modemusage.cfg";
if (defined($ARGV[0]) && ($ARGV[0] eq '-f'))
{
	shift @ARGV;
	$UconfigFile = shift @ARGV;
}

if ($UconfigFile)
{
	eval 'require $UconfigFile;';
	if ($@) {
		die "Unable to read $UconfigFile: $!\n";
	}
	else { $! = 0;  undef $@; }
}

#
#
# Main
#
make_gfx();

sub make_gfx
{
    my ($im, $im_new, $x, $y, $png_data);
    my ($white, $grey, $black, $red, $blue, $green);
    my ($i, $sec, $min, $hour);

    #
    # read in template
    #
    if( -e $template) {
	open (GIF,$template) || die "modemusage : couldn\'t open $template";
	$im = newFromGif GD::Image(GIF) || die "modemusage : error 1";
	close(GIF);
    } else {
	$im = new GD::Image($x_s, $y_s);
    }
    
    # 
    # scroll image left and insert new line
    #
    ($x, $y) = $im->getBounds();
    $im_new = new GD::Image($x,$y) || die "modemusage : error 2";
    $im_new->copy($im,0,0,$x_factor,0,$x-$x_factor,$y);


    #
    # initialise colours
    #
    ($white,$grey,$black,$red,$blue,$green) = 
	(
	 $im_new->colorAllocate(255, 255, 255),
	 $im_new->colorAllocate(100, 100, 100),
	 $im_new->colorAllocate(0  , 0  , 0  ),
	 $im_new->colorAllocate(255, 0  , 0  ),
	 $im_new->colorAllocate(0  , 0  , 255),
	 $im_new->colorAllocate(0  , 255, 0  ),
	 );

    $im_new->filledRectangle($x-$x_factor,0,$x,$y,$black);

    #
    # check connections
    #
    open(TTYS, "$get_ttys|");

    while(<TTYS>) {
	chomp;
	s/\s+//;
	if( $tty{"$_"} ) { 
	    $im_new->filledRectangle( $x - $x_factor, $_ * $y_factor +1,
	                              $x, ($_ + 1) * $y_factor -1, $blue); 
	} else {
	    $im_new->filledRectangle( $x - $x_factor, $_ * $y_factor +1,
	                              $x, ($_ + 1) * $y_factor -1, $green); 
	}
    }
    #
    # x-axe
    #
    $im_new->line($x_s-$x_factor,$y_s-1,$x_s,$y_s-1,$white);
    ($sec, $min, $hour) = localtime(time);
    if( $min < 5 ) { # only odd hours
        $im_new->line($x_s, $y_s-$y_factor, $x_s, $y_s-2*$y_factor, $white);
        if( ($hour & 1) == 0) {
            $im_new->string( gdTinyFont, $x_s - 10, $y_s - 10, "$hour", $white);
        }
    }
    
    $png_data = $im_new->png;
    open (DISPLAY,'>'.$template) || die;
    print DISPLAY $png_data;
    close DISPLAY;

    #
    # draw axes
    #
    # y-axe
    #
    $im_new->line(0,0,0,$y_s,$white);
    $im_new->setStyle($red, (5) x gdTransparent);
    for($i=0; $i < $n_modems; $i++) {
        $y = $i * $y_factor;
	if( ($i & 1) == 0) { # divisible by 2
            $im_new->line( 0, $y, $x_s, $y, gdStyled);
            $im_new->string( gdTinyFont, $x_factor*2, $y, $i, $white);
        }
    }
    $png_data = $im_new->png;
    open (DISPLAY,'>'.$grafik) || die;
    print DISPLAY $png_data;
    close DISPLAY;
}

1; # --------- Do not delete this last line -----------
