
/*
 *  Copyright (C) 1999  Wolfgang Zekoll  <wzk@quietsche-entchen.de>
 *
 *  This software is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/wait.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/fcntl.h>
#include <sys/socket.h>
#include <signal.h>
#include <netdb.h>
#include <netinet/in.h>
#include <sys/time.h>

#include "lib.h"


#define	DEBUG(x)		


char	*program =		"";

int	start_program =		0;



unsigned int getport(char *string)
{
	unsigned int port;
	char	*p;

	port = strtoul(string, &p, 10);
	if (*p != 0) {
		struct servent *service;

		if ((service = getservbyname(string, "tcp")) == NULL) {
			fprintf (stderr, "%s: service not found: %s\n", program, string);
			exit (2);
			}

		port = ntohs(service->s_port);
		}

	if (port == 0) {
		fprintf (stderr, "%s: invalid port value: %s\n", program, string);
		exit (2);
		}

	return (port);
}

int openip(char *host, unsigned int port)
{
	int socketd;
	struct sockaddr_in server;
	struct hostent *hostp, *gethostbyname();

	socketd = socket(AF_INET, SOCK_STREAM, 0);
	if (socketd < 0) {
		fprintf (stderr, "%s: can't allocate new socket\n", program);
		exit (1);
		}

	server.sin_family = AF_INET;
	hostp = gethostbyname(host);
	if (hostp == NULL) {
		fprintf (stderr, "%s: can't get address: %s\n", program, host);
		exit (1);
		}
  
	memcpy(&server.sin_addr, hostp->h_addr, hostp->h_length);
	server.sin_port = htons(port);

	alarm(10);
	if (connect(socketd, (struct sockaddr *) &server, sizeof(server)) < 0) {
		fprintf (stderr, "%s: can't connect to server: %s:%u\n", program, host, port);
		exit (1);
		}

	alarm(0);
 	return (socketd);
}	

int proxy_request(char *server, unsigned int port, int timeout, int pargc, char **pargv)
{
	int	rc, sfd, bytes, pid;
	unsigned long started;
	char	buffer[4096];
	struct timeval tov;
	fd_set	connection, available;

	time((time_t *) &started); 
	pid = -1;

	sfd = openip(server, port);
DEBUG( fprintf (stderr, "connected to %s:%u\n", server, port); )
	if (sfd < 0) {
		fprintf (stderr, "%s: can't connect to server: %s:%u\n", program, server, port);
		exit (1);
		}
	else if (pargc != 0) {
		int	pin[2], pout[2];

		if (pipe(pin) != 0  ||  pipe(pout) != 0) {
			fprintf (stderr, "%s: can't create pipe\n", program);
			exit (1);
			}
		else if ((pid = fork()) == -1) {
			fprintf (stderr, "%s: can't fork client\n", program);
			exit (1);
			}
		else if (pid == 0) {
			int	fd;
			char	val[10];

			fd = dup(0);
			snprintf (val, sizeof(val) - 2, "%d", fd);
			setenv("CONNECT_STDIN", val, 1);

			fd = dup(1);
			snprintf (val, sizeof(val) - 2, "%d", fd);
			setenv("CONNECT_STDOUT", val, 1);

			dup2(pin[0], 0);
			close(pin[1]);

			dup2(pout[1], 1);
			close(pout[0]);
			
			execvp(pargv[0], pargv);
			fprintf (stderr, "%s: can't exec %s\n", program, pargv[0]);
			exit (1);
			}
		else {
			dup2(pin[1], 1);
			close(pin[0]);
			close(pin[1]);

			dup2(pout[0], 0);
			close(pout[1]);
			close(pout[0]);
			}
		}

	FD_ZERO(&connection);
	FD_SET(0, &connection);
	FD_SET(sfd, &connection);

	while (1) {
		memmove(&available, &connection, sizeof(fd_set));
		tov.tv_sec  = timeout;
		tov.tv_usec = 0;

		rc = select(sfd + 1, &available, (fd_set *) NULL, (fd_set *) NULL, &tov);
		if (rc < 0) {
			fprintf (stderr, "%s: select() error\n", program);
			break;
			}
		else if (rc == 0) {
			fprintf (stderr, "%s: connection timed out: %s:%u\n", program, server, port);
			break;
			}

		if (FD_ISSET(sfd, &available)) {
			if ((bytes = read(sfd, buffer, sizeof(buffer))) <= 0) {
				close(1);
				break;
				}
			else if (write(1, buffer, bytes) != bytes) {
				close (1);
				close (sfd);
				break;
				}
			}

		if (FD_ISSET(0, &available)) {
			if ((bytes = read(0, buffer, sizeof(buffer))) <= 0)
				shutdown(sfd, 1);	
			else if (write(sfd, buffer, bytes) != bytes)
				break;
			}
		}

	rc = 0;
	if (pid > 0) {
		close (0);
		close (1);

		wait(&rc);
DEBUG( fprintf (stderr, "rc= %04X\n", rc); )
		rc = WEXITSTATUS(rc);
		}

	return (rc);
}


void missing_arg(int c, char *string)
{
	fprintf (stderr, "%s: missing arg: -%c, %s\n", program, c, string);
	exit (-1);
}

int main(int argc, char *argv[])
{
	int	c, i, k, timeout, rc, pargc;
	unsigned int port;
	char	*p, option[80], **pargv, server[200];
	
	program = argv[0];
	
	timeout = 60;
	port    = 0;
	pargc   = 0;
	pargv   = NULL;

	k = 1;
	while (k < argc  &&  argv[k][0] == '-'  &&  argv[k][1] != 0) {
		copy_string(option, argv[k++], sizeof(option));
		for (i=1; (c = option[i]) != 0; i++) {
			if (c == 'p')
				start_program = 1;
			else if (c == 't') {
				if (k >= argc)
					missing_arg(c, "timeout");

				timeout = atoi(argv[k++]);
				if (timeout < 1)
					timeout = 60;
				}
			else {
				fprintf (stderr, "%s: unknown option: -%c\n", program, c);
				exit (-1);
				}
			}
		}


	if (k >= argc) {
		fprintf (stderr, "usage: %s [options] <server>[:<port>]\n", program);
		exit (-1);
		}

	copy_string(server, argv[k++], sizeof(server));
	if ((p = strchr(server, ':')) != NULL) {
		*p++ = 0;
		port = getport(p);
		}
	else if (k < argc)
		port = getport(argv[k++]);

	if (start_program != 0) {
		if (k >= argc) {
			fprintf (stderr, "%s: missing program specification\n", program);
			exit (1);
			}

		pargv = &argv[k];
		pargc = argc - k;
		}
	else if (k < argc) {
		fprintf (stderr, "%s: extra arguments on command line\n", program);
		exit (1);
		}


	if (port == 0) {
		fprintf (stderr, "%s: no port\n", program);
		exit (-1);
		}
		
	rc = proxy_request(server, port, timeout, pargc, pargv);
DEBUG( fprintf (stderr, "rc= %04X\n", rc); )
	exit (rc);
}


