/* [ NETSCRIPT: basic ANSi module -- for version 1.6.4+ ] ********************
 * this module simply incorporates an ansi interface into netscript's        *
 * console display. (must use -DGTK to function correctly, if compiled for   *
 * gui.  also, needs -rdynamic from netscript compile)                       *
 *                                                                           *
 * COMPILE:                                                                  *
 *  # cc nsansi.c -o nsansi -shared                                          * 
 *  # cc nsansi.c -o nsansi -shared -DGTK                                    * 
 *                                                                           *
 * USE:                                                                      *
 *  # export NS_MODULE=/path/to/nsansi                                       *
 *                                                                           *
 * nsansi.c: module source code for nsansi.                (149l!324w!4006b) *
 *****************************************************************************/
#include <stdio.h>
#define GRN "\033[0;32m"
#define CYN "\033[0;36m"
#define BGRN "\033[1;32m"
#define BCYN "\033[1;36m"
#define WHT "\033[1;37m"
#define BGRY "\033[0;37m"
#define GRY "\033[1;30m"
#define NRM "\033[0m"
#define ANRM CYN
unsigned short alreadyansi=0;
unsigned short rnosrecv=0;
unsigned short rnossend=0;
#ifdef GTK
extern unsigned short isgui;
#endif
extern unsigned short isbga;
extern unsigned short nosrecv;
extern unsigned short nossend;
extern int columns;
void local_dumpdata(char *line,int size){
 int i=0;
 while(size>i){
  if(i==0||size==(i+1))
   printf("%s",GRY);
  else if(i==1||size==(i+2))
   printf("%s",BGRY);
  else if(i==2||size==(i+3))
   printf("%s",WHT);
  printf("%c",line[i++]);
 }
 printf("%s\n",ANRM);
 return;
}
void ns_init(){
 printf("%s[%s basic %sA%sN%sS%si%s module initialized.  will apply effects ac"
 "cordingly. %s]%s\n",NRM,WHT,CYN,BCYN,BGRN,GRN,WHT,NRM,ANRM);
 return;
}
void ns_exit(){
 fprintf(stderr,"%s",NRM);
 return;
}
void ns_connect(){
 if(!alreadyansi){
  rnosrecv=nosrecv;
  rnossend=nossend;
#ifdef GTK
  if(isgui)
   rnossend=rnosrecv=1;
  else
#endif
   nossend=nosrecv=1;
  alreadyansi=1;
 }
 return;
}
void ns_incoming(char *line,int size){
 int i=0;
 int j=0;
 char tmpline[(columns-4+1)];
 bzero(tmpline,sizeof(tmpline));
 if(rnosrecv||isbga)
  return;
 while(size>i){
  tmpline[j++]=line[i++];
  if(j>=(columns-4)){
   tmpline[j]=0x0;
   if(i>=size)
    printf("%s<%s<%s<%s ",WHT,BCYN,CYN,ANRM);
   else if(i==j)
    printf("%s<%s-%s.%s ",WHT,BCYN,CYN,ANRM);
   else if(i>=size)
    printf("%s<%s-%s'%s ",WHT,BCYN,CYN,ANRM);
   else
    printf("  %s|%s ",CYN,ANRM);
   local_dumpdata(tmpline,strlen(tmpline));
   bzero(tmpline,sizeof(tmpline));
   j=0;
  }
  if(i>=size){
   if(j){
    if(i==j)
     printf("%s<%s<%s<%s ",WHT,BCYN,CYN,ANRM);
    else
     printf("%s<%s-%s'%s ",WHT,BCYN,CYN,ANRM);
    tmpline[j]=0x0;
    local_dumpdata(tmpline,strlen(tmpline));
   }
   j=0;
  }
 }
 return;
}
/* unused for this module. */
void ns_incoming_char(){}
/* unused for this module. */
void ns_incoming_raw(){}
void ns_outgoing(char *line,int size){
 int i=0;
 int j=0;
 char tmpline[(columns-4+1)];
 if((size==1&&line[0]==0x0A)||rnossend||isbga)
  return;
 bzero(tmpline,sizeof(tmpline));
 while(size>i){
  tmpline[j++]=line[i++];
  if(j>=(columns-4)){
   tmpline[j]=0x0;
   if(i>=size)
    printf("%s>%s>%s>%s ",GRN,BGRN,WHT,ANRM);
   else if(i==j)
    printf("%s.%s-%s>%s ",GRN,BGRN,WHT,ANRM);
   else if(i>=size)
    printf("%s`%s-%s>%s ",GRN,BGRN,WHT,ANRM);
   else
    printf("%s|%s   ",GRN,ANRM);
   local_dumpdata(tmpline,strlen(tmpline));
   bzero(tmpline,sizeof(tmpline));
   j=0;
  }
  if(i>=size){
   if(j){
    if(i==j)
     printf("%s>%s>%s>%s ",GRN,BGRN,WHT,ANRM);
    else
     printf("%s`%s-%s>%s ",GRN,BGRN,WHT,ANRM);
    tmpline[j]=0x0;
    local_dumpdata(tmpline,strlen(tmpline));
   }
   j=0;
  }
 }
 return;
}
