/* $Id: usage.c,v 1.1 1998/08/01 16:03:14 dg8xt Exp $ */

#include <stdio.h>
#include "global.h"
#include "version.h"

extern char progname[];

int usage()
{
   printf("\n%s %s\n\n", progname, VERSION);
   printf("Usage: %s [opt] <search-string>\n\n", progname);
   puts("Options: -?  this message");
   puts("         -I  Information (long help)");
   puts("         -v  Version\n");
   puts("         -w  HTML output");
   puts("         -s <server> Server to request");
   printf("         -p <port>   optional port if not using the default %i\n\n", DEFAUT_PORT);
   return (2);
}

int usage_long()
{
   printf("\n%s %s Copyright (C) 1998 by Thomas Weinell <dg8xt@db0hht.ampr.org>\n\n", progname, VERSION);
   puts("Description: Search for files located in /pub at localhost or at remote-host.");
   puts("             There are minimal 2 characters required for the search-string");
   puts("             and the first character must be an alphanumeric.");
   puts("             The query is case insensitive.\n");
   printf("Usage: %s [opt] <search-string>\n\n", progname);
   puts("  Options: -?  short help");
   puts("           -I  this message");
   puts("           -v  print version\n");
   puts("           -w  force HTML-output");
   puts("           -s <server>  remote-host for request");
   puts("           -p <port>    port at remote-host (only need, if not default 7001)\n");
   puts("Examples:\n");
   printf("  %s hamradio\n", progname);
   puts("      search for 'hamradio' local\n");
   printf("  %s -s db0hht.ampr.org wampes\n", progname);
   puts("      search for 'wampes' at host db0hht.ampr.org\n");
   printf("  %s -w -p 1234 -s db0zwi-svr.ampr.org linux\n", progname);
   puts("      search for 'linux' at host db0zwi-svr.ampr.org");
   puts("      using port 1234 and HTML-output\n");
   return (2);
}

