/* $Id: psearchd.c,v 1.2 1998/09/06 18:58:12 dg8xt Exp $ */

/*
 * PSEARCHD is Copyright (C) 1998 by Thomas Weinell <dg8xt@db0hht.ampr.org>
 *
 * PSEARCHD is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; version 2 dated June, 1991
 *
 * PSEARCHD is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PSEARCHD; see the file COPYING.  If not, write to the Free
 * Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * psearchd is no standalone daemon. use it within tcpd.
 * i e. inetd.conf:
 * psearch stream  tcp     nowait  nobody  /usr/sbin/tcpd  /usr/local/sbin/psearchd
 * i.e. services:
 * psearch         7001/tcp
*/

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/wait.h>
#include "psearchd.h"

int main(void)
{
   char command[6];
   char hostname[255];
   char line[1024];
   char opt[3];
   char *buf;
   int stat;
   int pid=0;
         
   gethostname(hostname, sizeof(hostname));

   printf("100 - %s ready\n", hostname);
   fflush(stdout);

   fgets(line, 1024, stdin);
   strncpy(command, line, 5);
   command[5]=0;

   if (strcmp(command, "prog ") == 0) 
   {
      buf=strchr(line, ' ')+1;
      if( strncmp(buf, "-w", 2) ==0) {
         strcpy(opt, "-w");
         buf=strrchr(line, ' ')+1;
      }
      buf[(strlen(buf)-2)]=0;	/* strip "\r\n" */

      puts("220 - prog OK");
      fflush(stdout);

      switch(pid = fork()) {
         case -1: perror("fork");
         exit (1);
         case 0: execlp(PSEARCH_PROG, PSEARCH_PROG, opt, buf, (char *) 0);
         perror("execl");
         exit(1);
         default: wait(&stat);
      }
      exit (0);
   } 

   if (strncmp(command, "help",4) == 0) 
   {
      puts("100 - This server accepts the following commands:\n");
      puts("100 - prog <partial filename>     search for <partial filename>");
      puts("100 - help                        this text");
      puts("100 - quit                        quit\n");
      fflush(stdout);
      exit (0);
   } 
   
   if (strncmp(command, "quit",4) == 0)
      exit (0);
   
   puts("500 - command unrecognized.");
   fflush(stdout);
   exit (0);
}

