/*
 * $Id: admin.c,v 1.2 1996/09/15 11:36:36 lf Exp $
 *
 * Copyright (C) 1996 Lars Fenneberg
 *
 * See the file COPYRIGHT for the respective terms and conditions. 
 * If the file is missing contact me at lf@elemental.net 
 * and I'll send you a copy.
 *
 */

#include <syslog.h>
#include <string.h>
#include <ctype.h>
#include <stdarg.h>

#include <sys/types.h>

#include "config.h"
#include "radius.h"
#include "messages.h"
#include "radlogin.h"
#include "admin.h"

static const COMMAND *find_command(char *commandname)
{
        int i;
        
        /* there're so few options that a binary search seems not necessary */
        for (i = 0; i < num_commands; i++) {
		if (!strcmp(commands[i].name, commandname))
         		return &commands[i];
	}

	return NULL;
}

static void print_status(int i, char *format, ...)
{
       char buff[4096];
       va_list ap;
                                   
       va_start(ap,format);
       vsnprintf(buff, sizeof(buff), format, ap);
       va_end(ap);
                      
       printf("%d %s\r\n", i, buff);                                     
}

static int command_quit(char *args)
{
	print_status(221,"closing connection");
	
	return 1;
}

static int command_set(char *args)
{
	char *name, *value;
	int pos;

	if ((pos = strcspn(args, "\t ")) == strlen(args)) {
		print_status(501, "arguments missing");
		return 0;
	} else {
		args[pos] = '\0';
		name = args;
		args += pos + 1;
			
		while (isspace(*args))
			args++;
				
		value = args;
	}

	if (rc_conf_set("", 0, name, value) < 0)
		print_status(501, "syntax error");
	else
		print_status(250, "OK");

	return 0;
}

static int command_save(char *args)
{
	if (rc_conf_save() < 0) {
		print_status(502, "error while saving options");
	} else {
		print_status(250, "saved");
	}

	return 0;
}

void admin_login(char *username)
{
	char *buf, *p, *command, *args;
	int pos, len;
	const COMMAND *cfunc;

	print_status(220,"entering administrative mode");
	
	while ((buf = rc_getstr("", 1)) != NULL) {

		p = buf;
		
		if ((*p == '#') || (*p == '\0'))
			continue;
		
		len = strlen(p);
		
		if ((pos = strcspn(p, "\t ")) == len) {
			command = p;
			args = NULL;
		} else {
			p[pos] = '\0';
			command = p;
			p += pos + 1;
			
			while (isspace(*p))
				p++;
				
			args = p;
		}
		
		if ((cfunc = find_command(command)) == NULL) {
			print_status(500, "unknown command: %s", command);
			continue;
		} 
		 	
		if ((cfunc->func)(args) != 0) {
			/* quit requested: we must terminate on the spot
			 * because we're not supposed to return
			 */
			 exit(0);
		}
	}
}
