/* System dependent functions. Change this file if the code should be
   ported to a different type of machine.
*/

#ifndef unix
#ifndef AMIGA
#include <conio.h>
#else
#include <proto/dos.h>
#include <stdlib.h> /* exit */
#include <ctype.h> /* toupper */
void tifont(void);			/* set font */
#endif
#include <dos.h>
#else
#include <ctype.h> /* toupper */
#include <sys/ioctl.h>
#include <linux/kd.h>
#include <signal.h>
#define delay usleep

int kbhit()
{
struct termio cb,cb0;
int key;

ioctl(_IOC_READ, TCGETA, &cb);
cb0=cb;
cb.c_lflag&=~(ICANON|ECHO);
cb.c_cc[VMIN]=cb.c_cc[VTIME]='\0';
ioctl(_IOC_READ, TCSETA, &cb);
ungetc(key=getchar(),stdin);
ioctl(_IOC_READ, TCSETA, &cb0);
return key!=EOF;
}

void sound(long tone)
{
        signal(SIGINT,SIG_IGN);
        signal(SIGQUIT,SIG_IGN);
        if(ioctl(0,KIOCSOUND,tone)==-1)
                perror("kiocsound");
        signal(SIGINT,SIG_DFL);
        signal(SIGQUIT,SIG_DFL);
}

void nosound()
{
        sound(0);
}
#endif

void no_interrupts(void);		/* disable interrupts */
void wait_for_keypress(void);		/* wait for keyboard hit */
void clear_screen(void);		/* clear the screen */
void goto_xy(int x,int y);		/* move cursor to (x,y) */
void print_at(int x,int y,int code);	/* print code at (x,y)	*/
int current_xpos(void);			/* returns x of cursorpos */
int current_ypos(void);			/* returns y of cursorpos */
void mysound(word);			/* sound chip emulation */

#define BINARY_READ_MODE "r+b"	/* DOS type binary read */
#ifndef AMIGA
#ifndef unix
#define KBHIT kbhit()
#define GETKEY getch()
#else
#ifdef AMIGA
char __stdiowin[] = "raw://304/208/TI-99\\4A/NOSIZE/NOCLOSE";
#define KBHIT WaitForChar(Input(),1)
#define disable()
#else
#define KBHIT kbhit()
#endif
#define GETKEY getchar()
#define putch(c) putchar(c)
#define ungetch(c) ungetc((c),stdin)
#define gotoxy(x,y) putchar('\033');putchar('[');putchar('0'+y/10);putchar('0'+y%10);putchar(';');putchar('0'+x/10);putchar('0'+x%10);putchar('H')
#define clrscr() putchar('\033');putchar('[');putchar('H');putchar('\033');putchar('[');putchar('J');
#define wherex() 0
#define wherey() 0
#define cprintf printf
#define disable()
#endif
#endif

void no_interrupts(void)
{
	disable();
}

void wait_for_keypress(void)
{
	while(!KBHIT);
}

void clear_screen(void)
{
	clrscr();
}

void goto_xy(int x,int y)
{
	gotoxy(x,y);
}

void print_at(int x,int y,int c)
{
	gotoxy(x,y);
	putch(c);
}

int current_xpos(void)
{
	return(wherex());
}

int current_ypos(void)
{
	return(wherey());
}

void my_sound(word freq)
{
#ifndef AMIGA
	sound(freq);
	delay(500);
	nosound();
#else
	putchar('\a');
#endif
}
