/**
 **	Instruction bodies.
 **
 **/

void SRA()
{
	typeVoperands();
	if (DestVal>1) SourceVal=(signed int)SourceVal>>(DestVal-1);
	CY=SourceVal&1;
	SourceVal=(signed int)SourceVal>>1;
	set_status(SourceVal);
	memory_write(SourceOpAdr,SourceVal);
}

void SRL()
{
	typeVoperands();
	if (DestVal>1) SourceVal>>=DestVal-1;
	CY=SourceVal&1;
	SourceVal>>=1;
	set_status(SourceVal);
	memory_write(SourceOpAdr,SourceVal);
}

void SLA()
{
	typeVoperands();
	OV=((((signed int)0x8000>>DestVal) &SourceVal)!=0);
	if (DestVal>1) SourceVal<<=DestVal-1;
	CY=((SourceVal&0x8000)!=0);
	SourceVal<<=1;
	set_status(SourceVal);
	memory_write(SourceOpAdr,SourceVal);
}

void SRC()
{
	typeVoperands();
	SourceVal=(word)(SourceVal>>DestVal)|(SourceVal<<(16-DestVal));
	CY=((SourceVal&0x8000)!=0);
	set_status(SourceVal);
	memory_write(SourceOpAdr,SourceVal);
}

void SZC()
{
	typeIoperands();
	DestVal&=~SourceVal;
	set_status(DestVal);
	memory_write(DestOpAdr,DestVal);
}

void SZCB()
{
	typeIoperands();
	DestVal&=(~SourceVal|0xFF);
	set_status(DestVal&0xFF00);
	set_parity(DestVal);
	memory_write(DestOpAdr,DestVal);
}

void S()
{
	typeIoperands();
	DestVal=add(DestVal,1+~SourceVal);
	set_status(DestVal);
	memory_write(DestOpAdr,DestVal);
}

void SB()
{
	typeIoperands();
	DestVal=(DestVal&0xFF)|add(DestVal&0xFF00,1+~(SourceVal&0xFF00));
	set_status(DestVal&0xFF00);
	set_parity(DestVal);
	memory_write(DestOpAdr,DestVal);
}

void C()
{
	typeIoperands();
	compare(SourceVal,DestVal);
}

void CB()
{
	typeIoperands();
	compare(SourceVal&0xFF00,DestVal&0xFF00);
	set_parity(SourceVal);
}

void A()
{
	typeIoperands();
	DestVal=add(SourceVal,DestVal);
	set_status(DestVal);
	memory_write(DestOpAdr,DestVal);
}

void AB()
{
	typeIoperands();
	SourceVal=add(SourceVal&0xFF00,DestVal&0xFF00);
	set_status(SourceVal&0xFF00);
	set_parity(SourceVal);
	memory_write(DestOpAdr,(SourceVal&0xFF00)|(DestVal&0xFF));
}

void MOV()
{
	typeIoperands();
	set_status(SourceVal);
	memory_write(DestOpAdr,SourceVal);
}

void MOVB()
{
	typeIoperands();
	set_status(SourceVal&0xFF00);
	set_parity(SourceVal);
	memory_write(DestOpAdr,(SourceVal&0xFF00)|(DestVal&0xFF));
}

void SOC()
{
	typeIoperands();
	DestVal|=SourceVal;
	set_status(DestVal);
	memory_write(DestOpAdr,DestVal);
}

void SOCB()
{
	typeIoperands();
	DestVal|=SourceVal&0xFF00;
	set_status(DestVal&0xFF00);
	set_parity(DestVal);
	memory_write(DestOpAdr,DestVal);
}

void do_jump(void)
{
	PC+=(IR&0xFF)<<1;
	if (IR&0x0080) PC-=0x200;
}

void JMP() { 				do_jump(); }
void JLT() { if (AGT==0 && EQ==0) 	do_jump(); }
void JLE() { if (LGT==FALSE || EQ==1) 	do_jump(); }
void JEQ() { if (EQ==1) 		do_jump(); }
void JHE() { if (LGT==1 || EQ==1) 	do_jump(); }
void JGT() { if (AGT==1) 		do_jump(); }
void JNE() { if (EQ==0) 		do_jump(); }
void JNC() { if (CY==0) 		do_jump(); }
void JOC() { if (CY==1) 		do_jump(); }
void JNO() { if (OV==0) 		do_jump(); }
void JL()  { if (LGT==0 && EQ==0) 	do_jump(); }
void JH()  { if (LGT==1) 		do_jump(); }
void JOP() { if (OP==1) 		do_jump(); }

void SBO()
{
	if (PC==0x2BE) KSCAN(); /* truc: detecteer kscan */
}

void SBZ() {}
void TB() { EQ=0; }

void COC()
{
	typeIIIoperands();
	EQ=( (SourceVal&~DestVal)==0 );
}

void CZC()
{
	typeIIIoperands();
	EQ=( (SourceVal&DestVal)==0 );
}

void XOR()
{
	typeIIIoperands();
	DestVal^=SourceVal;
	set_status(DestVal);
	memory_write(DestOpAdr,DestVal);
}

void XOP()
{
	word oldwp,oldpc;
	typeIVoperands();
	oldwp=WP;
	oldpc=PC;
	WP=memory_read(0x40+(DestVal<<2));
	PC=memory_read(0x42+(DestVal<<2));
	memory_write(R11,SourceVal);
	memory_write(R13,oldwp);
	memory_write(R14,oldpc);
	get_status();
	memory_write(R15,STATUS);
	X=1;
}

void LDCR()
{
	EQ=0;
	typeIVoperands();
	if (PC==0x4ba) /* CLEAR-tastaturabfrage */
	{
		EQ=0;
		if (KBHIT)
		{
			int key;
			key=GETKEY;
			if (key!=0) ungetch(key);
			else EQ=(GETKEY==62);	/* F4 */
		}
		PC=0x4dc;
	}
/*	else set_status(SourceVal); */
}

void STCR()
{
	typeIVoperands();
	memory_write(SourceOpAdr,0xFFFF);
	set_status(SourceVal);
}

void MPY()
{
	unsigned long int m;
	typeIIIoperands();
	m=(unsigned long int)SourceVal*(unsigned long int)DestVal;
	memory_write(DestOpAdr,(word)(m>>16));
	memory_write(DestOpAdr+2,(word)(m&0xFFFF));
}

void DIV()
{
	unsigned long int m;
	typeIIIoperands();
	m=((unsigned long int)(DestVal)<<16)+
	  (unsigned long int)memory_read(DestOpAdr+2);
	OV=(SourceVal<=DestVal);
	if ((SourceVal)&&!OV)
	{
		memory_write(DestOpAdr,(word)(m/SourceVal));
		memory_write(DestOpAdr+2,(word)(m%SourceVal));
	}
}

void LI()
{
	typeVIIIoperands();
	memory_write(SourceOpAdr,DestVal);
	set_status(DestVal);
}

void AI()
{
	typeVIIIoperands();
	DestVal=add(SourceVal,DestVal);
	memory_write(SourceOpAdr,DestVal);
	set_status(DestVal);
}

void ANDI()
{
	typeVIIIoperands();
	DestVal&=SourceVal;
	memory_write(SourceOpAdr,DestVal);
	set_status(DestVal);
}

void ORI()
{
	typeVIIIoperands();
	DestVal|=SourceVal;
	memory_write(SourceOpAdr,DestVal);
	set_status(DestVal);
}

void CI()
{
	typeVIIIoperands();
	compare(SourceVal,DestVal);
}

void STWP()
{
	typeIXoperands();
	memory_write(SourceOpAdr,WP);
}

void STST()
{
	typeIXoperands();
	get_status();
	memory_write(SourceOpAdr,STATUS);
}

void LWPI()
{
	typeXoperands();
	WP=SourceVal;
}

void LIMI()
{
	static int intcounter=0;
	typeXoperands();
	IMASK=SourceVal&0xF;
	if ((IMASK)&&(intcounter++==CURSOR_SPEED))
	{
		intcounter=0;
		vdp_interrupt();		/* Fake interrupt! */
	}
}

void RTWP()
{
	PC=	memory_read(R14);
	STATUS=	memory_read(R15);
	WP=	memory_read(R13);
}

void BLWP()
{
	word oldwp;
	typeVIoperands();
	oldwp=WP;
	WP=SourceVal;			/* get new workspace */
	memory_write(R13,oldwp);        /* store old WP in new R13 */
	memory_write(R14,PC);		/* store old PC in new R14 */
	memory_write(R15,STATUS);	/* store old STATUS in R15 */
	PC=memory_read(SourceOpAdr+2);	/* get new PC :-) */
}

void B()
{
	typeVIoperands();
	PC=SourceOpAdr;
}

void eX()
{
	typeVIoperands();
	IR=SourceVal;
        (*opcode_table[IR>>8])();	/* execute instruction */
}

void CLR()
{
	typeVIoperands();
	memory_write(SourceOpAdr,0);
}

void NEG()
{
        typeVIoperands();
	DestVal=add(~SourceVal,1);
	set_status(DestVal);
	memory_write(SourceOpAdr,DestVal);
}

void INV()
{
	typeVIoperands();
	DestVal=~SourceVal;
	set_status(DestVal);
	memory_write(SourceOpAdr,DestVal);
}

void INC()
{
	typeVIoperands();
	DestVal=add(SourceVal,1);
	set_status(DestVal);
	memory_write(SourceOpAdr,DestVal);
}

void INCT()
{
	typeVIoperands();
	DestVal=add(SourceVal,2);
	set_status(DestVal);
	memory_write(SourceOpAdr,DestVal);
}

void DEC()
{
	typeVIoperands();
	DestVal=add(SourceVal,0xFFFF);
	set_status(DestVal);
	memory_write(SourceOpAdr,DestVal);
}

void DECT()
{
	typeVIoperands();
	DestVal=add(SourceVal,0xFFFE);
	set_status(DestVal);
	memory_write(SourceOpAdr,DestVal);
}

void BL()
{
	typeVIoperands();
	memory_write(R11,PC);
	PC=SourceOpAdr;
}

void SWPB()
{
	typeVIoperands();
	SourceVal=((SourceVal&0xFF)<<8) | (SourceVal>>8);
	memory_write(SourceOpAdr,SourceVal);
}

void SETO()
{
	typeVIoperands();
	memory_write(SourceOpAdr,0xFFFF);
}

void ABS()
{
	typeVIoperands();
	set_status(SourceVal);
	OV=(SourceVal==0x8000);
	if (SourceVal&0x8000) SourceVal=~SourceVal+1;
	memory_write(SourceOpAdr,SourceVal);
}

void ILL()
{
	printf("\nIllegal opcode %04x at address >%04x\n",IR,PC-2);
	printf("GROM=>%04x, VDP=>%04x\n",GromAddressCounter,VdpAddressCounter);
	exit(0);
}
