/* Boot section of the TI-99/4A emulator */

void load_roms(char configname[])
{
FILE *infile;
char line[80],filename[15],memtype;
int base,skip,length;

paging=FALSE;

if ((infile=fopen(configname,"r"))==NULL)
{
	printf("Could not open '%s', ",configname);
	printf("configuring standard TI-99/4A\n");
	load_byte_memory_from_file(grom,0x0000,"grom0.bin",0,0x1800);
	load_byte_memory_from_file(grom,0x2000,"grom1.bin",0,0x1800);
	load_byte_memory_from_file(grom,0x4000,"grom2.bin",0,0x1800);
	load_word_memory_from_file(mem,0x0000,"rom.bin",0,0x2000);
	load_word_memory_from_file(mem,0x4000,"diskrom.bin",0,0x100);

}
else
{
	printf("Parsing %s:\n",configname);
	while(!feof(infile))
	{
		if(fgets(line,80,infile)!=NULL)
		if ((line[0]!='*')&&(line[0]!=' ')&&(strlen(line)>8))
		{
			if(sscanf(line,"%s %c %x %x %x",filename,
			&memtype,&base,&skip,&length)!=5)
			printf("\n\nSYNTAX ERROR in '%s'\n>>> %s <<<\n",
			configname,line);
			else
			{
if (memtype=='G') load_byte_memory_from_file(grom,base,filename,skip,length);
if (memtype=='C') load_word_memory_from_file(mem,base,filename,skip,length);
if (memtype=='S') {
		  word i;
		  load_word_memory_from_file(mem,base,filename,skip,length);
		  printf(" (Swapping bytes)");
		  for(i=0;i<length/2;i++)
		  *(mem+base/2+i)=(*(mem+base/2+i)<<8)|(*(mem+base/2+i)>>8);
		  }
			}
		}
	}
}
}

void load_byte_memory_from_file(
byte *memtype,
word base,
char filename[],
word skip,
word length)
{
	int i;
	FILE *infile;
	infile=fopen(filename,BINARY_READ_MODE);
	if (infile==NULL)
	{
		printf("\nUnable to load '%s', aborting.\n",filename);
		exit(0);
	}
	else printf("\nLoading '%s'",filename/*,base*/);
	if (skip) for(i=0;i<skip;i++) fgetc(infile);
	fread(memtype+base,1,length,infile);
	fclose(infile);
}

void load_word_memory_from_file(
word *memtype,
word base,
char filename[],
word skip,
word length)
{
	int i;
	FILE *infile;
	infile=fopen(filename,BINARY_READ_MODE);
	if (infile==NULL)
	{
		printf("\nUnable to load '%s', aborting.\n",filename);
		exit(0);
	}
	else printf("\nLoading '%s'",filename);
	if (skip) for(i=0;i<skip;i++) fgetc(infile);

	fread(memtype+(base/2),2,length/2,infile);
	fclose(infile);
	if (base==0x9000)
	{
		paging=TRUE;
		printf("\n>7000->7FFF paging enabled.");
	}
}
