#!/usr/bin/perl

# generate a usage chart
# Copr. 1997 Chris Nott (c.nott@student.canberra.edu.au)

require 5.003;
use GD;
require 'getopts.pl';
require 'date.pl';
require 'cgi-lib.pl';

$LOGDIR = '/usr/local/etc/usagelogs';

sub webdie ($) {
	print "Content-Type: text/plain\n\n" if($web);
	print $_[0]."\n";
	exit(-1);
}

my ($day,$datestr,@args,$tty,@tty,$logs,$avg,$totalavg,@access);
my ($weekly,$monthly,$plot,$web,$debug,$help,$numdays,$days);

# start of code

$debug = 0;
if(@ARGV>0) {
	Getopts('t:d:wmpDh');
	$weekly = 1	if($opt_w);
	$monthly = 1	if($opt_m);
	$plot = 1	if($opt_p);
	$debug = 1	if($opt_D);
	$help = 1	if($opt_h);
	$web = 0;

	$tty = $opt_t;
	$datestr = $opt_d;
	if(!$tty || $help) {
		die "usage: call with dailyusage.pl [-wmpD] -t <tty> [-d <date>]";
	}
} else {
	&ReadParse(*args);
	if(!$args{tty}) {
		$web = 1;
		webdie "usage: call with dailyusage.pl?tty=<tty>[&day=<day>]";
	}
	$weekly = 1	if($args{weekly});
	$monthly = 1	if($args{monthly});
#	$debug = 1	if($args{debug});
	$plot = 1;
	$web = 1;

	$tty = $args{tty};
	$datestr = $args{date};
}
if($weekly && $monthly) {
	webdie "error can't generate weekly _and_ montly report";
}

if($datestr) {
	($day,$datestr) = parsedate($datestr);
	webdie "error parsing date" if($day == -1);
} else {
	($day,$datestr) = getday();
}

$numdays = 1;
if($weekly) {
	($day,$datestr) = getweek($day);
	$numdays = 7;
}
if($monthly) {
	($day,$numdays,$datestr) = getmonth($day);
}

# print STDERR "($day)$datestr\n";

if($tty =~ /,/) {
	@tty = split(/,/,$tty);
} else {
	@tty = ($tty);
}

if($debug) {
	print STDERR "weekly usage\n" if($weekly);
	print STDERR "monthly usage\n" if($monthly);
	print STDERR "number of days: $numdays\n";
}

$logs = 0;
$totalavg = 0;
for($i=0; $i<24; $i++) {
	$access[$i] = 0;
}
foreach $t (@tty) {
	if(open USAGELOG,$LOGDIR."/usage.$t") {
		$logs++;
		$days = 0;
		$avg = 0;

		while(<USAGELOG>) {
			if(/^([0-9]*):/) {
				my $cday = $1;

				if($cday >= $day && $cday < ($day + $numdays)) {
					s/^[0-9]*://;	# remove day bit
					# @access is the number of minutes used for a given hour
					$days++;
					for($i=0; $i<24; $i++) {
						my $v;
						
						if(!s/^[ ]*([0-9]*)//) {
							webdie "out of usage arguments in usage.$tty";
						}
						$v = ($1 * 10) / 6;
						$access[$i] += $v;
						$avg += $v;
					}
				}
			}
		}
		$avg /= 24 * $numdays;
		printf STDERR "average for %s: %0.1f%% (%.0f days)\n",$t,$avg,$days if($debug);
		$totalavg += $avg;
	} elsif($debug) {
		print STDERR $LOGDIR."/usage.$t: $!\n";
	}
	close(USAGELOG);
}

if($logs) {
	$totalavg /= $logs;
} else {
	$avg = 0;
}
if($debug) {
	print STDERR "----------------------------\n";
	printf STDERR "total average: %0.1f%%\n",$totalavg;
}

# 'renormalise' :)
if($logs) {
	for($i=0; $i<24; $i++) {
		$access[$i] /= ($logs * $numdays);
	}
}

if($plot) {
	plot(\@access,"Daily Usage $datestr","red") if(!$weekly && !$monthly);
	plot(\@access,"Weekly Usage $datestr","green") if($weekly);
	plot(\@access,"Monthly Usage $datestr","blue") if($monthly);
}
exit;


# plot a graph
# call with:
#	plot(\@data,$title,$colour);
# where		\@data is a reference to an array of percentile (0-100) numbers
sub plot {
	my $data = shift or webdie "plot: wrong number of arguments";
	my $title = shift or $title = "Graph";
	my $colour = shift or $colour = "red";
	my @d = @{$data};

# aargh
	my ($colwid,$barsiz,$columns,$border,$bwid,$fontwid,$fonthgt,$size);
	my ($plotsize,$white,$black,$red,$blue,$im,$colstart,$ticpos,$ticlen);
	my ($textpos,$timestring,$barbot,$height,$plotcolour);

	$colwid = 12;	# total column width
	$barsiz = 0.6;	# relative width of columns
	$columns = scalar(@d);	# number of columns
	$border = 60;	# border whitespace
	$bwid = 1;		# border line width
	$fontwid = 6;	# font character width
	$fonthgt = 12;	# font height
	$size = $columns*$colwid + ($border+$bwid)*2;
	$plotsize = $size - 2*($border + $bwid);
	
	$im = new GD::Image($size,$size);

	# allocate some colors
	$white = $im->colorAllocate(255,255,255);
	$black = $im->colorAllocate(0,0,0);
	$red = $im->colorAllocate(255,0,0);
	$green = $im->colorAllocate(0,255,0);
	$blue = $im->colorAllocate(0,0,255);

	$plotcolour = $black;
	$plotcolour = $red 		if(lc($colour) eq "red");
	$plotcolour = $green 	if(lc($colour) eq "green");
	$plotcolour = $blue 	if(lc($colour) eq "blue");

	# make the background transparent and interlaced
	$im->transparent($white);
	$im->interlaced('true');

	# Put a black frame around the picture
	$im->rectangle($border,$border,$size-$border,$size-$border,$black);

	for($i=0;$i<$columns;$i++) {
		$colstart = $border+$bwid+$i*$colwid;
		$ticpos = $colstart+$colwid/2;
		$ticlen = 5;
		if(($i % ($columns/4)) == 0) {
			$ticlen = 10;
			$textpos = $colstart - 1*$fontwid;
			$timestring = sprintf "%02d:00",$i;
			$im->string(gdSmallFont,$textpos,$size-$border+10,$timestring,$black);

		}
		$barbot = $size-$border;
		$im->line($ticpos,$barbot,$ticpos,$barbot+$ticlen,$black);
	}

	$im->string(gdSmallFont,$border-6*$fontwid,$border-$fonthgt/2,"100%",$black);
	$im->line($border-10,$border,$border,$border,$black);
	$im->string(gdSmallFont,$border-5*$fontwid,$border+$plotsize/4-$fonthgt/2,"75%",$black);
	$im->line($border-10,$border+$plotsize/4,$border,$border+$plotsize/4,$black);
	$im->string(gdSmallFont,$border-5*$fontwid,$border+$plotsize/2-$fonthgt/2,"50%",$black);
	$im->line($border-10,$border+$plotsize/2,$border,$border+$plotsize/2,$black);
	$im->string(gdSmallFont,$border-5*$fontwid,$border+($plotsize*3)/4-$fonthgt/2,"25%",$black);
	$im->line($border-10,$border+($plotsize*3)/4,$border,$border+($plotsize*3)/4,$black);
	$im->string(gdSmallFont,$border-4*$fontwid,$size-$border-$fonthgt/2,"0%",$black);
	$im->line($border-10,$size-$border,$border,$size-$border,$black);
	
	for($i=0;$i<$columns;$i++) {
		if($d[$i]) {
			$colstart = $border+$bwid+$i*$colwid+((1-$barsiz)*$colwid)/2;
			$height = $plotsize - ($plotsize * $d[$i]) / 100;
			$im->filledRectangle($colstart,$border+$bwid+$height,
				$colstart+$barsiz*$colwid,$size-$border-$bwid,$plotcolour);
		}
	}

	centreString($im,$size/2,$border/2,$title,$black);
	centreString($im,$size/2,$size - $border/3,"Time",$black);
	centreStringUp($im,$border/4,$size/2+30,"Usage",$black);

	if($web) {
		print "Content-Type: image/gif\n\n";
	}

	print $im->gif;
}


sub centreString {
	webdie "centreString: wrong number of parameters" if(@_ != 5);
	($im,$x,$y,$string,$colour) = @_;

	$font = gdLargeFont;
	$fontwid = 8;
	$fonthgt = 16;

	$textx = $x - ((length $string) * $fontwid)/2;
	$texty = $y - $fonthgt/2;	# handle from the middle of string
	#print "($x,$y) -> ($textx,$texty)\n";
	$im->string($font,$textx,$texty,$string,$colour);
}


sub centreStringUp {
	webdie "centreStringUp: wrong number of parameters" if(@_ != 5);
	($im,$x,$y,$string,$colour) = @_;

	$font = gdLargeFont;
	$fontwid = 8;
	$fonthgt = 16;

	$textx = $x - $fonthgt/2;	# handle from the middle of string
	$texty = $y - ((length $string) * $fontwid)/2;
	#print "($x,$y) -> ($textx,$texty)\n";
	$im->stringUp($font,$textx,$texty,$string,$colour);
}
