/*            Mauro Javier De Gennaro <mauro@minter.com.ar>         */

/* Full path to VisualAdmin's configuration file */
/* NOTE: This file is created the first time you run visualadmin. */
#define CONF_FILE "/etc/visualadmin.conf"

/* Uncomment this to enable shadow passwords support */
/* #define SHADOW_PASSWD */

/* passwd and shadow database entry */
typedef struct {
	int active;
	char user[15];
	char pass[15];
	char gecos[55];
	int uid;
	int gid;
	char home[55];
	char shell[55];
#ifdef SHADOW_PASSWD
	char lastch[15];
	char min[15];
	char max[15];
	char warn[15];
	char inact[15];
	char expire[15];
	char flag[15];
#endif
} user_tb;

/* named.boot entry */
typedef struct {
	int num;
	char buf[1024];
} named_tb;

/* file editor filenames and descriptions */
typedef struct {
	char file[50];
	char desc[50];
} file_tb;

/* sort password switch 1=sort, 0=no sort */
int sortpass;

#ifdef SHADOW_PASSWD
/* date display mode 1=dmy, 2=mdy, 3=ymd */
int dispmode;
#endif

/* cgi post data (data sent from the web) */
char *data;

/* admin username */
char user[15];

/* encrypted admin's password */
char pass[21];

/* location of the dns files */
char dnsdir[100];

/* username search query */
char query[20];

/* location of passwd file */
char F_PASSWD[20];

#ifdef SHADOW_PASSWD
/* location of shadow passwd file */
char F_SHADOW[20];
#endif

/* location of shells file */
char F_SHELLS[20];

/* location of group file */
char F_GROUP[20];

/* location of named.boot file */
char F_NAMED[25];

/* location of login defaults file*/
char F_LDEFS[25];

/* location of default home directory */
char D_HOME[20];

/* password cripting key */
char CRIPT_KEY[35];

/* end of visualadmin.h */
