/*              Mauro Javier De Gennaro <mauro@minter.com.ar>           */

/* visualadmin.c <2.0> - VisualAdmin 2.0 Main Module */

#include <stdio.h> 
#include <string.h>
#include <stdlib.h>
#include "visualadmin.h"

int data_length;

void main() {
int c=0;
char *method, module[10], temp[30];

method = getenv("REQUEST_METHOD");

if (!strcmp(method, "GET")) {
	data= strdup(getenv("QUERY_STRING"));
	if (strlen(data) <= 2) {
		view_welcome();
		exit(0);
	}
	data[strlen(data)]='&';
} else if (!strcmp(method, "POST")) {
	if ( !(data_length = atoi(getenv("CONTENT_LENGTH"))) )
		critical("POST Error: Null data.");
	if ( !(data = (char *) malloc (data_length+1)) )
		critical ("POST Error: Can't malloc() data.");
	if ( !fread(data, data_length, 1, stdin)) 
		critical("Unable to read STDIN.");
	data[data_length]='&';
} else {
	critical ("Method not supported");
}

	readconf();
		
	get_var(data, module, "locator=");
	get_var(data, user, "user=");
	get_var(data, pass, "pass=");

	if (strcmp(module, "login")) code_pass(0);

	switch (verify_pass()) {
		case 0:
			critical("Incorrect username or password.");
		case 1:
			critical("User doesn't have superuser access.");
		default:
			break;
	}

	code_pass(1);

	if (!strcmp(module, "login")) view_menu();
	strcpy(temp,"");
	get_var(data,temp,"query=");
	if(strlen(temp)<=1) strcpy(query,"none"); else strcpy(query, temp);

	if (!strcmp(module, "menu")) {
		get_var(data, temp, "moveto=");
		if (!strcmp(temp, "usrlst")) view_search();
		if (!strcmp(temp, "usradd")) user_list(4);
		if (!strcmp(temp, "dnslst")) dns_list(0);
		if (!strcmp(temp, "dnsadd")) view_dnsedit(0);
		view_fedit(atoi(temp));
	}
	
	if (!strcmp(module, "usrfind")) {
		if(strstr(data,"cancel=")!=NULL) view_menu();
		get_var(data,temp,"cont=");
		strcpy(query,temp);
		if(strstr(data,"case=")!=NULL) 
			query[1]='1';
		else
			query[1]='0';
		query[2]='\0';
		get_var(data,temp,"word=");
		if(strlen(temp)<=1&&query[0]!='0')
			critical("You must fill the word field.");
		strcat(query,temp);
		if(query[0]=='0') strcpy(query,"none");
		user_list(0);
	}

	if (!strcmp(module, "usrlist")) {
		if(strstr(data,"delete=") != NULL) user_list(1);
		if(strstr(data,"moveto=moduser") != NULL) user_list(2);
		if(strstr(data,"ok=") != NULL) view_menu();
		critical("Error processing destination in POST.");
	}
	if (!strcmp(module, "usermod")) user_list(3);

	if (!strcmp(module, "dnslist")) {
		if(strstr(data, "delete=") != NULL) dns_list(1);
		if(strstr(data, "moveto=moddns") != NULL) dns_list(2);
		if(strstr(data,"ok=") != NULL) view_menu();
		critical("Error processing destination in POST.");
	}

	if (!strcmp(module, "dnsedit")) {
		if(strstr(data, "ok=") != NULL) dns_list(3);
		if(strstr(data,"num=0") != NULL)
				view_menu();
			else
				dns_list(0);
	}

	if (!strcmp(module, "fedit")) {
		if(strstr(data, "cancel=") != NULL) view_menu();
		get_var(data,temp,"num=");
		save_file(atoi(temp));
		view_menu();
	}

	critical("Internal Error: Can't locate source data.");
}
