/*
	Locate a keyword in a dispatch table and creation an OPTION object if
	found
*/
static OPTION *disp_lookup(
	SECTION_DISPATCH tbd[],
	const char *keyw,
	const char *arg,
	FILE *fin,
	const char *fname,
	int &noline)
{
	OPTION *ret = NULL;
	if (tbd != NULL){
		for (int i=0; tbd[i].keyw != NULL; i++){
			if (strcmp(tbd[i].keyw,keyw)==0){
				ret = (*tbd[i].f)(keyw,arg,fin);
				break;
			}
		}
	}
	return ret;
}

static OPTION *screa_option(
	const char *keyw,
	const char *arg,
	FILE *fin,
	const char *fname,
	int &noline)
{
	return new OPTION (keyw,arg);
}
static OPTION *screa_section(
	const char *keyw,
	const char *arg,
	FILE *fin,
	const char *fname,
	int &noline)
{
	SECTION *ret = new SECTION;
	ret->read (fin,fname,noline);
	return ret;
}

/*
	Read a portion of a XF86Config file up to the EndSection.
*/
PUBLIC int SECTION::readdisp (
	FILE *fin,
	const char *fname,	// Name of source file for error message
	int &noline,
	SECTION_DISPATCH disp[])
{
	char buf[500];
	while (fgets_strip(buf,sizeof(buf)-1,fin,'\0','\0',&noline)!= NULL){
		char *pt = str_strip (buf);
		int opt_was_added = 0;
		if (*pt == '#'){
			opt_was_added = 1;	// Avoid error message
		}else{
			char keyw[100];
			pt = str_copyword (keyw,pt);
			pt = str_skip (pt);
			OPTION *opt = disp_lookup (disp,keyw,pt,fin,fname,noline);
			if (opt != NULL){
				opt_was_added = 1;	// Avoid error message
				tbopt.add (opt);
			}
		}
	}

	if (opt_was_added != 0){
//		xconf_error (
//			"file %s, line %d\n\n"
//			"Section %s don't allows suboption\n%s\n"
//			,fname,noline,parsing.section->keyw,buf);
	}
	return opt_was_added;
}


PUBLIC int KEYBOARD::read (
	FILE *fin,
	const char *fname,	// Name of source file for error message
	int &noline)
{
	static SECTION_DISPATCH disp[]={	// Suboptions for Keyboard
		{"ServerNumLock",	screa_option,	NULL},
		{"AutoRepeat",		screa_option,	NULL},
		{"Xleds",		screa_option,		NULL},
		{"DontZap",		screa_option,		NULL},
		{"LeftAlt",		screa_option,		NULL},
		{"RightAlt",	screa_option,		NULL},
		{"RightCtl",	screa_option,		NULL},
		{"ScrollLock",	screa_option,		NULL},
		{NULL,NULL,NULL}
	};
	return readdisp (fin,fname,noline,disp);
}

PUBLIC int POINTER::read (
	FILE *fin,
	const char *fname,	// Name of source file for error message
	int &noline)
{
	static SECTION_DISPATCH disp[]={	// Suboptions for Mouse
		{"BaudRate",	screa_option,	NULL},
		{"SampleRate",	screa_option,	NULL},
		{"Emulate3Buttons",	screa_option,NULL},
		{NULL,			NULL,NULL},
	};
	return readdisp (fin,fname,noline,disp);
}

PUBLIC int DEVICE::read (
	FILE *fin,
	const char *fname,	// Name of source file for error message
	int &noline)
{
	static SECTION_DISPATCH disp[]={	// Suboptions for ACCEL
		{"Clocks",	screa_section,		NULL},
		{"Modeline",	screa_option,		NULL},
		{"Option",	screa_option,		NULL},
		{"Viewport",	screa_option,	NULL},
		{"Virtual",	screa_option,		NULL},
		{NULL,NULL,NULL}
	};
	return readdisp (fin,fname,noline,disp);
}

PUBLIC int FILES::read (
	FILE *fin,
	const char *fname,	// Name of source file for error message
	int &noline)
{
	static SECTION_DISPATCH disp[]={
		{"RGBPath",			screa_option,	NULL},
		{"FontPath",		screa_option,	NULL},
		{NULL,			NULL},
	};
	return readdisp (fin,fname,noline,disp);
}
#if 0
	static SECTION_DISPATCH dispsect[]={
		{"Keyboard",		screa_section,	dispkeyboard},
		{"RGBPath",			screa_option,		NULL},
		{"FontPath",		screa_option,	NULL},

		{"mousesystems",	screa_section,	dispmouse},
		{"msmouse",			screa_section,	dispmouse},

		{"ACCEL",		screa_section,		dispaccel},
		{"VGA2",			screa_section,	dispvga2},
		{"ModeDB",		screa_section,		NULL},
		{"NoTrapSignals", screa_option,		NULL},
		{NULL,			NULL},
	};

#endif
