#include <stdio.h>
#include <string.h>
#include <misc.h>
#include "internal.h"
#include "uucp.h"
#include "uucp.m"
#include "../paths.h"

static UUCP_HELP_FILE help_dialers("dialers");
static CONFIG_FILE f_dialers (VAR_LIB_UUCP_DIALERS
	,help_dialers
	,CONFIGF_OPTIONNAL|CONFIGF_MANAGED
	,"uucp","uucp",0660);


PUBLIC DIALER::DIALER ()
{
}

PUBLIC DIALER::DIALER (
	const char *buf,	// Buffer to parse from the Permissions file
	const SSTRING &_comments,	// Comments preceding the definition
	char *err)			// Will contain error message or '\0'
{
	comments.setfrom (_comments);
	comments.strip_end();
	err[0] = '\0';
	buf = type.copyword (buf);
	buf = phonecnv.copyword (buf);
	buf = str_skip (buf);
	chat.setfrom (buf);
}

/*
	Write one record in the Permissions file
*/
PUBLIC void DIALER::write (FILE *fout)
{
	comment_write (comments,fout);
	fprintf (fout,"%s\t%s\t%s\n",type.get(),phonecnv.get(),chat.get());
}

PUBLIC DIALERS::DIALERS()
	: CONFIG_OBJS (f_dialers)
{
}

PUBLIC DIALER *DIALERS::getitem(int no) const
{
	return (DIALER*)ARRAY::getitem(no);
}

/*
	Get a dialer description from its name (type)
*/
PUBLIC DIALER *DIALERS::getitem(const char *type) const
{
	DIALER *ret = NULL;
	int n = getnb();
	for (int i=0; i<n; i++){
		DIALER *d = getitem(i);
		if (d->type.cmp(type)==0){
			ret = d;
			break;
		}
	}
	return ret;
}

PROTECTED CONFIG_OBJ *DIALERS::newobj (
	const char *buf,	// Buffer to parse from the Permissions file
	const SSTRING &_comments,	// Comments preceding the definition
	char *err)			// Will contain error message or '\0'
{
	return new DIALER (buf,_comments,err);
}




