#include "userconf.h"
#include "internal.h"

/*
	Return a TUSER_xxx value to identify the type of users
*/
PUBLIC int USER::getcateg()
{
	int ret = TUSER_SPECIAL;
	const char *sh = shell.get();
	if (sh[0] == '\0') sh = "/bin/sh";
	if (is_admin()){
		ret = TUSER_ADMIN;
	}else if (shells_isppp(sh)){
		ret = TUSER_PPP;
	}else if (shells_isslip(sh)){
		ret = TUSER_SLIP;
	}else if (gid != -1){
		if (groups_getppp()==gid){
			ret = TUSER_PPP;
		}else if (groups_getslip()==gid){
			ret = TUSER_SLIP;
		}else if (groups_getuucp()==gid){
			ret = TUSER_UUCP;
		}else if (groups_getpop()==gid){
			ret = TUSER_POP;
		}else{
			ret = TUSER_STD;
		}
	}else{
		ret = TUSER_STD;
	}
	return ret;
}

/*
	Find out if a user account is of the same category than another
	one.

	If other == NULL, it is assumed to be a normal ordinary user.
*/
PUBLIC int USER::is_like (USER *other)
{
	int other_categ = other == NULL ? TUSER_STD : other->getcateg();
	return getcateg()==other_categ;
}


/*
	Set the default information of an account from another.
*/
PUBLIC void USER::setlike (USER *other)
{
	if (other != NULL){
		shell.setfrom (other->getshell());
		wrkdir.setfrom (other->wrkdir.get());
		special = other->is_special();
		uid = other->getuid();
		gid = other->getgid();
	}
}

