#include <string.h>
#include "../paths.h"
#include "userconf.h"
#include "userconf.m"
#include "internal.h"

extern PRIVILEGE p_managepop;
extern PRIVILEGE p_manageppp;
extern PRIVILEGE p_manageuucp;

/*
	Initialise a template object for a specific group.
	The caller must delete the object.
	special may hold NULL if the group is not special.
*/
int special_init (const char *group, USER *&special)
{
	int ret = 0;
	special = NULL;
	if (group != NULL){
		if (strcmp(group,UUCP_GROUP)==0){
			/* #Specification: userconf / uucp account
				All uucp accounts are set with the
				group uucp (UUCP_GROUP)
			*/
			int gid = group_getcreate(UUCP_GROUP
				,MSG_U(P_UUCP,"setup UUCP account"));
			if (gid != -1){
				special = new USER (NULL,NULL,-1,gid,NULL
						,VAR_SPOOL_UUCPPUBLIC
						,USR_LIB_UUCP_UUCICO);
			}else{
				ret = -1;
			}
		}else if (strcmp(group,SLIP_GROUP)==0){
			/* #Specification: userconf / slip account
				All slip account are set with the
				group slipusers (SLIP_GROUP)
			*/
			int gid = group_getcreate(SLIP_GROUP
				,MSG_U(P_SLIP,"setup SLIP account"));
			if (gid != -1){
				special = new USER (NULL,NULL,-1,gid,NULL,""
					,shells_getslipdefault());
			}else{
				ret = -1;
			}
		}else if (strcmp(group,PPP_GROUP)==0){
			/* #Specification: userconf / ppp account
				All ppp account are set with the
				group pppusers (PPP_GROUP). If this
				group does not exist, it is created
				The user is prompt about that.
			*/
			int gid = group_getcreate(PPP_GROUP
				,MSG_U(P_PPP,"setup PPP account"));
			if (gid != -1){
				special = new USER (NULL,NULL,-1,gid,NULL,""
					,shells_getpppdefault());
			}else{
				ret = -1;
			}
		}else if (strcmp(group,POP_GROUP)==0){
			/* #Specification: userconf / pop account
				All pop account are set with the
				group popusers (POP_GROUP). If this
				group does not exist, it is created
				The user is prompt about that.

				POP only users are getting the
				shell /bin/false denying
				interactive logins.
			*/
			int gid = group_getcreate(POP_GROUP
				,MSG_U(P_POP,"setup POP account"));
			if (gid != -1){
				special = new USER (NULL,NULL,-1,gid,NULL,""
					,"/bin/false");
			}else{
				ret = -1;
			}
		}
	}
	return ret;
}

/*
	Return the PRIVILEGE associate with the management of user of this group
	Return NULL if there no special privilege (Only root can do it).
*/

PRIVILEGE *special_getpriv (const char *group)
{
	PRIVILEGE *ret = NULL;
	USER *user;
	special_init (group,user);
	if (user != NULL){
		int categ = user->getcateg();
		if (categ == TUSER_UUCP){
			ret = &p_manageuucp;
		}else if (categ == TUSER_PPP){
			ret = &p_manageppp;
		}else if (categ == TUSER_POP){
			ret = &p_managepop;
		}
		delete user;
	}
	return ret;
}

