#pragma interface
#ifndef INTERNAL_H
#define INTERNAL_H

#ifndef MISC_H
	#include <misc.h>
#endif

class USERCONF_HELP_FILE: public HELP_FILE{
	/*~PROTOBEG~ USERCONF_HELP_FILE */
public:
	USERCONF_HELP_FILE (const char *fname);
	/*~PROTOEND~ USERCONF_HELP_FILE */
};

class PASSWD_VALID{
public:
	int minlen;
	int minnonalpha;
	/*~PROTOBEG~ PASSWD_VALID */
public:
	PASSWD_VALID (void);
	void edit (void);
	void write (void);
	/*~PROTOEND~ PASSWD_VALID */
};

class SHADOW: public ARRAY_OBJ{
	friend class SHADOWS;
	friend class USER;
	SSTRING name;
	SSTRING passwd;
	int last;
	int may;
	int must;
	int warn;
	int expire;
	int disable;
	SSTRING reserved;
	/*~PROTOBEG~ SHADOW */
public:
	SHADOW (const char *line);
	SHADOW (void);
	const char *getpwd (void);
	void setdialog (DIALOG&dia);
	void write (FILE *fout);
	int writedef (void);
	/*~PROTOEND~ SHADOW */
};

class SHADOWS: public ARRAY{
	/*~PROTOBEG~ SHADOWS */
public:
	SHADOWS (void);
	SHADOW *getitem (const char *name);
	SHADOW *getitem (int no);
	int write (PRIVILEGE *priv);
	/*~PROTOEND~ SHADOWS */
};

#define TUSER_STD		1
#define TUSER_PPP		2
#define TUSER_SLIP		3
#define TUSER_UUCP		4
#define TUSER_SPECIAL	5
#define TUSER_POP		6
#define TUSER_ADMIN		7


#endif


