#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <misc.h>

/*
	Read argument from a file.
	This function is used for DOS (Ya, this kit is used on DOS, not linuxconf)
	to go around the command line length limitation.

	Return the number of argument placed in newargv[].

	It reads the argument and whenever one start with a @, it assumes
	the argument is a file containing arguments.
*/
int anlparm (int argc, char *argv[], char *newargv[])
{
	int ret = 0;
	for (int i=0; i<argc; i++){
		if (argv[i][0] == '@'){
			FILE *fin = fopen (argv[i]+1,"r");
			if (fin == NULL){
				fprintf (stderr,"Ne peut ouvrir %s (%s)\n"
					,argv[i]+1,strerror(errno));
			}else{
				char buf[300];
				while (fgets(buf,sizeof(buf)-1,fin)!=NULL){
					char *pt = buf;
					while (1){
						pt = str_skip (pt);
						if (*pt == '\0') break;
						char word[300];
						pt = str_copyword (word,pt);
						newargv[ret++] = strdup (word);
					}
				}
				fclose (fin);
			}
		}else{
			newargv[ret++] = argv[i];
		}
	}
	newargv[ret] = NULL;
	return ret;
}

