#ifndef CONF_PATHS_H


// Port used when installing linuxconf in Web mode server.
#define LINUXCONF_HTTP_PORT	98
#define LINUXCONF_HTTP_PORT_DEBUG	8000

/* Different paths */
/* If you change something here, you may want to change rules.mak also */

#define ETC_ALIASES		"/etc/aliases"

#define ETC_CONF_AMD_MAP	"/etc/conf.amd.map"

#define ETC_CONF_LINUXCONF	"/etc/conf.linuxconf"
#define ETC_CONF_ROUTES		"/etc/conf.routes"

#define ETC_EXPORTS			"/etc/exports"
#define ETC_FSTAB			"/etc/fstab"
#define ETC_HOSTNAME		"/etc/hostname"
#define ETC_GATED_CONF		"/etc/gated.conf"
#define ETC_GROUP			"/etc/group"
#define ETC_HOST_CONF		"/etc/host.conf"
#define ETC_HOSTS			"/etc/hosts"
#define ETC_INETD_CONF		"/etc/inetd.conf"
#define ETC_LILO_CONF		"/etc/lilo.conf"
#define ETC_SSH_HOST_KEY	"/etc/ssh_host_key"
#define ETC_SHADOW			"/etc/shadow"
#define ETC_VMAIL			"/etc/vmail"
#define VHOME				"/vhome"

#define BOOT_MAP		"/boot/map"
#define ETC_MTAB		"/etc/mtab"
#define ETC_NAMED_BOOT		"/etc/named.boot"
#define ETC_NETWORKS		"/etc/networks"
#define ETC_PASSWD		"/etc/passwd"
#define ETC_PPP_CONF_PPP	"/etc/ppp/conf.ppp"
#define ETC_PPP_IPUP		"/etc/ppp/ip-up"
#define ETC_PPP_IPDOWN		"/etc/ppp/ip-down"
#define ETC_RESOLV_CONF		"/etc/resolv.conf"
#define ETC_SENDMAIL_CF		"/etc/sendmail.cf"
#define ETC_SHELLS			"/etc/shells"
#define ETC_XF86CONFIG		"/etc/XF86Config"
#define ETC_XACCEL_INI		"/etc/Xaccel.ini"


/* Empty file which record the last time netconf has sent */
/* a SIGHUP signal to inetd */
#define VAR_RUN_FIREWALL_ACCT	"/var/run/firewall.state.acct"
#define VAR_RUN_FIREWALL_BLOCK	"/var/run/firewall.state.block"
#define VAR_RUN_FIREWALL_FORWD	"/var/run/firewall.state.forwd"
#define VAR_RUN_FIREWALL_OUTPUT	"/var/run/firewall.state.output"
#define VAR_RUN_INETD_SIGHUP	"/var/run/inetd.sighup"
#define VAR_RUN_PPP0_PID		"/var/run/ppp0.pid"
#define VAR_RUN_PPPDEV			"/var/run/pppdev"
#define VAR_RUN_PPPD_ARGS		"/var/run/pppd-args"
#define VAR_RUN_ROUTED_OPTIONS	"/var/run/routed.options"
#define VAR_RUN_SENDMAIL_PID	"/var/run/sendmail.pid"
#define USR_BIN_X11_X		"/usr/bin/X11/X"


#define VAR_LOG_NETCONF_LOG		"/var/log/netconf.log"
#define VAR_RUN_SIMUL		"/var/run/netconf.simul"
#define VAR_RUN_UPDATE		"/var/run/netconf.update"


#define USR_LIB_LINUXCONF	"/usr/lib/linuxconf"
#define USR_LIB_CONF_DAEMONS	USR_LIB_LINUXCONF "/conf.daemons"
#define USR_LIB_CONF_PERMISSIONS USR_LIB_LINUXCONF "/conf.permissions"
#define USR_LIB_ZONEINFO	"/usr/lib/zoneinfo"
#define USR_LIB_LOCALTIME	"/usr/lib/zoneinfo/localtime"

#define USR_SRC_LINUX_MAKEFILE	"/usr/src/linux/Makefile"

#define HELP_BASEPATH		"/usr/lib/linuxconf"
#define HELP_ASKRUN		"askrunlevel"
#define HELP_DNSCONF		"dnsconf"
#define HELP_MAIN		"main"
#define HELP_MAILCONF		"mailconf"
#define HELP_NETCONF		"netconf"
#define HELP_USER		"userconf"
#define HELP_XCONF		"xconf"
#define HELP_FSTAB		"fstab"
#define HELP_UUCP		"uucp"

#define VAR_LOG_BOOT_LOG		"/var/log/boot.log"
#define VAR_LOG_HTML_LOG		"/var/log/htmlaccess.log"

#define VAR_RUN_INITRUNLEVEL	"/var/run/initrunlvl"
#define ETC_INITRUNLEVEL	"/etc/initrunlvl"
#define VAR_RUN_NETLEVEL		"/var/run/netconf.level"
#define VAR_RUN_ROUTES_CURRENT	"/var/run/routes.current"

#define VAR_LIB_MAILERTABLE	"/var/lib/mailertable"
#define VAR_LIB_CONF_PERMISSIONS "/var/lib/conf.permissions"

#define VAR_LIB_UUCP_DEVICES	"/var/lib/uucp/hdb_config/Devices"
#define VAR_LIB_UUCP_DIALERS	"/var/lib/uucp/hdb_config/Dialers"
#define VAR_LIB_UUCP_PERMS		"/var/lib/uucp/hdb_config/Permissions"
#define VAR_LIB_UUCP_POLL		"/var/lib/uucp/hdb_config/Poll"
#define VAR_LIB_UUCP_SYSTEMS	"/var/lib/uucp/hdb_config/Systems"

#define VAR_LIB_WWW_HTTPD_CONF	"/var/lib/www/conf/httpd.conf"
#define VAR_LIB_WWW_BIN_HTTPD	"/var/lib/www/bin/httpd"

/* Different magic names */

/* Symbolic names used in /etc/hosts and /etc/network to configure */
/* first ethernet interface */
#define NAM_ETH0_LOGHOST		"loghost"
#define NAM_ETH0_NETWORK		"eth0_network"
#define NAM_ETH0_NETMASK		"eth0_netmask"
#define NAM_ETH0_BCAST			"eth0_broadcast"

/* Second ethernet */
#define NAM_ETH1_LOGHOST		"eth1_loghost"
#define NAM_ETH1_NETWORK		"eth1_network"
#define NAM_ETH1_NETMASK		"eth1_netmask"
#define NAM_ETH1_BCAST			"eth1_broadcast"

/* Third ethernet */
#define NAM_ETH2_LOGHOST		"eth2_loghost"
#define NAM_ETH2_NETWORK		"eth2_network"
#define NAM_ETH2_NETMASK		"eth2_netmask"
#define NAM_ETH2_BCAST			"eth2_broadcast"

/* fourth ethernet */
#define NAM_ETH3_LOGHOST		"eth3_loghost"
#define NAM_ETH3_NETWORK		"eth3_network"
#define NAM_ETH3_NETMASK		"eth3_netmask"
#define NAM_ETH3_BCAST			"eth3_broadcast"

#define SBIN_SLIPLOGIN			"/sbin/diplogin"
#define USR_LIB_PPP_PPPLOGIN		"/usr/lib/ppp/ppplogin"
#define USR_LIB_UUCP_UUCICO		"/usr/lib/uucp/uucico"
#define VAR_SPOOL_UUCPPUBLIC		"/var/spool/uucppublic"
#define VAR_SPOOL_VMAIL				"/var/spool/vmail"

#define POP_GROUP			"popusers"
#define PPP_GROUP			"pppusers"
#define SLIP_GROUP			"slipusers"
#define UUCP_GROUP			"uucp"

#define PROC_NET_ALIAS_TYPES	"/proc/net/alias_types"
#define PROC_NET_ALIASES		"/proc/net/aliases"
#define PROC_NET_DEV			"/proc/net/dev"
#define PROC_NET_IP_FORWARD		"/proc/net/ip_forward"
#define PROC_NET_IP_BLOCK		"/proc/net/ip_block"
#define PROC_NET_IP_INPUT		"/proc/net/ip_input"
#define PROC_NET_IP_OUTPUT		"/proc/net/ip_output"
#define PROC_NET_IP_ACCT		"/proc/net/ip_acct"
#define PROC_NET_IPX_INTER		"/proc/net/ipx_interface"
#define PROC_NET_RARP			"/proc/net/rarp"
#define PROC_NET_ROUTE			"/proc/net/route"

#define LIB_MODULES				"/lib/modules"

#endif

