#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#include <netdb.h>
#include "netconf.h"
#include <userconf.h>
#include "../paths.h"
#include "netconf.m"
/*
	Try to find out if networking is somewhat configured
	Returne the host entry of the this host or NULL if not minimally
	configured.
*/
struct hostent *netconf_netok(char *status)
{
#if 0
	struct stat buf;
	struct hostent *ret = NULL;
	static char *hostfile = ETC_HOSTNAME;
	strcpy (status,hostfile);
	strcat (status," do not exist\n");
	if (stat(hostfile,&buf) != -1){
		strcpy (status,hostfile);
		strcat (status," do exist\n");
		FILE *fin = fopen (hostfile,"r");
		if (fin == NULL){
			strcat (status,"but can't be read\n");
		}else{
			char host[200];
			if (fscanf (fin,"%s",host)!=1){
				strcat (status,"but do not contain the name of the system\n");
			}else if ((ret=gethostbyname(host))==NULL){
				strcat (status,"but the name of the system, ");
				strcat (status,host);
				strcat (status,"\nhas no definition in /etc/hosts\n");
			}
			fclose (fin);
		}
	}
	return ret;
#else
	struct hostent *ret = gethostbyname(NAM_ETH0_LOGHOST);
	status[0] = '\0';
	if (ret==NULL){
		strcpy (status,
			MSG_U(E_NOPRIMNAME
			 ,"No definition for the primary name\n"
			 "in /etc/hosts.\n"
			 "There is no entry with the name or alias\n"
			 "\"loghost\".\n"));
	}
	return ret;
#endif
}	

static void thishost1_fqhn2host (const char *fqhn, char *hostpart)
{
	char *pt = strchr(fqhn,'.');
	if (pt != NULL){
		int len = (int)(pt-fqhn);
		memcpy (hostpart,fqhn,len);
		hostpart[len] = '\0';
	}else{
		strcpy (hostpart,fqhn);
	}
}


static int thishost1_sethostname (const char *str)
{
	int ret = -1;
	if (perm_rootaccess (MSG_U(P_SETHOSTNAME,"Setting the hostname"))){
		char buf[100];
		thishost1_fqhn2host (str, buf);
		ret  = sethostname (buf,strlen(buf)+1);
	}
	return ret;
}

/*
	Set the hostname in the kernel.
	Return -1 if anything goes wrong.
*/
int netconf_sethostname()
{
	THISHOST thishost;
	int ret = -1;
	if (thishost.configok()){
		const char *str = thishost.getname1();
		char hostpart[100];
		thishost1_fqhn2host (str,hostpart);
		char buf[100];
		if (gethostname(buf,sizeof(buf)-1)!=-1
			&& strcmp(buf,hostpart)==0){
			ret = 0;
		}else{
			if (simul_ison()){
				simul_addmsg (MSG_U(X_SETHOSTNAME
					,"Setting hostname to %s\n"),str);
				ret = 0;
			}else{
				ret = thishost1_sethostname (str);
				if (ret == -1){
					xconf_error (MSG_U(E_CANTSETHOST
						,"Can't set the host name to %s\n(%s)\n")
						,str,strerror(errno));
				}else{
					net_prtlog (NETLOG_CMD,MSG_R(X_SETHOSTNAME),str);
				}
			}
		}
	}
	return ret;
}
/*
	Clone of the /bin/hostname command
*/
int netconf_hostname (int argc, char *argv[])
{
	/* #Specification: netconf / aliases / hostname
		netconf emulate the command /bin/hostname. Without argument
		it print the hostname. With one, it set the hostname.
		Option -f may be used to force a lookup of the second argument
		and use the first value returned by gethostbyname().

		The argument may be a fully qualified name. Only the host
		part is used.
	*/
	int ret = -1;
	if (argc == 1){
		char buf[100];
		if (gethostname(buf,sizeof(buf)-1)==-1) strcpy (buf,"none");
		printf ("%s\n",buf);
		ret = 0;
	}else if (argc == 2
		&& (strcmp(argv[1],"-d")==0 || strcmp(argv[1],"--domain")==0)){
		THISHOST host;
		const char *n = host.getname1();
		const char *pt = strchr(n,'.');
		if (pt != NULL){
			pt++;
		}else{
			pt = "";
		}
		printf ("%s\n",pt);
		ret = 0;
	}else if (argc == 2 && argv[1][0] != '-'){
			ret = thishost1_sethostname (argv[1]);
	}else if (argc == 3 && strcmp(argv[1],"-f")==0){
		char *hostname = argv[2];
		struct hostent *ent = gethostbyname(hostname);
		if (ent == NULL){
			xconf_error (MSG_U(E_NOTKNOWN,"%s is not known\n"),hostname);
		}else{
			ret = thishost1_sethostname (ent->h_name);
		}
	}else{
		fprintf (stderr,MSG_U(E_HOSTUSAGE
			,"usage: hostname [-f] [ host name ]\n"
			 "       hostname -d\n"
			 "       hostname --domain\n"));
	}
	return ret;
}

/*
	Clone of the /bin/dnsdomainname command
*/
int netconf_dnsdomainname (int argc, char *[])
{
	/* #Specification: netconf / aliases / hostname
		netconf emulate the command /bin/dnsdomainname. Without argument
		it print the dns domain name. With one, it set the hostname.
		Option -f may be used to force a lookup of the second argument
		and use the first value returned by gethostbyname().

		The argument may be a fully qualified name. Only the host
		part is used.
	*/
	int ret = -1;
	if (argc == 1){
		static char *tb[]={"","-d",NULL};
		ret = netconf_hostname (2,tb);
	}else{
		fprintf (stderr,MSG_U(E_DNSDOMUSAGE
			,"usage: dnsdomainname\n(No argument)\n"));
	}
	return ret;
}

