#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include <netdb.h>
#include "netconf.h"


PUBLIC THISHOST::THISHOST()
{
	name1 = NULL;
	ip_num[0] = '\0';
	is_config = 0;
	char status[1000];
	struct hostent *ent = netconf_netok(status);
	if (ent != NULL){
		name1 = strdup(ent->h_name);
		ipnum_ip2a (ent,ip_num);
		is_config = 1;
	}else{
		name1 = strdup("");
		#ifdef TEST
			printf ("status :%s:\n",status);
		#endif
	}
}
PUBLIC THISHOST::~THISHOST()
{
	free (name1);
	ip_num[0] = '\0';
	is_config = 0;
}

/*
	Accept a new name for the host.
*/
PUBLIC void THISHOST::setname1(const char *newname1)
{
	free(name1);
	name1 = strdup(newname1);
}

/*
	Return of the IP number of this host
*/
PUBLIC const char *THISHOST::getipnum(int )
{
	return ip_num;
}
/*
	Return of the primary name of this host
*/
PUBLIC const char *THISHOST::getname1()
{
	return name1;
}
/*
	Return != 0 if the local hostname is correctly configured
*/
PUBLIC int THISHOST::configok()
{
	return is_config;
}


#ifdef TEST

int main (int argc, char *argv[])
{
	THISHOST host;
	if (host.configok()){
		printf (":%s: -> :%s:\n",host.getname1(),host.getipnum(0));
	}else{
		printf ("Pas configurer\n");
	}
	return 0;
}

#endif

