#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <confdb.h>
#include "netconf.h"
#include <userconf.h>
#include "../paths.h"
#include "netconf.m"
#include "pppdial.h"

NETCONF_HELP_FILE help_ppp ("ppp");

static CONFIG_FILE f_ppp (ETC_PPP_CONF_PPP
	,help_ppp
	,CONFIGF_OPTIONNAL|CONFIGF_MANAGED
	,"root","root",0600);



/* #Specification: PPP & SLIP / management
	All configuration information is store in the file
	/etc/ppp/conf.ppp. This file is a CONFDB file, with
	the same format as /etc/conf.linuxconf.

	The information for all channels are stored in this file

	There are record identifying the channels

	#
	.channel name1
	.channel name2
	#

	And then, for each channel

	#
	name1.login login
	name1.passwd password
	name1.phone phone
	#

	and so on.
*/
#

/*
	Check if the configuration name exist
*/
static int ppp_exist (CONFDB &cfg, const SSTRING &name)
{
	SSTRINGS lst;
	cfg.getall ("",PPP_CHANNEL,lst,0);
	return lst.lookup(name.get()) != -1;
}

/*
	Add a baud rate field in a dialog with standard values
*/
void baud_setfield (
	int baud,
	SSTRING &baudstr,
	DIALOG &dia)
{
	char msg[10];
	baudstr.setfrom (baud);
	FIELD_COMBO	*comb = dia.newf_combo (MSG_U(F_BAUD,"Baud rate"),baudstr);
	static short int tb[]={
		3,6,12,24,48,96,
		192,384,576,1152
	};
	for (unsigned i=0; i<sizeof(tb)/sizeof(tb[0]); i++){
		sprintf (msg,"%d00",tb[i]);
		comb->addopt (msg);
	}
}

void serial_setfield (
	SSTRING &device,
	DIALOG &dia)
{
	FIELD_COMBO *comb = dia.newf_combo  (MSG_U(F_SERIALDEF
		,"Serial device"),device);
	comb->addopt ("/dev/cua0",MSG_U(F_FIRSTCOM,"first standard serial port COM1"));
	comb->addopt ("/dev/cua1",MSG_U(F_SECONDCOM,"Second standard serial port COM2"));
	comb->addopt ("/dev/ttyS0",MSG_U(F_COM1M,"COM1 when using mgetty"));
	comb->addopt ("/dev/ttyS1",MSG_U(F_COM2M,"COM2 when using mgetty"));
}

/*
	Parse the lcpecho field (delay,retry).
	Return -1 if any error, 0 if empty, 1 if a value pair is supplied
*/
PRIVATE int PPPONE::lcpecho_parse(int &delay, int &retry)
{
	int ret = -1;
	delay = retry = 0;
	if (lcpecho.is_empty()){
		ret = 0;
	}else{
		const char *str = lcpecho.get();
		delay = atoi(str);
		const char *pt = strchr(str,',');
		if (pt != NULL){
			retry = atoi(pt+1);
			if (delay != 0 && retry != 0) ret = 1;
		}
	}
	return ret;
}

PRIVATE int PPPONE::lcpecho_valid()
{
	int d,r;
	return lcpecho_parse (d,r)!=-1;
}

PRIVATE int PPPONE::validate_edit (
	SSTRING &baudstr,
	SSTRING &oldname,
	CONFDB &cfg)
{
	char buferr[2000];
	buferr[0] = '\0';
	baud = baudstr.getval();
	if (!oldname.is_empty() && name.cmp(oldname)!=0){
		if (ppp_exist (cfg,name)){
			sprintf (buferr
				,MSG_U(E_DUPCONF,"The configuration %s\n"
				 "already exist\n"
				 "Use another name\n\n")
				,name.get());
		}
	}
	if (name.is_empty()){
		strcat (buferr,MSG_U(E_NEEDNAME,"You must supply\n"
			"a configuration name\n\n"));
	}
	if (device.is_empty()
		&& type != TYPE_PPP_SSH
		&& type != TYPE_PLIP1
		&& type != TYPE_PLIP2){
		strcat (buferr,MSG_U(E_NEEDDEV,"You must supply "
			"a device (/dev/xxxx)\n\n"));
	}
	if (!lcpecho_valid ()){
		strcat (buferr,MSG_U(E_LCPECHO,"You must supply a value pair\n"
			"    delay,retry for the LCP echo protocol"));
	}
	if (type == TYPE_PPP_SSH){
		if (ourip.is_empty() || remoteip.is_empty()){
			strcat (buferr,MSG_U(E_PPPNEEDIP
				,"You must enter an IP number for each side\n"
				 "    of the connexion\n"));
		}
		if (ssh.host.is_empty()
			|| ssh.user.is_empty()
			|| ssh.pppd_path.is_empty()){
			strcat (buferr,MSG_U(E_SSHSECT
				,"You must fill all fields (except encryption)\n"
				 "of the PPP over SSH section\n"));
		}
	}
	int ret = 0;
	if (buferr[0] != '\0'){
		xconf_error (buferr);
		ret = -1;
	}
	return ret;
}			

/*
	Add one IP route definition in the dialog
*/		
PRIVATE void PPPONE::setdia_iproute (DIALOG &dia, int no)
{
	PPPIPROUTE *ir = iproutes.getitem(no);
	dia.newf_str (MSG_U(F_IPDST,"Network or host"),ir->dest);
	dia.newf_str (MSG_U(F_IPMSK,"Netmask(opt)"),ir->mask);
}
	

PUBLIC int PPPONE::edit (CONFDB &cfg)
{
	int ret = -1;
	DIALOG dia;
	SSTRING oldname (name);	
	dia.newf_str  (MSG_U(F_PPPNAME,"Configuration name"),name);
	dia.newf_radio (MSG_U(F_CONNECTTYPE,"Connection type"),type
		,TYPE_PPP_SERIAL
		,MSG_U(F_PPPSERIAL,"PPP using serial port/modem"));
	dia.newf_radio ("",type,TYPE_PPP_SSH
		,MSG_U(F_PPPSSH,"PPP over a secure shell (ssh)"));
	dia.newf_radio ("",type,TYPE_SLIP,MSG_U(F_SLIP,"SLIP"));
	dia.newf_radio ("",type,TYPE_PLIP1
		,MSG_U(F_PLIP1,"PLIP1 (IP over printer port 1)"));
	dia.newf_radio ("",type,TYPE_PLIP2
		,MSG_U(F_PLIP2,"PLIP2 (IP over printer port 2)"));
	static const char *tbauth[]={
		MSG_U(F_PPP_LOGIN,"Login"),
		MSG_U(F_PPP_PAP,"PAP"),
		MSG_U(F_PPP_CHAP,"CHAP"),
		MSG_U(F_PPP_NONE,"None"),
		NULL
	};
	dia.newf_chkm (MSG_U(F_PPPAUTH,"PPP authentication"),pppauth,tbauth);
	dia.newf_str (MSG_U(F_OURIP,"Our IP number(opt)"),ourip);
	dia.newf_str (MSG_U(F_REMOTEIP,"Remote IP number(opt)"),remoteip);

	dia.newf_title ("",MSG_U(T_LOGINCHAT,"Login chat"));

	dia.newf_str  (MSG_U(F_LOGINKEY,"Expected login key"),loginkey);
	dia.newf_str  (MSG_U(F_LOGIN,"login"),login);
	dia.newf_str  (MSG_U(F_PASSWDKEY,"Expected password key"),passwdkey);
	dia.newf_str  (MSG_U(F_PASSWORD,"Password"),passwd);
	dia.newf_str  (MSG_U(F_LOGINOK,"Expected welcome (opt)"),loginok);
	dia.newf_str  (MSG_U(F_LOGINFAIL,"Login fail key (opt)"),loginfail);
	dia.newf_str  (MSG_U(F_LOGINCHAT,"Custom login chat (opt)"),loginchat);

	dia.newf_title ("",MSG_U(T_MODEM,"Modem specifications"));

	serial_setfield (device,dia);

	dia.newf_str (MSG_U(F_MODEMCHAT,"Modem initialisation"),modeminit);
	dia.newf_str  (MSG_U(F_PHONE,"Phone"),phone);
	dia.newf_chk ("",modem,MSG_U(F_MODEMCTRL,"Modem controls"));
	dia.newf_chk ("",lock,MSG_U(F_LOCKFILE,"Lock file"));
	SSTRING baudstr;
	baud_setfield (baud,baudstr,dia);
	dia.newf_title ("",MSG_U(T_FEATURES,"Features"));
	dia.newf_num (MSG_U(F_IDLETIME,"Idle time"),idletime);
	dia.newf_num (MSG_U(F_PPPMRU,"PPP MRU"),mru);
	dia.newf_num (MSG_U(F_PPPMTU,"PPP MTU(opt)"),mtu);
	dia.newf_chk ("",dbgppp,MSG_U(F_RUNPPPD,"Run pppd in debug mode"));
	dia.newf_chk ("",dbgchat,MSG_U(F_RUNCHAT,"Run chat in debug mode"));
	dia.newf_str (MSG_U(F_ASYNCMAP,"Async map"),asyncmap);
	FIELD_COMBO *cecho = dia.newf_combo (MSG_U(F_LCPECHO,"LCP echo"),lcpecho);
	cecho->addopt ("",MSG_U(F_NOLCPECHO,"Don't use LCP echo protocol"));
	cecho->addopt ("15,3",MSG_U(F_ECHO15_3,"Send lcp echo every 15, hangup after 3 failures"));
	dia.newf_str (MSG_U(F_OTHERPPP,"Other PPP options"),options);

	dia.newf_title ("",MSG_U(T_PPPSSH,"PPP over SSH"));
	dia.newf_str   (MSG_U(F_SSHHOST,"Ssh server"),ssh.host);
	dia.newf_str   (MSG_U(F_SSHUSER,"Account"),ssh.user);
	static const char *tbacctype[]={
		MSG_U(F_ACCTPPP,"PPP account"),
		MSG_U(F_ACCTSHELL,"Shell account"),
		NULL
	};
	dia.newf_chkm  (MSG_U(F_ACCTYPE,"Account type"),ssh.via_shell,tbacctype);
	FIELD_COMBO *comb = dia.newf_combo (MSG_U(F_ENCRYPT,"Encryption type")
		,ssh.encrypt);
	static const char *tbcrypt[][2]={
		{"",			MSG_U(O_CRYPTDEF,"Use the default available")},
		{"none",		MSG_U(O_CRYPTNONE,"No encryption")},
		{"idea",		MSG_U(O_CRYPTIDEA,"")},
		{"des",			MSG_U(O_CRYPTDES,"")},
		{"3des",		MSG_U(O_CRYPT3DES,"")},
		{"arcfour",		MSG_U(O_CRYPTFOUR,"")},
		{"tss",			MSG_U(O_CRYPTTSS,"")},
	};
	for (unsigned i=0; i<sizeof(tbcrypt)/sizeof(tbcrypt[0]); i++){
		comb->addopt (tbcrypt[i][0],tbcrypt[i][1]);
	}
	dia.newf_chk (MSG_U(F_COMPRESS,"Compression"),ssh.compress
		,MSG_U(F_ENABLE,"Enabled"));
	dia.newf_str (MSG_U(F_OTHERPPPD,"Path of the remote pppd"),ssh.pppd_path);

	dia.newf_title ("",MSG_U(T_IPROUTING,"IP routing"));
	dia.newf_chk ("",defaultroute,MSG_U(F_DEFROUTE,"Default route"));
	dia.newf_chk ("",proxyarp
		,MSG_U(F_PROXYARP,"Proxy Arp (fake remote on local net)"));
	iproutes.add (new PPPIPROUTE);
	iproutes.add (new PPPIPROUTE);
	for (int r=0; r<iproutes.getnb(); r++){
		setdia_iproute (dia,r);
	}
	int no = 0;
	int extra_but = name.is_empty() ? 0 : MENUBUT_DEL;
	dia.setbutinfo (MENU_USR1,MSG_U(B_CONNECT,"Connect"),"Connect");
	
	while (1){
		char title[100];
		sprintf (title,MSG_U(T_ONEPPPCONF,"%s PPP/SLIP configuration")
			,name.is_empty() ? MSG_U(T_NEWPPP,"new") : name.get());
		MENU_STATUS code = dia.edit (title
			,MSG_U(I_ONEPPPCONF,"One PPP, SLIP or PLIP configuration")
			,help_ppp
			,no
			,extra_but|MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_USR1|MENUBUT_ADD);
		if (code == MENU_CANCEL || code == MENU_ESCAPE){
			break;
		}else if (code == MENU_ADD){
			int r = iproutes.getnb();
			iproutes.add (new PPPIPROUTE);
			setdia_iproute (dia,r);
		}else if (code == MENU_USR1){
			dia.save();
			if (validate_edit(baudstr,oldname,cfg) != -1){
				connect (0);
			}
		}else if (code == MENU_ACCEPT){
			if (validate_edit(baudstr,oldname,cfg) != -1){
				del(cfg,oldname.get());
				save (cfg);
				ret = 0;
				break;
			}
		}else if (code == MENU_DEL){
			if (xconf_yesno(MSG_U(Q_DELETED,"Are you sure")
				,MSG_U(I_DELETED,"This configuration will be\n"
				 "deleted permanently")
				,help_ppp)){
				dia.restore();
				del(cfg,oldname.get());
				cfg.save();
				ret = 0;
				break;
			}
		}
	}
	return ret;
}

void ppp_edit ()
{
	static const char *msg = MSG_U(P_CONFPPP,"configure PPP and SLIP");
	if (perm_rootaccess(msg)){
		CONFDB cppp (f_ppp);
		int choice = 0;
		while (1){
			SSTRINGS lst;
			int nb = cppp.getall ("",PPP_CHANNEL,lst,0);
			lst.sort();
			DIALOG dia;
			for (int i=0; i<nb; i++){
				dia.new_menuitem (" ",*lst.getitem(i));
			}
			dia.addwhat (MSG_U(I_ADDCONF,"a new configuration"));
			MENU_STATUS code = dia.editmenu(
				MSG_U(T_PPPCONF,"PPP/SLIP configuration")
				,MSG_U(I_PPPCONF,"You are allowed to edit/add\n"
				 "PPP and SLIP configuration\n"
				 "which will allow your computer to connect\n"
				 "to PPP and SLIP server")
				,help_ppp
				,choice
				,0);
			const char *sel = dia.getmenustr(choice);
			if (code == MENU_ESCAPE || code == MENU_QUIT){
				break;
			}else if (perm_rootaccess(msg)){
				if (code == MENU_ADD){
					PPPONE one (cppp,NULL);
					one.edit (cppp);
				}else if (sel != NULL){
					if (code == MENU_OK){
						PPPONE one (cppp,sel);
						one.edit (cppp);
					}
				}
			}
		}
	}
}

static PPPONE *ppp_getconfig (const char *name)
{
	PPPONE *ret = NULL;
	if (perm_rootaccess("activate a network link")){
		CONFDB cppp (f_ppp);
		if (ppp_exist (cppp,name)){
			ret = new PPPONE (cppp,name);
		}else{
			xconf_error (MSG_U(E_NOCONF,"No configuration %s"),name);
		}
	}
	return ret;
}

static PPPONE *ppp_getconfig (int argc, char *argv[])
{
	PPPONE *ret = NULL;
	if (argc == 1) ret = ppp_getconfig(argv[0]);
	return ret;
}

/*
	Establish a PPP/SLIP connnection
*/
int ppp_connect (int argc, char *argv[])
{
	int ret = -1;
	int fore = 0;
	if (argc == 2){
		argc--;
		if (strcmp(argv[1],"--fore")==0){
			fore = 1;
		}else{
			xconf_error (MSG_U(E_IVLOPTION
				,"Invalid option\n"
				 "netconf --connect site [ --fore ]"));
		}
	}
	PPPONE *one = ppp_getconfig (argc,argv);
	if (one != NULL){
		ret = one->connect (fore);
		delete one;
	}
	return ret;
}

/*
	Kill a PPP/SLIP connnection
*/
int ppp_disconnect (int argc, char *argv[])
{
	int ret = -1;
	PPPONE *one = ppp_getconfig (argc,argv);
	if (one != NULL){
		ret = one->disconnect ();
		delete one;
	}
	return ret;
}
/*
	Complete a PPP/SLIP connection
*/
int ppp_postconnect (int argc, char *argv[])
{
	int ret = -1;
	if (getuid()!=0){
		fprintf (stderr,MSG_U(E_POSTCONUID,"netconf --postconnect can only be used by root\n"));
	}else if (argc == 3){
		const char *verb = argv[0];
		const char *config = argv[1];
		const char *dev = argv[2];
		if (strcmp(verb,linuxconf_dialout)==0){
			PPPONE *one = ppp_getconfig (config);
			if (one != NULL){
				ret = one->postconnect (dev);
				delete one;
			}
		}else if (strcmp(verb,linuxconf_dialin)==0){
		}
	}else{
		fprintf (stderr,MSG_U(E_POSTCONUSAGE
			,"Invalid usage\n"
			 "netconf --postconnect linuxconf_dialout ppp_config   ppp_device\n"
			 "netconf --postconnect linuxconf_dialin  user_account ppp_device\n"));
	}
	return ret;
}

/*
	Do some tasks before the end of a PPP/SLIP connection
*/
int ppp_predisconnect (int argc, char *argv[])
{
	int ret = -1;
	if (getuid()!=0){
		fprintf (stderr,MSG_U(E_PRECONUID,"netconf --predisconnect can only be used by root\n"));
	}else if (argc == 3){
		const char *verb = argv[0];
		const char *config = argv[1];
		const char *dev = argv[2];
		if (strcmp(verb,linuxconf_dialout)==0){
			PPPONE *one = ppp_getconfig (config);
			if (one != NULL){
				ret = one->predisconnect (dev);
				delete one;
			}
		}else if (strcmp(verb,linuxconf_dialin)==0){
		}
	}else{
		fprintf (stderr,MSG_U(E_PREDISCONUSAGE
			,"Invalid usage\n"
			 "netconf --predisconnect linuxconf_dialout ppp_config   ppp_device\n"
			 "netconf --predisconnect linuxconf_dialin  user_account ppp_device\n"));
	}
	return ret;
}

