#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <ctype.h>
#include <netdb.h>
#include "netconf.h"
#include <misc.h>

extern NETCONF_HELP_FILE help_networks;
static CONFIG_FILE f_networks (ETC_NETWORKS,help_networks
	,CONFIGF_MANAGED|CONFIGF_OPTIONNAL);

PUBLIC NETWORK::NETWORK(const char *buf)
{
	/* #Specification: /etc/networks / format
		A networks file has the following format

		# comment
		network_name ip_number [ aliases ] [ # comment ]

		When we read /etc/networks, we split the line in four parts, being
		the name, the ip number, the aliases and the comment.

		Further, when collecting the comment, we try to keep even
		the space between the last data and the #.

		We hope to be able to edit normal /etc/networks file and
		rewrite it mostly respecting the original format.

		Blank line are also remembered as comment.
	*/
	is_valid = 1;
	const char *pt = str_skip(buf);
	if (*pt == '#'){
		comment.setfrom (buf);
	}else if (*pt > ' ' ){
		// First copy the name
		char tmp[200];
		char *ptd = tmp;
		while (*pt > ' ') *ptd++ = *pt++;
		*ptd = '\0';
		name1.setfrom (tmp);
		pt = str_skip (pt);
		if (*pt > ' '){
			ptd = tmp;
			while (*pt > ' ') *ptd++ = *pt++;
			*ptd = '\0';
			ip_num.setfrom (tmp);
			const char *end_ip = pt;
			pt = str_skip (pt);
			if (*pt == '#'){
				comment.setfrom (end_ip);
			}else if (*pt > ' '){
				const char *begother = pt;
				while (*pt != '#' && *pt != '\0') pt++;
				if (*pt == '\0'){
					others.setfrom (begother);
				}else{
					while (isspace(pt[-1])) pt--;
					int lenother = (int)(pt-begother);
					memcpy (tmp,begother,lenother);
					tmp[lenother] = '\0';
					others.setfrom (tmp);
					comment.setfrom (pt);
				}
			}
		}else{
			is_valid = 0;
		}
	}else if (pt[0] != '\0'){
		// Anything else than a blank link is an error at this point
		is_valid = 0;
	}
}
PUBLIC NETWORK::NETWORK(
	const char *_ip_num,
	const char *_name1,
	const char *_others,
	const char *_comment) : HOST (_ip_num,_name1,_others,_comment)
{
}
PUBLIC NETWORK::NETWORK()
{
}
/*
	Output one NETWORK record in ascii
*/
PUBLIC void NETWORK::print (FILE *fout) const
{
	if (!name1.is_empty())  fprintf (fout,"%s",name1.get());
	if (!ip_num.is_empty())  fprintf (fout,"\t%s",ip_num.get());
	if (!others.is_empty())  fprintf (fout,"\t%s",others.get());
	if (!comment.is_empty()){
		char *pt = str_skip(comment.get());
		if (*pt != '#') fputs (" # ",fout);
		fprintf (fout,"%s",pt);
	}
	fputc ('\n',fout);
}

/*
	Return !- 0 if this is a special entry of /etc/networks
	This entry is special because it must exist for this program
	expect those to work.
*/
PUBLIC int NETWORK::is_special() const
{
	const char *name = getname1();
	static char *tb[]={
		NAM_ETH0_NETWORK,	NAM_ETH0_NETMASK,
		NAM_ETH1_NETWORK,	NAM_ETH1_NETMASK,
		NAM_ETH2_NETWORK,	NAM_ETH2_NETMASK,
		NAM_ETH3_NETWORK,	NAM_ETH3_NETMASK,
	};
	int ret=0;
	for (unsigned i=0; i<sizeof(tb)/sizeof(tb[0]); i++){
		if (strcmp(tb[i],name)==0){
			ret = 1;
			break;
		}
	}
	return ret;
}

PUBLIC NETWORKS::NETWORKS()
{
	cfgf = &f_networks;
}
PUBLIC VIRTUAL HOST *NETWORKS::newhost (
	const char *_ip_num,
	const char *_name1,
	const char *_others,
	const char *_comment)
{
	return new NETWORK (_ip_num,_name1,_others,_comment);
}
PUBLIC VIRTUAL HOST *NETWORKS::newhost (const char *buf)
{
	return new NETWORK (buf);
}
#ifdef TEST

int main (int , char *[])
{
	NETWORKS hosts;
	hosts.read ();
	hosts.write ();
	return 0;
}
#endif

