#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dialog.h>
#include "misc.h"
#include "misc.m"

/*
	pop up a menu in the center of the screen.
	Return MENU_ESCAPE, MENU_QUIT, MENU_OK, MENU_DEL or MENU_INS
*/
MENU_STATUS xconf_menu_gen (
	const char *title,	// Window's title
	const char *explan,	// Explanation of the selection to do
	HELP_FILE &helpfile,	// Help file or help_nil
	int options,		// MENUBUT_...
	const char *opt[],	// Option list ending with NULL
						// Each option is a pair. (Keyword, description)
						// opt[0] is keyword, opt[1] is description
						// opt[2] is nex tkeyword, etc...
	int &choice)		// Will contain de selection in the menu
{
	int err = 0;
	for (int nbopt=0; opt[nbopt] != NULL; nbopt++){
		nbopt++;
		if (opt[nbopt] == NULL){
			fprintf (stderr,"xconf_menu, bad opt[]\n");
			err = 1;
			break;
		}
	}
	// This strange addition is there to illustrate how
	// dialog_menu creates its window. The 2s show the border
	nbopt /= 2;
	MENU_STATUS ret = MENU_ESCAPE;
	if (err == 0){
		dialog_clear();
		ret = dialog_menu (title,explan
			,helpfile
			,options
			,nbopt,(char**)opt,choice);
	}
	return ret;
}

/*
	pop up a menu in the center of the screen.
	Return MENU_ESCAPE, MENU_QUIT, MENU_OK
*/
MENU_STATUS xconf_menu (
	const char *title,	// Window's title
	const char *explan,	// Explanation of the selection to do
	HELP_FILE &helpfile,	// Help file or help_nil
	const char *opt[],	// Option list ending with NULL
						// Each option is a paire. (Keyword, description)
						// opt[0] is keyword, opt[1] is description
						// opt[2] is nex tkeyword, etc...
	int &choice)		// Will contain de selection in the menu
{
	return xconf_menu_gen (title,explan,helpfile,0,opt,choice);
}
/*
	pop up a menu in the center of the screen.
	Return MENU_ESCAPE, MENU_QUIT, MENU_OK
*/
MENU_STATUS xconf_menu (
	const char *title,	// Window's title
	const char *explan,	// Explanation of the selection to do
	const char *opt[],	// Option list ending with NULL
						// Each option is a paire. (Keyword, description)
						// opt[0] is keyword, opt[1] is description
						// opt[2] is nex tkeyword, etc...
	int &choice)		// Will contain de selection in the menu
{
	return xconf_menu (title,explan,help_nil,opt,choice);
}
/*
	pop up a menu in the center of the screen with help and save option.
	Return MENU_ESCAPE, MENU_QUIT, MENU_OK, MENU_SAVE, MENU_DEL or MENU_INS

	Manage the help itself.
*/
MENU_STATUS xconf_menu (
	const char *title,	// Window's title
	const char *explan,	// Explanation of the selection to do
	HELP_FILE &helpfile,	// Help file or help_nil
	const char *save_what,	// Tell what the SAVE button will save or NULL
	const char *ins_what,	// Tell what the INS button will do or NULL
							// if it is not allowed
	const char *del_what,	// Tell what the DEL button will do or NULL
							// if it is not allowed
	const char *add_what,	// Tell what the ADD button do or NULL
							// if it is not allowed
	const char *opt[],	// Option list ending with NULL
						// Each option is a paire. (Keyword, description)
						// opt[0] is keyword, opt[1] is description
						// opt[2] is nex tkeyword, etc...
	int &choice)		// Will contain de selection in the menu
{
	char *tmp_explan = (char*)malloc(strlen(explan)+2000);
	strcpy (tmp_explan,explan);
	int options = 0;
	if (save_what != NULL){
		strcat (tmp_explan,"\n");
		strcat (tmp_explan,"Select <Save> ");
		strcat (tmp_explan,save_what);
		options |= MENUBUT_SAVE;
	}
	if (add_what != NULL){
		strcat (tmp_explan,"\n");
		strcat (tmp_explan,"Select <Add > ");
		strcat (tmp_explan,add_what);
		options |= MENUBUT_ADD;
	}
	if (ins_what != NULL){
		strcat (tmp_explan,"\n");
		strcat (tmp_explan,"Select <Ins > ");
		strcat (tmp_explan,ins_what);
		options |= MENUBUT_INS;
	}
	if (del_what != NULL){
		strcat (tmp_explan,"\n");
		strcat (tmp_explan,"Select <Del > ");
		strcat (tmp_explan,del_what);
		options |= MENUBUT_DEL;
	}
	return  xconf_menu_gen (title,tmp_explan,helpfile,options
			,opt,choice);
}

/*
	Ask a question and return MENU_YES if the user answer yes.
	may Return MENU_NO or MENU_ESCAPE also
*/
MENU_STATUS xconf_yesno(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile)	// Help file or help_nil
{
	dialog_clear();
	return dialog_yesno(title,prompt,helpfile);
}

/*
	Return != 0 if the user accept to quit anyway.
*/
int xconf_quitwosave()
{
	return xconf_yesno(MSG_U(T_QUIT,"Quit without saving ?")
		,MSG_U(I_QUIT,"You have modified the information somewhat\n"
		 "Are you sure you want to quit ?\n")
		,help_nil)==MENU_YES;
}
/*
	Return != 0 if the user confirm something.
*/
int xconf_areyousure(const char *msg)
{
	return xconf_yesno(MSG_U(T_AREYOUSURE,"Are you sure ?")
		,msg
		,help_nil)==MENU_YES;
}

/*
	Ask the user for a confirmation before deleting a record
	Return != 0 if ok.
*/
int xconf_delok()
{
	return xconf_areyousure(
		MSG_U(I_DELRECORD,"Are you sure you want to delete this record ?"));
}

