#pragma interface
#ifndef MISC_H
#define MISC_H

#include <stdio.h>

class ARRAY_OBJ{
protected:
	char modified;
	/*~PROTOBEG~ ARRAY_OBJ */
public:
	ARRAY_OBJ (void);
	virtual int edit (void);
	void rstmodified (void);
	void setmodified (void);
	virtual int was_modified (void);
	virtual ~ARRAY_OBJ (void);
	/*~PROTOEND~ ARRAY_OBJ */
};

class ARRAY: public ARRAY_OBJ{
protected:
	int is_owner;	// Is this object allowed to delete
			// the objects it contains ?
	ARRAY_OBJ **tb;
	int nb;
	int maxtb;	// Current maximum length of the table
	int increm;	// growth rate of tb
	/*~PROTOBEG~ ARRAY */
public:
	ARRAY (void);
	void add (ARRAY_OBJ *pt);
	void delall (void);
	int editone (ARRAY_OBJ *e);
	int editone (int no);
protected:
	ARRAY_OBJ *getitem (int no)const;
public:
	int getnb (void)const;
protected:
	void grow (void);
public:
	void insert (int pos, ARRAY_OBJ *pt);
	int lookup (ARRAY_OBJ *o)const;
	int manage_edit (ARRAY_OBJ *e, int code);
	int manage_edit (ARRAY_OBJ *e, int code, int insertpos);
	void moveto (ARRAY_OBJ *o, int newpos);
	void neverdelete (void);
	int remove (ARRAY_OBJ *obj);
	void remove_all (void);
	void remove_del (ARRAY_OBJ *obj);
	void remove_del (int no);
	void rstmodified (void);
	void setgrowth (int _increm);
	void sort (int (*cmp)(const ARRAY_OBJ *, const ARRAY_OBJ *));
	virtual int was_modified (void);
	virtual int write (void);
	virtual ~ARRAY (void);
	/*~PROTOEND~ ARRAY */
};


#ifndef CONFIGF_H
	#include "configf.h"
#endif
#ifndef SSTRING_H
	#include "sstring.h"
#endif

enum MENU_CONTEXT{
	MENU_UNKNOWN,		// Special menu which is unknown to modules
						// or is not yet module aware
	MENU_NETWORK,		// main network menu
	MENU_MAIN,			// Main linuxconf menu
	MENU_CONTROL,		// Control panel
};

class DIALOG;

#ifndef DIALOG_H
	#include "dialog.h"
#endif

class PRIVILEGE;

#include "misc.p"


#endif


