#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "misc.h"
#include "misc.m"

/*
	Do a malloc with error message generation. It quit if out of memory.
*/
void *malloc_err (int size)
{
	void *ret = malloc(size);
	if (ret == NULL){
		xconf_error (MSG_U(E_OUTOFMEM,"Out of memory\n"));
		exit (-1);
	}
	return ret;
}

/*
	Do a strdup with error message generation. It quit if out of memory.
*/
char *strdup_err (const char *str)
{
	char *ret = strdup (str);
	if (ret == NULL){
		xconf_error (MSG_R(E_OUTOFMEM));
		exit (-1);
	}
	return ret;
}