#include <stdlib.h>
#include <string.h>
#include <limits.h>
#include <sys/stat.h>
#include "misc.h"
#include "../paths.h"

static char *lang = strdup("eng");
static HELP_FILE *first = NULL;

/*
	Record the language to use for help files
*/
void help_setlang (const char *_lang, const char *envvar)
{
	free (lang);
	if (envvar != NULL){
		const char *pt = getenv(envvar);
		if (pt != NULL) _lang = pt;
	}
	lang = strdup(_lang);
}

/*
	Record the spec of a config file that is maintain (or used) by linuxconf
*/
PUBLIC HELP_FILE::HELP_FILE(
	const char *_subdir,
	const char *_fname)
{
	/* #Specification: help file / path
		All help file of linuxconf are under the same directory
		USR_LIB_CONF. Each subject (netconf, userconf, etc...) has
		its own subdirectory under this directory. In these
		subdirectories, we have file ending with the extension help.
	*/
	subdir = _subdir;
	fname = _fname;
	path = NULL;
	next = first;
	first = this;
}

/*
	Return the path of the configuration file
*/
PUBLIC const char *HELP_FILE::getpath()
{
	if (path == NULL && fname != NULL){
		char buf[200];
		/* #Specification: help file / path / exception
			HELP_FILE object for modules may be defined with a subdir
			component being an absolute path. The standard
			linuxconf help base path is not used then. The subdir (which
			is indeed a full absolute path) is concatenated with
			this way to create the basepath of the help file.

			#
			subdir/help.lang/filename
			#
		*/
		if (subdir[0] == '/'){
			sprintf (buf,"%s/help.%s/%s",subdir,lang,fname);
		}else{
			sprintf (buf,"%s/help.%s/%s/%s",HELP_BASEPATH,lang,subdir,fname);
		}
		path = strdup (buf);
	}	
	return path;
}
/*
	Provide the relative path of a help file (relative to /usr/lib/linuxconf)
*/
PUBLIC void HELP_FILE::getrpath(char *rpath)
{
	rpath[0] = '\0';
	if (fname != NULL){
		if (subdir[0] == '/'){
			sprintf (rpath,"%s/help.%s/%s",subdir,lang,fname);
		}else{
			sprintf (rpath,"help.%s/%s/%s",lang,subdir,fname);
		}
	}
}
/*
	Check if all the help file of the application are there.
	This is a runtime check even if it is only requiered for testing
	the software.
*/
void helpf_checkall()
{
	HELP_FILE *f = first;
	while (f != NULL){
		const char *path = f->getpath();
		if (path != NULL){
			char abspath[PATH_MAX];
			sprintf (abspath,"%s.help",path);
			struct stat st;
			printf ("%s%s\n"
				,stat(abspath,&st)!=-1 ? "\t" : "***\t"
				,abspath);
		}
		f = f->next;
	}
}

HELP_FILE help_nil (NULL,NULL);
